/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.graph.algorithms.triangulation;

import com.anylogic.engine.graph.Edge;
import com.anylogic.engine.graph.Graph;
import com.anylogic.engine.graph.Vertex;
import com.anylogic.engine.graph.algorithms.GeometryUtils;
import com.anylogic.engine.graph.algorithms.IGeometryInfoFactory;
import com.anylogic.engine.graph.algorithms.triangulation.Triangle;
import com.anylogic.engine.graph.algorithms.triangulation.Triangulation;
import com.anylogic.engine.graph.algorithms.triangulation.TriangulationUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class TriangulationDualGraphBuilder {
    private Triangulation a;
    private IGeometryInfoFactory e;
    private Map<Triangle, Vertex> h;

    public TriangulationDualGraphBuilder(Triangulation triangulation, IGeometryInfoFactory iGeometryInfoFactory) {
        this.a = triangulation;
        this.e = iGeometryInfoFactory;
    }

    public Triangulation getTriangulation() {
        return this.a;
    }

    public IGeometryInfoFactory getGeometryInfoFactory() {
        return this.e;
    }

    public Map<Triangle, Vertex> getVertexDictionary() {
        return this.h;
    }

    public Graph build() {
        Graph graph = new Graph();
        Map<Triangle, Vertex> map = this.a(graph, this.a.getTriangles());
        this.a(graph, map);
        this.h = map;
        return graph;
    }

    private Map<Triangle, Vertex> a(Graph graph, Collection<Triangle> collection) {
        LinkedHashMap<Triangle, Vertex> linkedHashMap = new LinkedHashMap<Triangle, Vertex>();
        for (Triangle triangle : collection) {
            Vertex vertex = this.a(graph, triangle);
            if (vertex == null) continue;
            linkedHashMap.put(triangle, vertex);
        }
        return linkedHashMap;
    }

    private Set<Edge> a(Graph graph, Map<Triangle, Vertex> map) {
        LinkedHashSet<Edge> linkedHashSet = new LinkedHashSet<Edge>();
        for (Triangle triangle : map.keySet()) {
            Vertex vertex = map.get(triangle);
            for (Triangle triangle2 : triangle.getIncidents()) {
                Vertex vertex2 = map.get(triangle2);
                if (vertex2 == null || vertex.findEdge(vertex2, false) != null) continue;
                Edge edge = this.addEdge(graph, vertex, vertex2);
                linkedHashSet.add(edge);
            }
        }
        return linkedHashSet;
    }

    private Vertex a(Graph graph, Triangle triangle) {
        GeometryUtils.Point point = TriangulationUtils.getCentroidPoint(triangle);
        if (point == null) {
            return null;
        }
        double d2 = point.getX();
        double d3 = point.getY();
        Vertex vertex = this.addCentroidVertex(graph, triangle, d2, d3);
        return vertex;
    }

    protected Vertex addCentroidVertex(Graph graph, Triangle triangle, double d2, double d3) {
        Vertex vertex = graph.addVertex();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("X", d2);
        hashMap.put("Y", d3);
        GeometryUtils.addGeometryInfo(vertex, this.e, hashMap);
        return vertex;
    }

    protected Edge addEdge(Graph graph, Vertex vertex, Vertex vertex2) {
        Edge edge = graph.addEdge(vertex, vertex2);
        GeometryUtils.addGeometryInfo(edge, this.e, Collections.emptyMap());
        return edge;
    }

    public void dispose() {
        this.a = null;
        this.e = null;
        this.h.clear();
    }
}

