/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.graph.algorithms.triangulation;

import com.anylogic.engine.graph.Edge;
import com.anylogic.engine.graph.Vertex;
import com.anylogic.engine.graph.algorithms.GeometryUtils;
import com.anylogic.engine.graph.algorithms.IGeometryInfoFactory;
import com.anylogic.engine.graph.algorithms.triangulation.Triangle;
import com.anylogic.engine.graph.algorithms.triangulation.Triangulation;
import com.anylogic.engine.graph.algorithms.triangulation.TriangulationUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class TriangulationFragmentator {
    private IGeometryInfoFactory a;

    public TriangulationFragmentator(IGeometryInfoFactory iGeometryInfoFactory) {
        if (iGeometryInfoFactory == null) {
            throw new IllegalArgumentException("Argument 'geometryInfoFactory' is null");
        }
        this.a = iGeometryInfoFactory;
    }

    public IGeometryInfoFactory getGeometryInfoFactory() {
        return this.a;
    }

    public void fragmentation(Triangulation triangulation) {
        if (triangulation == null) {
            throw new IllegalArgumentException("Argument 'triangulation' is null");
        }
        this.fragmentation(triangulation, triangulation.getTriangles());
    }

    protected Map<Triangle, Set<Triangle>> fragmentation(Triangulation triangulation, Collection<Triangle> collection) {
        Map<Triangle, Vertex> map = this.a(triangulation, collection);
        return this.a(triangulation, map);
    }

    private Map<Triangle, Vertex> a(Triangulation triangulation, Collection<Triangle> collection) {
        LinkedHashMap<Triangle, Vertex> linkedHashMap = new LinkedHashMap<Triangle, Vertex>();
        for (Triangle triangle : collection) {
            Vertex vertex = this.a(triangulation, triangle);
            if (vertex == null) continue;
            linkedHashMap.put(triangle, vertex);
        }
        return linkedHashMap;
    }

    private Map<Triangle, Set<Triangle>> a(Triangulation triangulation, Map<Triangle, Vertex> map) {
        LinkedHashMap<Triangle, Set<Triangle>> linkedHashMap = new LinkedHashMap<Triangle, Set<Triangle>>();
        for (Triangle triangle : map.keySet()) {
            LinkedHashSet<Triangle> linkedHashSet = new LinkedHashSet<Triangle>();
            linkedHashMap.put(triangle, linkedHashSet);
            Vertex vertex = map.get(triangle);
            LinkedHashSet<Edge> linkedHashSet2 = new LinkedHashSet<Edge>(triangle.getEdges());
            triangulation.removeTriangle(triangle);
            for (Edge edge : linkedHashSet2) {
                Edge edge2;
                Vertex vertex2 = edge.getSource();
                Vertex vertex3 = edge.getTarget();
                Edge edge3 = vertex.findEdge(vertex2, false);
                if (edge3 == null) {
                    edge3 = this.addEdge(triangulation, vertex, vertex2);
                }
                if ((edge2 = vertex.findEdge(vertex3, false)) == null) {
                    edge2 = this.addEdge(triangulation, vertex, vertex3);
                }
                Triangle triangle2 = triangulation.addTriangle(edge, edge3, edge2);
                linkedHashSet.add(triangle2);
            }
        }
        return linkedHashMap;
    }

    private Vertex a(Triangulation triangulation, Triangle triangle) {
        GeometryUtils.Point point = TriangulationUtils.getCentroidPoint(triangle);
        if (point == null) {
            return null;
        }
        double d2 = point.getX();
        double d3 = point.getY();
        Vertex vertex = this.addCentroidVertex(triangulation, triangle, d2, d3);
        return vertex;
    }

    protected Vertex addCentroidVertex(Triangulation triangulation, Triangle triangle, double d2, double d3) {
        Vertex vertex = triangulation.addVertex();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("X", d2);
        hashMap.put("Y", d3);
        GeometryUtils.addGeometryInfo(vertex, this.a, hashMap);
        return vertex;
    }

    protected Edge addEdge(Triangulation triangulation, Vertex vertex, Vertex vertex2) {
        Edge edge = triangulation.addEdge(vertex, vertex2);
        GeometryUtils.addGeometryInfo(edge, this.a, Collections.emptyMap());
        return edge;
    }

    public void dispose() {
        this.a = null;
    }
}

