/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.graph.algorithms.triangulation;

import com.anylogic.engine.graph.Edge;
import com.anylogic.engine.graph.Graph;
import com.anylogic.engine.graph.Vertex;
import com.anylogic.engine.graph.algorithms.GeometryUtils;
import com.anylogic.engine.graph.algorithms.IGeometryInfoFactory;
import com.anylogic.engine.graph.algorithms.impl.GeometryInfoFactoryImpl;
import com.anylogic.engine.graph.algorithms.triangulation.Triangle;
import com.anylogic.engine.graph.algorithms.triangulation.Triangulation;
import com.anylogic.engine.graph.algorithms.triangulation.TriangulationUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class Triangulator {
    private static final double a = 1.0E-6;
    private static final double e = 1.0E-6;
    private Graph h;
    private IGeometryInfoFactory k;
    private IGeometryInfoFactory d;

    public Triangulator(Graph graph, IGeometryInfoFactory iGeometryInfoFactory) {
        if (graph == null) {
            throw new IllegalArgumentException("Argument 'graph' is null");
        }
        if (iGeometryInfoFactory == null) {
            throw new IllegalArgumentException("Argument 'geometryInfoFactory' is null");
        }
        this.d = new GeometryInfoFactoryImpl();
        this.h = graph;
        this.k = iGeometryInfoFactory;
    }

    public Graph getGraph() {
        return this.h;
    }

    public IGeometryInfoFactory getGeometryInfoFactory() {
        return this.k;
    }

    public Triangulation triangulate() {
        LinkedHashSet<Vertex> linkedHashSet = new LinkedHashSet<Vertex>();
        linkedHashSet.addAll(this.h.getVertices());
        return this.triangulate(linkedHashSet);
    }

    public Triangulation triangulate(Collection<Vertex> collection) {
        LinkedHashSet<Edge> linkedHashSet = new LinkedHashSet<Edge>();
        linkedHashSet.addAll(this.h.getEdges());
        return this.triangulate(collection, linkedHashSet);
    }

    public Triangulation triangulate(Collection<Vertex> collection, Collection<Edge> collection2) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 'vertices' is null");
        }
        if (collection2 == null) {
            throw new IllegalArgumentException("Argument 'structureEdges' is null");
        }
        Triangulation triangulation = new Triangulation(this.h);
        Triangle triangle = this.a(triangulation, collection);
        Set<Triangle> set = this.a(triangulation, collection, collection2);
        this.a(triangulation, set, triangle);
        return triangulation;
    }

    private Triangle a(Triangulation triangulation, Collection<Vertex> collection) {
        double d2;
        double d3;
        Iterator<Vertex> iterator = collection.iterator();
        Vertex vertex = iterator.next();
        Object t = GeometryUtils.getGeometryInfo(vertex);
        double d4 = t.getX();
        double d5 = t.getY();
        double d6 = d4;
        double d7 = d5;
        while (iterator.hasNext()) {
            Vertex vertex2 = iterator.next();
            Object t2 = GeometryUtils.getGeometryInfo(vertex2);
            d3 = t2.getX();
            d2 = t2.getY();
            if (d3 < d4) {
                d4 = d3;
            }
            if (d3 > d6) {
                d6 = d3;
            }
            if (d2 < d5) {
                d5 = d2;
            }
            if (!(d2 > d7)) continue;
            d7 = d2;
        }
        double d8 = d6 - d4;
        d3 = d7 - d5;
        d2 = d8 > d3 ? d8 : d3;
        double d9 = (d6 + d4) * 0.5;
        double d10 = (d7 + d5) * 0.5;
        Vertex vertex3 = this.a(triangulation, d9 - 2.0 * d2, d10 - d2);
        Vertex vertex4 = this.a(triangulation, d9, d10 + 2.0 * d2);
        Vertex vertex5 = this.a(triangulation, d9 + 2.0 * d2, d10 - d2);
        Triangle triangle = this.a(triangulation, vertex3, vertex4, vertex5);
        return triangle;
    }

    private Set<Triangle> a(Triangulation triangulation, Collection<Vertex> collection, Collection<Edge> collection2) {
        LinkedHashSet<Triangle> linkedHashSet = new LinkedHashSet<Triangle>();
        for (Vertex vertex : collection) {
            LinkedHashSet<Edge> linkedHashSet2 = new LinkedHashSet<Edge>();
            LinkedHashSet<Edge> linkedHashSet3 = new LinkedHashSet<Edge>();
            Set<Triangle> set = this.e(triangulation.getTriangles(), vertex);
            LinkedHashSet<Vertex> linkedHashSet4 = new LinkedHashSet<Vertex>();
            for (Triangle triangle : set) {
                linkedHashSet4.addAll(triangle.getVertices());
            }
            if (this.a(linkedHashSet4, vertex)) continue;
            for (Triangle triangle : set) {
                for (Serializable serializable : triangle.getEdges()) {
                    if (linkedHashSet2.contains(serializable)) {
                        linkedHashSet3.add((Edge)serializable);
                        continue;
                    }
                    linkedHashSet2.add((Edge)serializable);
                }
                triangulation.removeTriangle(triangle);
                linkedHashSet.remove(triangle);
            }
            linkedHashSet2.removeAll(linkedHashSet3);
            for (Edge edge : linkedHashSet3) {
                if (collection2.contains(edge)) continue;
                triangulation.removeEdge(edge);
            }
            for (Edge edge : linkedHashSet2) {
                Serializable serializable;
                serializable = this.a(triangulation, vertex, edge.getSource(), edge.getTarget());
                linkedHashSet.add((Triangle)serializable);
            }
        }
        return linkedHashSet;
    }

    private boolean a(Collection<Vertex> collection, Vertex vertex) {
        boolean bl = false;
        for (Vertex vertex2 : collection) {
            double d2 = GeometryUtils.getDistance(vertex2, vertex);
            if (!(d2 < 1.0E-6)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private Set<Triangle> e(Collection<Triangle> collection, Vertex vertex) {
        LinkedHashSet<Triangle> linkedHashSet = new LinkedHashSet<Triangle>();
        Object t = GeometryUtils.getGeometryInfo(vertex);
        double d2 = t.getX();
        double d3 = t.getY();
        for (Triangle triangle : collection) {
            double d4;
            double d5;
            double d6;
            Iterator<Vertex> iterator = triangle.getVertices().iterator();
            Vertex vertex2 = iterator.next();
            Object t2 = GeometryUtils.getGeometryInfo(vertex2);
            double d7 = t2.getX();
            double d8 = t2.getY();
            vertex2 = iterator.next();
            t2 = GeometryUtils.getGeometryInfo(vertex2);
            double d9 = t2.getX();
            if (!TriangulationUtils.inCircumcircle(d2, d3, d7, d8, d9, d6 = t2.getY(), d5 = (t2 = GeometryUtils.getGeometryInfo(vertex2 = iterator.next())).getX(), d4 = t2.getY(), 1.0E-6)) continue;
            linkedHashSet.add(triangle);
        }
        return linkedHashSet;
    }

    private void a(Triangulation triangulation, Set<Triangle> set, Triangle triangle) {
        LinkedHashSet<Vertex> linkedHashSet = new LinkedHashSet<Vertex>(triangle.getVertices());
        for (Vertex vertex : linkedHashSet) {
            triangulation.removeVertex(vertex);
        }
    }

    private void a(Triangulation triangulation, Set<Triangle> set, Collection<Edge> collection) {
        for (Edge edge : collection) {
            Set<Edge> set2 = this.a(triangulation.getGraph().getEdges(), edge);
            set2.remove(edge);
            if (set2.isEmpty()) continue;
            LinkedHashSet<Triangle> linkedHashSet = new LinkedHashSet<Triangle>();
            for (Edge edge2 : set2) {
                Iterator<Object> iterator = TriangulationUtils.getTriangulationInfo(edge2);
                linkedHashSet.addAll(iterator.getTriangles());
            }
            LinkedHashSet<Edge> serializable2 = new LinkedHashSet<Edge>();
            for (Triangle triangle : linkedHashSet) {
                serializable2.addAll(triangle.getEdges());
            }
            serializable2.removeAll(set2);
            for (Triangle triangle : linkedHashSet) {
                triangulation.removeTriangle(triangle);
            }
            for (Edge edge3 : set2) {
                if (collection.contains(edge3)) continue;
                triangulation.removeEdge(edge3);
            }
            for (Edge edge4 : serializable2) {
                Edge edge5;
                Vertex vertex = edge4.getSource();
                Vertex vertex2 = edge4.getTarget();
                if (edge.getSource() == vertex || edge.getSource() == vertex2) continue;
                Edge edge6 = vertex.findEdge(edge.getSource(), false);
                if (edge6 == null) {
                    edge6 = this.a(triangulation, edge.getSource(), vertex);
                }
                if ((edge5 = vertex2.findEdge(edge.getSource(), false)) == null) {
                    edge5 = this.a(triangulation, edge.getSource(), vertex2);
                }
                if (!triangulation.findTriangles(edge6, edge5, edge).isEmpty()) continue;
                triangulation.addTriangle(edge6, edge5, edge4);
            }
        }
    }

    private Set<Edge> a(Collection<Edge> collection, Edge edge) {
        LinkedHashSet<Edge> linkedHashSet = new LinkedHashSet<Edge>();
        for (Edge edge2 : collection) {
            if (!GeometryUtils.isIntersectedLine(edge2, edge, false)) continue;
            linkedHashSet.add(edge2);
        }
        return linkedHashSet;
    }

    private Triangle a(Triangulation triangulation, Vertex vertex, Vertex vertex2, Vertex vertex3) {
        if (!triangulation.findTriangles(vertex, vertex2, vertex3).isEmpty()) {
            throw new RuntimeException();
        }
        Edge edge = this.a(triangulation, vertex, vertex2);
        Edge edge2 = this.a(triangulation, vertex2, vertex3);
        Edge edge3 = this.a(triangulation, vertex3, vertex);
        return triangulation.addTriangle(edge, edge2, edge3);
    }

    private Edge a(Triangulation triangulation, Vertex vertex, Vertex vertex2) {
        Edge edge = vertex.findEdge(vertex2, false);
        if (edge != null) {
            return edge;
        }
        edge = triangulation.addEdge(vertex, vertex2);
        GeometryUtils.addGeometryInfo(edge, this.k, Collections.emptyMap());
        return edge;
    }

    private Vertex a(Triangulation triangulation, double d2, double d3) {
        Vertex vertex = triangulation.addVertex();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("X", d2);
        hashMap.put("Y", d3);
        GeometryUtils.addGeometryInfo(vertex, this.d, hashMap);
        return vertex;
    }

    public void dispose() {
        this.h = null;
        this.k = null;
        this.d = null;
    }
}

