/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.internal.annotation.code_wizard;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.internal.ae;
import com.anylogic.engine.internal.annotation.code_wizard.IFieldValidator;
import com.anylogic.engine.internal.annotation.code_wizard.RandomDistributionEntity;
import com.anylogic.engine.internal.annotation.code_wizard.RandomDistributionParameterDescriptor;
import com.anylogic.engine.internal.annotation.code_wizard.Status;

@AnyLogicInternalAPI
public enum ValidatorEnum {
    NO_VALIDATE(new IFieldValidator<Object, Object>(){

        @Override
        public Status validate(Object object, Object object2) {
            return Status.OK_STATUS;
        }
    }),
    MIN_LESS_THAN_OR_EQUAL_TO_MAX_DOUBLE(new IFieldValidator<RandomDistributionEntity, Double>(){

        @Override
        public Status validate(RandomDistributionEntity randomDistributionEntity, Double d2) {
            Double d3 = (Double)ValidatorEnum.getValue("min", randomDistributionEntity);
            Double d4 = (Double)ValidatorEnum.getValue("max", randomDistributionEntity);
            if (d3 > d4) {
                return new Status(4, ae.mga);
            }
            return Status.OK_STATUS;
        }
    }),
    MIN_LESS_THAN_OR_EQUAL_TO_MAX_INT(new IFieldValidator<RandomDistributionEntity, Integer>(){

        @Override
        public Status validate(RandomDistributionEntity randomDistributionEntity, Integer n2) {
            Integer n3 = (Integer)ValidatorEnum.getValue("min", randomDistributionEntity);
            Integer n4 = (Integer)ValidatorEnum.getValue("max", randomDistributionEntity);
            if (n3 > n4) {
                return new Status(4, ae.mga);
            }
            return Status.OK_STATUS;
        }
    }),
    BEETWEEN_ZERO_AND_ONE(new IFieldValidator<RandomDistributionEntity, Double>(){

        @Override
        public Status validate(RandomDistributionEntity randomDistributionEntity, Double d2) {
            if (d2 > 1.0 || d2 < 0.0) {
                return new Status(4, ae.mga);
            }
            return Status.OK_STATUS;
        }
    }),
    GREATER_THAN_ZERO_DOUBLE(new IFieldValidator<RandomDistributionEntity, Double>(){

        @Override
        public Status validate(RandomDistributionEntity randomDistributionEntity, Double d2) {
            if (d2 <= 0.0) {
                return new Status(4, ae.mga);
            }
            return Status.OK_STATUS;
        }
    }),
    STRETCH_IS_NOT_ZERO(new IFieldValidator<RandomDistributionEntity, Double>(){

        @Override
        public Status validate(RandomDistributionEntity randomDistributionEntity, Double d2) {
            Double d3 = (Double)ValidatorEnum.getValue("stretch", randomDistributionEntity);
            Double d4 = (Double)ValidatorEnum.getValue("min", randomDistributionEntity);
            Double d5 = (Double)ValidatorEnum.getValue("max", randomDistributionEntity);
            Double d6 = (Double)ValidatorEnum.getValue("shift", randomDistributionEntity);
            if (d3 == 0.0 && (d6 < d4 || d6 > d5)) {
                return new Status(4, ae.hfb);
            }
            return Status.OK_STATUS;
        }
    }),
    GREATER_THAN_ZERO_INT(new IFieldValidator<RandomDistributionEntity, Integer>(){

        @Override
        public Status validate(RandomDistributionEntity randomDistributionEntity, Integer n2) {
            if (n2 <= 0) {
                return new Status(4, ae.mga);
            }
            return Status.OK_STATUS;
        }
    }),
    GREATER_THAN_OR_EQUALS_TO_ZERO_INT(new IFieldValidator<RandomDistributionEntity, Integer>(){

        @Override
        public Status validate(RandomDistributionEntity randomDistributionEntity, Integer n2) {
            if (n2 <= 0) {
                return new Status(4, ae.mga);
            }
            return Status.OK_STATUS;
        }
    }),
    NOT_EQUALS_TO_ZERO_DOUBLE(new IFieldValidator<RandomDistributionEntity, Double>(){

        @Override
        public Status validate(RandomDistributionEntity randomDistributionEntity, Double d2) {
            if (d2 == 0.0) {
                return new Status(4, ae.mga);
            }
            return Status.OK_STATUS;
        }
    }),
    DN_LESS_THAN_OR_EQUALS_TO_PS(new IFieldValidator<RandomDistributionEntity, Integer>(){

        @Override
        public Status validate(RandomDistributionEntity randomDistributionEntity, Integer n2) {
            Integer n3 = (Integer)ValidatorEnum.getValue("dn", randomDistributionEntity);
            Integer n4 = (Integer)ValidatorEnum.getValue("ps", randomDistributionEntity);
            if (n3 > n4) {
                return new Status(4, ae.mga);
            }
            return Status.OK_STATUS;
        }
    }),
    GREATER_THAN_OR_EQUALS_TO_ZERO_DOUBLE(new IFieldValidator<RandomDistributionEntity, Double>(){

        @Override
        public Status validate(RandomDistributionEntity randomDistributionEntity, Double d2) {
            if (d2 < 0.0) {
                return new Status(4, ae.mga);
            }
            return Status.OK_STATUS;
        }
    }),
    MODE_BETWEEN_MIN_AND_MAX(new IFieldValidator<RandomDistributionEntity, Double>(){

        @Override
        public Status validate(RandomDistributionEntity randomDistributionEntity, Double d2) {
            Double d3 = (Double)ValidatorEnum.getValue("min", randomDistributionEntity);
            Double d4 = (Double)ValidatorEnum.getValue("max", randomDistributionEntity);
            Double d5 = (Double)ValidatorEnum.getValue("mode", randomDistributionEntity);
            if (d3 > d5 || d4 < d5) {
                return new Status(4, ae.mga);
            }
            return Status.OK_STATUS;
        }
    }),
    LEFT_LESS_THAN_OR_EQUAL_TO_RIGHT_DOUBLE(new IFieldValidator<RandomDistributionEntity, Double>(){

        @Override
        public Status validate(RandomDistributionEntity randomDistributionEntity, Double d2) {
            Double d3 = (Double)ValidatorEnum.getValue("left", randomDistributionEntity);
            Double d4 = (Double)ValidatorEnum.getValue("right", randomDistributionEntity);
            if (d3 > d4) {
                return new Status(4, ae.mga);
            }
            return Status.OK_STATUS;
        }
    }),
    MODE_BETWEEN_LEFT_AND_RIGHT(new IFieldValidator<RandomDistributionEntity, Double>(){

        @Override
        public Status validate(RandomDistributionEntity randomDistributionEntity, Double d2) {
            Double d3 = (Double)ValidatorEnum.getValue("left", randomDistributionEntity);
            Double d4 = (Double)ValidatorEnum.getValue("right", randomDistributionEntity);
            Double d5 = (Double)ValidatorEnum.getValue("mode", randomDistributionEntity);
            if (d3 > d5 || d4 < d5) {
                return new Status(4, ae.mga);
            }
            return Status.OK_STATUS;
        }
    });

    private IFieldValidator<?, ?> validator;

    private ValidatorEnum(IFieldValidator<?, ?> iFieldValidator) {
        this.validator = iFieldValidator;
    }

    public IFieldValidator<?, ?> getValidator() {
        return this.validator;
    }

    private static <T> T getValue(String string, RandomDistributionEntity randomDistributionEntity) {
        RandomDistributionParameterDescriptor<?> randomDistributionParameterDescriptor = randomDistributionEntity.getParameterDescriptor(string);
        return (T)randomDistributionParameterDescriptor.getValue();
    }
}

