/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.internal.graph.impl;

import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.internal.graph.IGGraph;
import com.anylogic.engine.internal.graph.impl.GAbstractEdge;
import com.anylogic.engine.internal.graph.impl.GAbstractVertex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class GAbstractGraph<G extends GAbstractGraph<G, V, E>, V extends GAbstractVertex<G, V, E>, E extends GAbstractEdge<G, V, E>>
implements IGGraph<G, V, E>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Set<V> vertices = new LinkedHashSet<V>();
    protected Set<E> edges = new LinkedHashSet();
    @AnyLogicCustomSerialization
    protected transient Set<V> unmodifiableVertices = Collections.unmodifiableSet(this.vertices);
    @AnyLogicCustomSerialization
    protected transient Set<E> unmodifiableEdges = Collections.unmodifiableSet(this.edges);

    @Override
    public Set<V> getVertices() {
        return this.unmodifiableVertices;
    }

    @Override
    public Set<E> getEdges() {
        return this.unmodifiableEdges;
    }

    @Override
    public void addVertex(V v) {
        if (this.vertices.contains(v)) {
            throw new RuntimeException("'vertex' already exists in graph");
        }
        ((GAbstractVertex)v).setGraph((GAbstractGraph)this);
        this.vertices.add(v);
    }

    @Override
    public void removeVertex(V v) {
        if (!this.vertices.contains(v)) {
            throw new RuntimeException("Cannot found 'vertex' in graph");
        }
        ArrayList arrayList = new ArrayList(((GAbstractVertex)v).getEdges());
        this.removeEdges(arrayList);
        this.vertices.remove(v);
        ((GAbstractVertex)v).setGraph(null);
    }

    public void removeVertices(Collection<V> collection) {
        HashSet hashSet = new HashSet();
        for (GAbstractVertex gAbstractVertex : collection) {
            if (!collection.contains(gAbstractVertex)) continue;
            hashSet.addAll(gAbstractVertex.getEdges());
        }
        this.removeEdges(hashSet);
        this.vertices.removeAll(collection);
    }

    @Override
    public void addEdge(E e2, V v, V v2) {
        if (!this.vertices.contains(v)) {
            throw new RuntimeException("Cannot found 'source' in graph");
        }
        if (!this.vertices.contains(v2)) {
            throw new RuntimeException("Cannot found 'target' in graph");
        }
        if (this.edges.contains(e2)) {
            throw new RuntimeException("'edge' already exists in graph");
        }
        ((GAbstractEdge)e2).setGraph((GAbstractGraph)this);
        ((GAbstractEdge)e2).set(v, v2);
        ((GAbstractVertex)v).addEdge(e2);
        ((GAbstractVertex)v2).addEdge(e2);
        this.edges.add(e2);
    }

    @Override
    public void removeEdge(E e2) {
        if (e2 == null) {
            throw new IllegalArgumentException("Argument 'edge' is null");
        }
        if (!this.edges.contains(e2)) {
            throw new RuntimeException("Cannot found 'edge' in graph");
        }
        this.edges.remove(e2);
        ((GAbstractVertex)((GAbstractEdge)e2).getSource()).removeEdge(e2);
        ((GAbstractVertex)((GAbstractEdge)e2).getTarget()).removeEdge(e2);
        ((GAbstractEdge)e2).setGraph(null);
        ((GAbstractEdge)e2).set(null, null);
    }

    public void removeEdges(Collection<? extends E> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 'edges' is null");
        }
        for (GAbstractEdge gAbstractEdge : collection) {
            if (!collection.contains(gAbstractEdge)) continue;
            ((GAbstractVertex)gAbstractEdge.getSource()).removeEdge(gAbstractEdge);
            ((GAbstractVertex)gAbstractEdge.getTarget()).removeEdge(gAbstractEdge);
        }
        this.edges.removeAll(collection);
    }

    public void removeAllEdges() {
        this.removeEdges(new ArrayList<E>(this.edges));
    }
}

