/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.internal.graph.pathfinding.astar;

import com.anylogic.engine.internal.graph.IGEdge;
import com.anylogic.engine.internal.graph.IGFilter;
import com.anylogic.engine.internal.graph.IGGraph;
import com.anylogic.engine.internal.graph.IGVertex;
import com.anylogic.engine.internal.graph.pathfinding.GPath;
import com.anylogic.engine.internal.graph.pathfinding.astar.GAStarCosts;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class GAStar<G extends IGGraph<G, V, E>, V extends IGVertex<G, V, E>, E extends IGEdge<G, V, E>> {
    private G a;
    private GAStarCosts<G, V, E> e;

    public GAStar(G g2, GAStarCosts<G, V, E> gAStarCosts) {
        if (g2 == null) {
            throw new IllegalArgumentException("Argument 'graph' is null");
        }
        if (gAStarCosts == null) {
            throw new IllegalArgumentException("Argument 'costs' is null");
        }
        this.a = g2;
        this.e = gAStarCosts;
    }

    public G getGraph() {
        return this.a;
    }

    public GAStarCosts<G, V, E> getCosts() {
        return this.e;
    }

    public GPath<G, V, E> compute(V v, V v2) {
        return this.compute(v, v2, null);
    }

    public GPath<G, V, E> compute(V v, V v2, IGFilter<G, V, E> iGFilter) {
        if (!this.a.getVertices().contains(v)) {
            throw new RuntimeException("Cannot found 'source' in graph");
        }
        if (!this.a.getVertices().contains(v2)) {
            throw new RuntimeException("Cannot found 'target' in graph");
        }
        if (v == v2) {
            return new GPath(this.a, new ArrayList());
        }
        HashMap<Object, Double> hashMap = new HashMap<Object, Double>();
        HashMap<IGVertex, Double> hashMap2 = new HashMap<IGVertex, Double>();
        HashMap<IGVertex, IGVertex> hashMap3 = new HashMap<IGVertex, IGVertex>();
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<IGVertex> hashSet2 = new HashSet<IGVertex>();
        PriorityQueue<Object> priorityQueue = new PriorityQueue<Object>(this.a.getVertices().size(), new n(hashMap));
        hashMap.put(v, 0.0);
        hashSet.add(v);
        priorityQueue.add(v);
        GPath<G, V, E> gPath = null;
        while (!priorityQueue.isEmpty()) {
            IGVertex iGVertex = (IGVertex)priorityQueue.poll();
            if (!this.a(iGFilter, (E)iGVertex)) continue;
            if (iGVertex == v2) {
                gPath = this.a(v, v2, (Map<V, V>)hashMap3);
                break;
            }
            hashSet.remove(iGVertex);
            hashSet2.add(iGVertex);
            List list = iGVertex.getEdges();
            for (IGEdge iGEdge : list) {
                IGVertex iGVertex2;
                if (!this.a(iGFilter, (E)iGEdge) || !this.a(iGFilter, (E)(iGVertex2 = iGEdge.getOpposite(iGVertex))) || hashSet2.contains(iGVertex2)) continue;
                double d2 = this.a((E)iGEdge, (V)iGVertex2, (Map<V, Double>)hashMap);
                if (!hashSet.contains(iGVertex2)) {
                    double d3 = this.a(iGVertex2, v2);
                    hashMap.put(iGVertex2, d2);
                    hashMap2.put(iGVertex2, d3);
                    hashSet.add(iGVertex2);
                    priorityQueue.add(iGVertex2);
                    hashMap3.put(iGVertex2, iGVertex);
                    continue;
                }
                if (!((Double)hashMap.get(iGVertex2) > d2)) continue;
                hashMap.put(iGVertex2, d2);
                hashMap3.put(iGVertex2, iGVertex);
            }
        }
        return gPath;
    }

    private boolean a(IGFilter<G, V, E> iGFilter, V v) {
        return iGFilter == null ? true : iGFilter.accept(v);
    }

    private boolean a(IGFilter<G, V, E> iGFilter, E e2) {
        return iGFilter == null ? true : iGFilter.accept(e2);
    }

    private double a(E e2, V v, Map<V, Double> map) {
        V v2 = e2.getOpposite(v);
        double d2 = map.get(v2);
        boolean bl = e2.getTarget() == v;
        double d3 = this.e.getEdgeGCost(e2, bl);
        return d2 + d3;
    }

    private double a(V v, V v2) {
        return this.e.getVertexHCost(v, v2);
    }

    private GPath<G, V, E> a(V v, V v2, Map<V, V> map) {
        LinkedList<V> linkedList = new LinkedList<V>();
        Object object = v2;
        do {
            if (object == null) {
                return null;
            }
            linkedList.addFirst(object);
        } while ((object = (IGVertex)map.get(object)) != v);
        linkedList.addFirst(v);
        return new GPath(this.a, linkedList);
    }

    class n
    implements Comparator<V> {
        private Map<V, Double> e;

        public n(Map<V, Double> map) {
            this.e = map;
        }

        public int a(V v, V v2) {
            double d2;
            if (v == null) {
                return 1;
            }
            if (v2 == null) {
                return -1;
            }
            if (v == v2) {
                return 0;
            }
            double d3 = this.e.get(v);
            if (d3 > (d2 = this.e.get(v2).doubleValue())) {
                return 1;
            }
            if (d3 < d2) {
                return -1;
            }
            return 0;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((IGVertex)object, (IGVertex)object2);
        }
    }
}

