/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.internal.mesh.impl;

import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.internal.graph.impl.GAbstractGraph;
import com.anylogic.engine.internal.mesh.MPoint;
import com.anylogic.engine.internal.mesh.impl.MAbstractEdge;
import com.anylogic.engine.internal.mesh.impl.MAbstractMesh;
import com.anylogic.engine.internal.mesh.impl.MAbstractVertex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MMeshGrid<G extends MAbstractMesh<G, V, E>, V extends MAbstractVertex<G, V, E>, E extends MAbstractEdge<G, V, E>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @AnyLogicCustomSerialization
    private transient G a;
    private double e;
    private double h;
    private double k;
    private double d;
    private double j;
    @AnyLogicCustomSerialization
    private transient List<List<List<V>>> c;
    private int l;
    private int f;

    public MMeshGrid(G g2) {
        this.a = g2;
    }

    public double getMinX() {
        return this.e;
    }

    public double getMinY() {
        return this.h;
    }

    public double getMaxX() {
        return this.k;
    }

    public double getMaxY() {
        return this.d;
    }

    public int getXCount() {
        return this.l;
    }

    public int getYCount() {
        return this.f;
    }

    public double getCellSize() {
        return this.j;
    }

    public List<V> getVertices(double d2, double d3) {
        int n2 = this.getXIndex(d2);
        if (n2 == -1) {
            return Collections.emptyList();
        }
        int n3 = this.getYIndex(d3);
        if (n3 == -1) {
            return Collections.emptyList();
        }
        return this.c.get(n2).get(n3);
    }

    public List<V> getCell(int n2, int n3) {
        return this.c.get(n2).get(n3);
    }

    public int getXIndex(double d2) {
        if (d2 < this.e || d2 > this.k) {
            return -1;
        }
        return (int)Math.floor((d2 - this.e) / this.j);
    }

    public int getYIndex(double d2) {
        if (d2 < this.h || d2 > this.d) {
            return -1;
        }
        return (int)Math.floor((d2 - this.h) / this.j);
    }

    public void generateGrid(double d2, int n2) {
        int n3;
        this.j = d2;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MAX_VALUE;
        double d5 = Double.MIN_VALUE;
        double d6 = Double.MIN_VALUE;
        for (MPoint mPoint : ((MAbstractMesh)this.a).getPoints()) {
            if (mPoint.x < d3) {
                d3 = mPoint.x;
            }
            if (mPoint.y < d4) {
                d4 = mPoint.y;
            }
            if (mPoint.x > d5) {
                d5 = mPoint.x;
            }
            if (!(mPoint.y > d6)) continue;
            d6 = mPoint.y;
        }
        this.l = (int)Math.ceil((d5 - d3) / d2) + 2 * n2;
        this.f = (int)Math.ceil((d6 - d4) / d2) + 2 * n2;
        this.c = new ArrayList<List<List<V>>>(this.l);
        if (this.l == 0 || this.f == 0) {
            return;
        }
        this.e = d3 - (double)n2 * d2;
        this.h = d4 - (double)n2 * d2;
        this.k = this.e + (double)this.l * d2;
        this.d = this.h + (double)this.f * d2;
        int n4 = 0;
        while (n4 < this.l) {
            ArrayList arrayList = new ArrayList(this.f);
            this.c.add(arrayList);
            n3 = 0;
            while (n3 < this.f) {
                arrayList.add(new ArrayList(0));
                ++n3;
            }
            ++n4;
        }
        for (MAbstractVertex mAbstractVertex : ((GAbstractGraph)this.a).getVertices()) {
            d3 = Double.MAX_VALUE;
            d4 = Double.MAX_VALUE;
            d5 = Double.MIN_VALUE;
            d6 = Double.MIN_VALUE;
            for (MPoint mPoint : mAbstractVertex.getContour()) {
                if (mPoint.x < d3) {
                    d3 = mPoint.x;
                }
                if (mPoint.y < d4) {
                    d4 = mPoint.y;
                }
                if (mPoint.x > d5) {
                    d5 = mPoint.x;
                }
                if (!(mPoint.y > d6)) continue;
                d6 = mPoint.y;
            }
            n4 = this.getXIndex(d3);
            int n5 = this.getYIndex(d4);
            n3 = this.getXIndex(d5);
            int n6 = this.getYIndex(d6);
            int n7 = n4;
            while (n7 <= n3) {
                int n8 = n5;
                while (n8 <= n6) {
                    this.c.get(n7).get(n8).add(mAbstractVertex);
                    ++n8;
                }
                ++n7;
            }
        }
    }
}

