/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.internal.mesh.pathfinding;

import com.anylogic.engine.internal.mesh.MPoint;
import com.anylogic.engine.internal.mesh.impl.MAbstractEdge;
import com.anylogic.engine.internal.mesh.impl.MAbstractMesh;
import com.anylogic.engine.internal.mesh.impl.MAbstractVertex;
import com.anylogic.engine.internal.mesh.pathfinding.MChannel;
import com.anylogic.engine.internal.mesh.pathfinding.MPath;
import com.anylogic.engine.internal.mesh.pathfinding.MWaypoint;
import com.anylogic.engine.internal.mesh.pathfinding.astar.IMAStarCosts;
import com.anylogic.engine.internal.mesh.pathfinding.astar.MAStar;
import com.anylogic.engine.internal.mesh.pathfinding.funnel.MFunnel;
import java.io.Serializable;
import java.util.List;

public class MPathFinder<G extends MAbstractMesh<G, V, E>, V extends MAbstractVertex<G, V, E>, E extends MAbstractEdge<G, V, E>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private G a;
    private MAStar<G, V, E> e;

    public MPathFinder(G g2, IMAStarCosts<G, V, E> iMAStarCosts) {
        this.a = g2;
        this.e = new MAStar<G, V, E>(g2, iMAStarCosts);
    }

    public MPath<G, V, E> findPath(double d2, double d3, double d4, double d5) {
        return this.findPath(new MPoint(d2, d3), new MPoint(d4, d5));
    }

    public MPath<G, V, E> findPath(MPoint mPoint, MPoint mPoint2) {
        MChannel<G, V, E> mChannel = this.findChannel(mPoint, mPoint2);
        if (mChannel == null) {
            return null;
        }
        return this.findPath(mChannel, mPoint, mPoint2);
    }

    public MPath<G, V, E> findPath(MChannel<G, V, E> mChannel, MPoint mPoint, MPoint mPoint2) {
        MFunnel<G, V, E> mFunnel = new MFunnel<G, V, E>(mChannel, mPoint, mPoint2);
        List<MWaypoint<G, V, E>> list = mFunnel.stringPull();
        return new MPath<G, V, E>(this.a, mPoint, mPoint2, mChannel, list);
    }

    public MChannel<G, V, E> findChannel(double d2, double d3, double d4, double d5) {
        return this.e.compute(d2, d3, d4, d5);
    }

    public MChannel<G, V, E> findChannel(double d2, double d3, double d4, double d5, boolean bl) {
        return this.e.compute(d2, d3, d4, d5, bl);
    }

    public MChannel<G, V, E> findChannel(MPoint mPoint, MPoint mPoint2) {
        return this.e.compute(mPoint, mPoint2);
    }

    public MChannel<G, V, E> findChannel(MPoint mPoint, MPoint mPoint2, boolean bl) {
        return this.e.compute(mPoint, mPoint2, bl);
    }
}

