/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.internal.mesh.pathfinding.astar;

import com.anylogic.engine.internal.graph.impl.GAbstractGraph;
import com.anylogic.engine.internal.mesh.IMVertex;
import com.anylogic.engine.internal.mesh.MPoint;
import com.anylogic.engine.internal.mesh.impl.MAbstractEdge;
import com.anylogic.engine.internal.mesh.impl.MAbstractMesh;
import com.anylogic.engine.internal.mesh.impl.MAbstractVertex;
import com.anylogic.engine.internal.mesh.pathfinding.MChannel;
import com.anylogic.engine.internal.mesh.pathfinding.astar.IMAStarCosts;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

public class MAStar<G extends MAbstractMesh<G, V, E>, V extends MAbstractVertex<G, V, E>, E extends MAbstractEdge<G, V, E>>
extends GAbstractGraph<G, V, E> {
    private static final long serialVersionUID = 1L;
    protected G mesh;
    private IMAStarCosts<G, V, E> a;
    private Map<V, Double> e;
    private Map<V, Double> h;
    private Map<V, E> k;
    private Set<V> d;
    private Set<V> j;
    private PriorityQueue<V> c;
    private LinkedList<V> l;
    private LinkedList<E> f;

    public MAStar(G g2, IMAStarCosts<G, V, E> iMAStarCosts) {
        this.mesh = g2;
        this.a = iMAStarCosts;
        this.e = new HashMap<V, Double>();
        this.h = new HashMap<V, Double>();
        this.k = new HashMap<V, E>();
        this.d = new HashSet<V>();
        this.j = new HashSet<V>();
        this.c = new PriorityQueue(((GAbstractGraph)g2).getVertices().size(), new n(this.e));
        this.l = new LinkedList();
        this.f = new LinkedList();
    }

    private void a() {
        this.e.clear();
        this.h.clear();
        this.k.clear();
        this.d.clear();
        this.j.clear();
        this.c.clear();
        this.l.clear();
        this.f.clear();
    }

    public MChannel<G, V, E> compute(double d2, double d3, double d4, double d5) {
        return this.compute(d2, d3, d4, d5, true);
    }

    public MChannel<G, V, E> compute(double d2, double d3, double d4, double d5, boolean bl) {
        MPoint mPoint = new MPoint(d2, d3);
        MPoint mPoint2 = new MPoint(d4, d5);
        return this.compute(mPoint, mPoint2, bl);
    }

    public MChannel<G, V, E> compute(MPoint mPoint, MPoint mPoint2) {
        return this.compute(mPoint, mPoint2, true);
    }

    public MChannel<G, V, E> compute(MPoint mPoint, MPoint mPoint2, boolean bl) {
        IMVertex iMVertex = ((MAbstractMesh)this.mesh).findVertex(mPoint);
        IMVertex iMVertex2 = ((MAbstractMesh)this.mesh).findVertex(mPoint2);
        if (!((GAbstractGraph)this.mesh).getVertices().contains(iMVertex)) {
            throw new RuntimeException("Cannot found 'sourceVertex' in mesh");
        }
        if (!((GAbstractGraph)this.mesh).getVertices().contains(iMVertex)) {
            throw new RuntimeException("Cannot found 'targetVertex' in mesh");
        }
        if (iMVertex == iMVertex2) {
            return new MChannel();
        }
        this.a();
        this.e.put((Double)((Object)iMVertex), 0.0);
        this.d.add(iMVertex);
        this.c.add(iMVertex);
        while (!this.c.isEmpty()) {
            MAbstractVertex mAbstractVertex = (MAbstractVertex)this.c.poll();
            if (mAbstractVertex == iMVertex2) {
                return this.a(iMVertex, iMVertex2, mPoint, mPoint2, this.k);
            }
            this.d.remove(mAbstractVertex);
            this.j.add(mAbstractVertex);
            List list = bl ? mAbstractVertex.getOutcomingEdges() : mAbstractVertex.getEdges();
            for (MAbstractEdge mAbstractEdge : list) {
                MAbstractVertex mAbstractVertex2 = mAbstractEdge.getOpposite(mAbstractVertex);
                if (this.j.contains(mAbstractVertex2)) continue;
                double d2 = this.a(mAbstractVertex, mAbstractVertex2, mAbstractEdge, mPoint, this.e, this.k);
                if (!this.d.contains(mAbstractVertex2)) {
                    double d3 = this.e(mAbstractVertex, mAbstractVertex2, mAbstractEdge, mPoint2, this.h, this.k);
                    this.e.put((Double)((Object)mAbstractVertex2), d2);
                    this.h.put((Double)((Object)mAbstractVertex2), d3);
                    this.d.add(mAbstractVertex2);
                    this.c.add(mAbstractVertex2);
                    this.k.put((MAbstractEdge)((Object)mAbstractVertex2), (E)mAbstractEdge);
                    continue;
                }
                if (!(this.e.get(mAbstractVertex2) > d2)) continue;
                this.e.put((Double)((Object)mAbstractVertex2), d2);
                this.k.put((MAbstractEdge)((Object)mAbstractVertex2), (E)mAbstractEdge);
            }
        }
        return null;
    }

    private double a(V v, V v2, E e2, MPoint mPoint, Map<V, Double> map, Map<V, E> map2) {
        return this.a.getEdgeGCost(v, v2, e2, mPoint, map, map2);
    }

    private double e(V v, V v2, E e2, MPoint mPoint, Map<V, Double> map, Map<V, E> map2) {
        return this.a.getVertexHCost(v, v2, e2, mPoint, map, map2);
    }

    private MChannel<G, V, E> a(V v, V v2, MPoint mPoint, MPoint mPoint2, Map<V, E> map) {
        Object object = v2;
        do {
            this.l.addFirst(object);
            MAbstractEdge mAbstractEdge = (MAbstractEdge)map.get(object);
            object = (MAbstractVertex)mAbstractEdge.getOpposite(object);
            this.f.addFirst(mAbstractEdge);
        } while (object != v);
        this.l.addFirst(v);
        return new MChannel(new ArrayList<V>(this.l), new ArrayList<E>(this.f));
    }

    class n
    implements Comparator<V> {
        private Map<V, Double> e;

        public n(Map<V, Double> map) {
            this.e = map;
        }

        public int a(V v, V v2) {
            double d2;
            if (v == null) {
                return 1;
            }
            if (v2 == null) {
                return -1;
            }
            if (v == v2) {
                return 0;
            }
            double d3 = this.e.get(v);
            if (d3 > (d2 = this.e.get(v2).doubleValue())) {
                return 1;
            }
            if (d3 < d2) {
                return -1;
            }
            return 0;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((MAbstractVertex)object, (MAbstractVertex)object2);
        }
    }
}

