/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.internal.presentation;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.ProxySettings;
import com.anylogic.engine.internal.ae;
import com.anylogic.engine.internal.fj;
import com.anylogic.engine.internal.ic;
import com.anylogic.engine.internal.presentation.e;
import com.anylogic.engine.internal.x.h;
import com.anylogic.engine.presentation.Object3DAxisOrder;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.Planet;
import com.bbn.openmap.proj.Projection;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.AccessControlException;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@AnyLogicInternalAPI
public final class SharedUtils {
    public static String[] GRAPH_HOPPER_ROUTING_FILES = new String[]{"edges", "geometry", "locationIndex", "names", "nodes", "properties"};
    private static final BasicStroke a = new BasicStroke(3.0f, 0, 0, 10.0f);
    private static final Pattern e = Pattern.compile("\\:|\\;|\\/|\\\\");
    private static /* synthetic */ int[] h;

    private SharedUtils() {
    }

    public static int getPPM(Object object) {
        return object instanceof GeoProj ? (int)((GeoProj)object).getPPM() : Planet.defaultPixelsPerMeter;
    }

    @AnyLogicInternalAPI
    public static void drawGISRuler(Graphics2D graphics2D, Projection projection, int n2, int n3, double d2) {
        SharedUtils.getPPM(projection);
        Point2D point2D = projection.inverse((double)(n2 - 90), (double)((n3 ^= SharedUtils.class.hashCode()) - 10));
        Point2D point2D2 = projection.inverse((double)(n2 - 10), (double)(n3 - 10));
        double d3 = Utilities.getDistanceGIS(point2D.getY(), point2D.getX(), point2D2.getY(), point2D2.getX());
        double d4 = d3 / 80.0;
        double d5 = d3;
        double d6 = Math.pow(10.0, Math.floor(Math.log10(d5)));
        double d7 = d5 / d6;
        long l2 = (long)((double)Math.round(d7) * d6);
        int n4 = Utilities.roundToInt((double)l2 / d4);
        if (n3 >= 20 && n2 >= n4 + 20) {
            Stroke stroke = graphics2D.getStroke();
            Font font = graphics2D.getFont();
            Color color = graphics2D.getColor();
            int n5 = n2 - n4 - 10;
            int n6 = n3 - 10;
            int n7 = n5 + n4;
            int n8 = n6 - 3;
            GeneralPath generalPath = com.anylogic.engine.internal.presentation.e.c.get();
            generalPath.reset();
            generalPath.moveTo(n5, n8);
            generalPath.lineTo(n5, n6);
            generalPath.lineTo(n7, n6);
            generalPath.lineTo(n7, n8);
            graphics2D.setColor(Color.WHITE);
            graphics2D.setStroke(a);
            graphics2D.draw(generalPath);
            graphics2D.setStroke(com.anylogic.engine.internal.presentation.e.e());
            String string = SharedUtils.a(l2 / 2L);
            Font font2 = com.anylogic.engine.internal.presentation.e.a();
            FontRenderContext fontRenderContext = com.anylogic.engine.internal.presentation.e.i.get();
            Rectangle2D rectangle2D = font2.getStringBounds(string, fontRenderContext);
            graphics2D.setFont(font2);
            int n9 = (int)font2.getLineMetrics(string, fontRenderContext).getAscent();
            int n10 = (int)(((double)(n5 + n7) - rectangle2D.getWidth()) / 2.0);
            int n11 = n6 - 2;
            graphics2D.fillRect(n10 - 2, n11 - n9, (int)rectangle2D.getWidth() + 4, n9 + 1);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(string, n10, n11);
            graphics2D.draw(generalPath);
            graphics2D.setStroke(stroke);
            graphics2D.setFont(font);
            graphics2D.setColor(color);
        }
    }

    private static String a(long l2) {
        if (l2 < 1000L) {
            return String.valueOf(l2) + ae.bfm;
        }
        return String.valueOf(l2 / 1000L) + ae.eai;
    }

    @AnyLogicInternalAPI
    public static boolean substitudeObject3DColorMappings(InputStream inputStream, OutputStream outputStream, Color[] colorArray) {
        if (colorArray == null || colorArray.length == 0) {
            return false;
        }
        String string = new Scanner(inputStream).useDelimiter("\\A").next();
        String string2 = null;
        Matcher matcher = Pattern.compile("<!DOCTYPE.*?>", 32).matcher(string);
        if (matcher.find() && matcher.group(0).toLowerCase().indexOf("x3d") != -1) {
            string2 = SharedUtils.a(string, colorArray);
        } else {
            Matcher matcher2 = Pattern.compile("#WRML", 32).matcher(string);
            if (matcher2.find()) {
                string2 = SharedUtils.e(string, colorArray);
            }
        }
        if (string2 == null) {
            return false;
        }
        try {
            outputStream.write(string2.getBytes(Charset.forName("UTF-8")));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    private static String a(String string, Color[] colorArray) {
        Matcher matcher = Pattern.compile("(<Appearance)([^<]*<Material[^>]*>)").matcher(string);
        int n2 = 0;
        while (matcher.find()) {
            String string2 = matcher.group(2);
            Color color = SharedUtils.a(string2, "(diffuseColor[\\s]*=[\\s]*['\"])([^'\"><]*)");
            if (color == null) continue;
            Color color2 = colorArray[n2];
            ++n2;
            if (color2 == null || (string2 = SharedUtils.a(color2, string2, "(diffuseColor[^'\"]*['\"])([^'\"]*)", 2)) == null) continue;
            string = string.replace(matcher.group(2), string2);
        }
        return string;
    }

    private static String e(String string, Color[] colorArray) {
        Matcher matcher = Pattern.compile("([^{]*appearance)([^}U].*[^}S].*[^}E]*})").matcher(string);
        int n2 = 0;
        while (matcher.find()) {
            String string2 = matcher.group(2);
            Color color = SharedUtils.a(string2, "([^{]*diffuseColor[\\s]*)([^}]*)(})");
            if (color == null) continue;
            Color color2 = colorArray[n2];
            ++n2;
            if (color2 == null || (string2 = SharedUtils.a(color2, string2, "([^{]*diffuseColor[\\s]*)([^}]*)([\\s]*})", 2)) == null) continue;
            string = string.replace(matcher.group(2), string2);
        }
        return string;
    }

    private static String a(Color color, String string, String string2, int n2) {
        Float f2 = Float.valueOf((float)color.getRed() / 255.0f);
        Float f3 = Float.valueOf((float)color.getGreen() / 255.0f);
        Float f4 = Float.valueOf((float)color.getBlue() / 255.0f);
        Matcher matcher = Pattern.compile(string2).matcher(string);
        if (matcher.find()) {
            String string3 = String.valueOf(f2.toString()) + " " + f3.toString() + " " + f4.toString();
            return string.replace(matcher.group(n2), string3);
        }
        return null;
    }

    private static Color a(String string, String string2) {
        Matcher matcher = Pattern.compile(string2).matcher(string);
        if (!matcher.find()) {
            return null;
        }
        Float f2 = null;
        Float f3 = null;
        Float f4 = null;
        Matcher matcher2 = Pattern.compile("([\\s^]*)([\\.\\d+]*)").matcher(matcher.group(2));
        if (!matcher2.find()) {
            return null;
        }
        f2 = Float.valueOf(Float.parseFloat(String.valueOf(matcher2.group(2).substring(0, 0) == "." ? "0" : "") + matcher2.group(2)));
        if (!matcher2.find()) {
            return null;
        }
        f3 = Float.valueOf(Float.parseFloat(String.valueOf(matcher2.group(2).substring(0, 0) == "." ? "0" : "") + matcher2.group(2)));
        if (!matcher2.find()) {
            return null;
        }
        f4 = Float.valueOf(Float.parseFloat(String.valueOf(matcher2.group(2).substring(0, 0) == "." ? "0" : "") + matcher2.group(2)));
        return new Color((int)(f2.floatValue() * 255.0f), (int)(f3.floatValue() * 255.0f), (int)(f4.floatValue() * 255.0f));
    }

    @AnyLogicInternalAPI
    public static String getInternalCADFileName(String string) {
        return String.valueOf(e.matcher(string).replaceAll("_")) + "_xjal";
    }

    @AnyLogicInternalAPI
    public static String get3DObjectImageFileName(String string, Object3DAxisOrder object3DAxisOrder, double d2, double d3, double d4, double d5, Long l2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(e.matcher(string).replaceAll("_"));
        stringBuilder.append('_');
        switch (SharedUtils.a()[object3DAxisOrder.ordinal()]) {
            case 1: {
                stringBuilder.append("xyz");
                break;
            }
            case 2: {
                stringBuilder.append("yzx");
                break;
            }
            case 3: {
                stringBuilder.append("zxy");
            }
        }
        stringBuilder.append('_').append((int)d2).append('_').append((int)d3);
        stringBuilder.append('_').append((int)d4).append('_').append((int)d5);
        if (l2 != null) {
            stringBuilder.append('_').append(l2);
        }
        stringBuilder.append(".png_xjal");
        return stringBuilder.toString();
    }

    @AnyLogicInternalAPI
    public static String trimToLineBreak(String string) {
        if (string != null) {
            int n2 = string.indexOf(13);
            int n3 = string.indexOf(10);
            if (n2 < 0 || n3 >= 0 && n3 < n2) {
                n2 = n3;
            }
            if (n2 >= 0) {
                string = string.substring(0, n2);
            }
        }
        return string;
    }

    public static double[] getSimplifiedPointList(double[] dArray, int n2, List<Integer> list) {
        return com.anylogic.engine.internal.x.h.a().a(dArray, (double)n2, list);
    }

    public static double getGISRegionArea(double[] dArray) {
        return ic.a(dArray);
    }

    public static void setProxySettings() {
        boolean bl = Boolean.valueOf(fj.e(ProxySettings.USE_PROXY_PROPERTY, "false"));
        if (bl) {
            try {
                String string = bl ? fj.e(ProxySettings.PROXY_HOST_PROPERTY, "") : "";
                String string2 = bl ? fj.e(ProxySettings.PROXY_PORT_PROPERTY, "8080") : "";
                System.setProperty("http.proxyHost", string);
                System.setProperty("http.proxyPort", string2);
                System.setProperty("https.proxyHost", string);
                System.setProperty("https.proxyPort", string2);
                String string3 = fj.e(ProxySettings.PROXY_LOGIN_PROPERTY, "");
                boolean bl2 = !string3.isEmpty();
                string3 = bl2 ? string3 : "";
                System.getProperties().put("http.proxyUser", string3);
                String string4 = bl2 ? fj.e(ProxySettings.PROXY_PASSWORD, "") : "";
                System.getProperties().put("http.proxyPassword", string4);
                System.setProperty("socksProxyHost", string);
                System.setProperty("socksProxyPort", string2);
                System.setProperty("java.net.socks.username", string3);
                System.setProperty("java.net.socks.password", string4);
            }
            catch (AccessControlException accessControlException) {}
        }
    }

    public static boolean folderContainsGraphHopperRoutingGraph(String string) {
        File file = new File(string);
        if (!file.isDirectory()) {
            return false;
        }
        String[] stringArray = GRAPH_HOPPER_ROUTING_FILES;
        int n2 = GRAPH_HOPPER_ROUTING_FILES.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            if (!new File(String.valueOf(file.getAbsolutePath()) + File.separator + string2).isFile()) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static double[] get3PointBasedRegion(double[] dArray) {
        double d2 = 180.0;
        double d3 = -180.0;
        double d4 = 90.0;
        double d5 = -90.0;
        int n2 = 0;
        while (n2 < dArray.length) {
            d4 = Math.min(d4, dArray[n2]);
            d5 = Math.max(d5, dArray[n2]);
            d2 = Math.min(d2, dArray[n2 + 1]);
            d3 = Math.max(d3, dArray[n2 + 1]);
            n2 += 2;
        }
        double[] dArray2 = new double[]{d4, d2, d5, (d2 + d3) / 2.0, d4, d3};
        return dArray2;
    }

    static /* synthetic */ int[] a() {
        if (h != null) {
            return h;
        }
        int[] nArray = new int[Object3DAxisOrder.values().length];
        try {
            nArray[Object3DAxisOrder.OBJECT_3D_XYZ_AXIS_ORDER.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Object3DAxisOrder.OBJECT_3D_YZX_AXIS_ORDER.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Object3DAxisOrder.OBJECT_3D_ZXY_AXIS_ORDER.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        h = nArray;
        return nArray;
    }
}

