/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.internal.triangulation;

import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.triangulation.ITEdge;
import com.anylogic.engine.internal.triangulation.ITTriangle;
import com.anylogic.engine.internal.triangulation.ITVertex;

public class TUtilities {
    public static final boolean DEBUG = false;

    public static double getDistance(ITEdge<?, ?, ?, ?> iTEdge, ITVertex<?, ?, ?, ?> iTVertex) {
        return TUtilities.getDistance((ITVertex)iTEdge.getSource(), (ITVertex)iTEdge.getTarget(), iTVertex);
    }

    public static double getDistance(ITVertex<?, ?, ?, ?> iTVertex, ITVertex<?, ?, ?, ?> iTVertex2, ITVertex<?, ?, ?, ?> iTVertex3) {
        return Utilities.getDistanceFromPointToSegment(iTVertex.getX(), iTVertex.getY(), iTVertex2.getX(), iTVertex2.getY(), iTVertex3.getX(), iTVertex3.getY());
    }

    public static double getDistance(ITVertex<?, ?, ?, ?> iTVertex, ITVertex<?, ?, ?, ?> iTVertex2) {
        return Utilities.getDistance(iTVertex.getX(), iTVertex.getY(), iTVertex2.getX(), iTVertex2.getY());
    }

    public static boolean isIntersect(ITEdge<?, ?, ?, ?> iTEdge, ITEdge<?, ?, ?, ?> iTEdge2) {
        return TUtilities.isIntersect((ITVertex)iTEdge.getSource(), (ITVertex)iTEdge.getTarget(), (ITVertex)iTEdge2.getSource(), (ITVertex)iTEdge2.getTarget());
    }

    public static boolean isIntersect(ITVertex<?, ?, ?, ?> iTVertex, ITVertex<?, ?, ?, ?> iTVertex2, ITVertex<?, ?, ?, ?> iTVertex3, ITVertex<?, ?, ?, ?> iTVertex4) {
        return Utilities.isLineIntersectingLine(iTVertex.getX(), iTVertex.getY(), iTVertex2.getX(), iTVertex2.getY(), iTVertex3.getX(), iTVertex3.getY(), iTVertex4.getX(), iTVertex4.getY());
    }

    public static boolean inCircumcircle(ITTriangle<?, ?, ?, ?> iTTriangle, double d2, double d3, double d4) {
        return TUtilities.inCircumcircle(((ITVertex)iTTriangle.getVertices().get(0)).getX(), ((ITVertex)iTTriangle.getVertices().get(0)).getY(), ((ITVertex)iTTriangle.getVertices().get(1)).getX(), ((ITVertex)iTTriangle.getVertices().get(1)).getY(), ((ITVertex)iTTriangle.getVertices().get(2)).getX(), ((ITVertex)iTTriangle.getVertices().get(2)).getY(), d2, d3, d4);
    }

    public static boolean inCircumcircle(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11;
        double d12;
        if (Math.abs(d3 - d5) < d10 && Math.abs(d5 - d7) < d10) {
            return false;
        }
        if (Math.abs(d5 - d3) < d10) {
            double d13 = -(d6 - d4) / (d7 - d5);
            double d14 = (d4 + d6) * 0.5;
            double d15 = (d5 + d7) * 0.5;
            d12 = (d4 + d2) * 0.5;
            d11 = d13 * (d12 - d14) + d15;
        } else if (Math.abs(d7 - d5) < d10) {
            double d16 = -(d4 - d2) / (d5 - d3);
            double d17 = (d2 + d4) * 0.5;
            double d18 = (d3 + d5) * 0.5;
            d12 = (d6 + d4) * 0.5;
            d11 = d16 * (d12 - d17) + d18;
        } else {
            double d19 = -(d4 - d2) / (d5 - d3);
            double d20 = -(d6 - d4) / (d7 - d5);
            double d21 = (d2 + d4) * 0.5;
            double d22 = (d4 + d6) * 0.5;
            double d23 = (d3 + d5) * 0.5;
            double d24 = (d5 + d7) * 0.5;
            d12 = (d19 * d21 - d20 * d22 + d24 - d23) / (d19 - d20);
            d11 = d19 * (d12 - d21) + d23;
        }
        double d25 = d4 - d12;
        double d26 = d5 - d11;
        double d27 = d25 * d25 + d26 * d26;
        d25 = d8 - d12;
        d26 = d9 - d11;
        double d28 = d25 * d25 + d26 * d26;
        return d28 <= d27 || Math.abs(d28 - d27) < d10;
    }

    public static boolean isVertexOnTheLine(ITVertex<?, ?, ?, ?> iTVertex, ITVertex<?, ?, ?, ?> iTVertex2, ITVertex<?, ?, ?, ?> iTVertex3) {
        return Utilities.isPointOnTheSameLine(iTVertex.getX(), iTVertex.getY(), iTVertex2.getX(), iTVertex2.getY(), iTVertex3.getX(), iTVertex3.getY());
    }
}

