/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.internal.triangulation.impl;

import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.internal.graph.impl.GAbstractEdge;
import com.anylogic.engine.internal.triangulation.ITTriangle;
import com.anylogic.engine.internal.triangulation.impl.TAbstractEdge;
import com.anylogic.engine.internal.triangulation.impl.TAbstractTriangulation;
import com.anylogic.engine.internal.triangulation.impl.TAbstractVertex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class TAbstractTriangle<G extends TAbstractTriangulation<G, V, E, T>, V extends TAbstractVertex<G, V, E, T>, E extends TAbstractEdge<G, V, E, T>, T extends TAbstractTriangle<G, V, E, T>>
implements ITTriangle<G, V, E, T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final double a = 0.001;
    @AnyLogicCustomSerialization
    private transient G e;
    @AnyLogicCustomSerialization
    private transient List<V> h = new ArrayList<V>(3);
    @AnyLogicCustomSerialization
    private transient List<E> k = new ArrayList(3);
    @AnyLogicCustomSerialization
    private transient List<T> d = new ArrayList<T>(3);
    private double[] j = new double[3];

    protected void set(E e2, E e3, E e4) {
        this.h.clear();
        this.k.clear();
        this.d.clear();
        this.k.add(e2);
        this.k.add(e3);
        this.k.add(e4);
        if (this.k.size() != 3) {
            throw new RuntimeException("Cannot create triangle");
        }
        HashSet<TAbstractVertex> hashSet = new HashSet<TAbstractVertex>();
        hashSet.add((TAbstractVertex)((GAbstractEdge)e2).getSharedVertex(e3));
        hashSet.add((TAbstractVertex)((GAbstractEdge)e3).getSharedVertex(e4));
        hashSet.add((TAbstractVertex)((GAbstractEdge)e4).getSharedVertex(e2));
        if (hashSet.size() != 3) {
            throw new RuntimeException("Cannot create triangle");
        }
        this.h.addAll(hashSet);
        this.a();
    }

    private void a() {
        double d2;
        double d3;
        TAbstractVertex tAbstractVertex = (TAbstractVertex)this.h.get(0);
        TAbstractVertex tAbstractVertex2 = (TAbstractVertex)this.h.get(1);
        TAbstractVertex tAbstractVertex3 = (TAbstractVertex)this.h.get(2);
        if (Math.abs(tAbstractVertex.getY() - tAbstractVertex2.getY()) < 0.001 && Math.abs(tAbstractVertex2.getY() - tAbstractVertex3.getY()) < 0.001) {
            this.j[0] = 0.0;
            this.j[1] = 0.0;
            this.j[2] = -1.0;
            return;
        }
        if (Math.abs(tAbstractVertex2.getY() - tAbstractVertex.getY()) < 0.001) {
            double d4 = -(tAbstractVertex3.getX() - tAbstractVertex2.getX()) / (tAbstractVertex3.getY() - tAbstractVertex2.getY());
            double d5 = (tAbstractVertex2.getX() + tAbstractVertex3.getX()) * 0.5;
            double d6 = (tAbstractVertex2.getY() + tAbstractVertex3.getY()) * 0.5;
            d3 = (tAbstractVertex2.getX() + tAbstractVertex.getX()) * 0.5;
            d2 = d4 * (d3 - d5) + d6;
        } else if (Math.abs(tAbstractVertex3.getY() - tAbstractVertex2.getY()) < 0.001) {
            double d7 = -(tAbstractVertex2.getX() - tAbstractVertex.getX()) / (tAbstractVertex2.getY() - tAbstractVertex.getY());
            double d8 = (tAbstractVertex.getX() + tAbstractVertex2.getX()) * 0.5;
            double d9 = (tAbstractVertex.getY() + tAbstractVertex2.getY()) * 0.5;
            d3 = (tAbstractVertex3.getX() + tAbstractVertex2.getX()) * 0.5;
            d2 = d7 * (d3 - d8) + d9;
        } else {
            double d10 = -(tAbstractVertex2.getX() - tAbstractVertex.getX()) / (tAbstractVertex2.getY() - tAbstractVertex.getY());
            double d11 = -(tAbstractVertex3.getX() - tAbstractVertex2.getX()) / (tAbstractVertex3.getY() - tAbstractVertex2.getY());
            double d12 = (tAbstractVertex.getX() + tAbstractVertex2.getX()) * 0.5;
            double d13 = (tAbstractVertex2.getX() + tAbstractVertex3.getX()) * 0.5;
            double d14 = (tAbstractVertex.getY() + tAbstractVertex2.getY()) * 0.5;
            double d15 = (tAbstractVertex2.getY() + tAbstractVertex3.getY()) * 0.5;
            d3 = (d10 * d12 - d11 * d13 + d15 - d14) / (d10 - d11);
            d2 = d10 * (d3 - d12) + d14;
        }
        double d16 = tAbstractVertex2.getX() - d3;
        double d17 = tAbstractVertex2.getY() - d2;
        double d18 = d16 * d16 + d17 * d17;
        this.j[0] = d3;
        this.j[1] = d2;
        this.j[2] = d18;
    }

    public G getTriangulation() {
        return this.e;
    }

    protected void setTriangulation(G g2) {
        this.e = g2;
    }

    @Override
    public List<V> getVertices() {
        return this.h;
    }

    @Override
    public List<E> getEdges() {
        return this.k;
    }

    @Override
    public List<T> getTriangles() {
        return this.d;
    }

    @Override
    public List<V> findAllSharedVertices(T t) {
        ArrayList<V> arrayList = new ArrayList<V>(this.h);
        arrayList.retainAll(((TAbstractTriangle)t).getVertices());
        return arrayList;
    }

    @Override
    public List<E> findAllSharedEdges(T t) {
        ArrayList<E> arrayList = new ArrayList<E>(this.k);
        arrayList.retainAll(((TAbstractTriangle)t).getEdges());
        return arrayList;
    }

    @Override
    public E findSharedEdge(T t) {
        for (TAbstractEdge tAbstractEdge : this.k) {
            if (!((TAbstractTriangle)t).getEdges().contains(tAbstractEdge)) continue;
            return (E)tAbstractEdge;
        }
        return null;
    }

    @Override
    public V getOppositeVertex(E e2) {
        if (!this.k.contains(e2)) {
            throw new RuntimeException("Cannot found 'edge' in triangle");
        }
        for (TAbstractVertex tAbstractVertex : this.h) {
            if (((GAbstractEdge)e2).getSource() == tAbstractVertex || ((GAbstractEdge)e2).getTarget() == tAbstractVertex) continue;
            return (V)tAbstractVertex;
        }
        return null;
    }

    @Override
    public T getOppositeTriangle(E e2) {
        if (!this.k.contains(e2)) {
            throw new RuntimeException("Cannot found 'edge' in triangle");
        }
        TAbstractTriangle tAbstractTriangle = null;
        for (TAbstractTriangle tAbstractTriangle2 : this.d) {
            if (!tAbstractTriangle2.getEdges().contains(e2)) continue;
            tAbstractTriangle = tAbstractTriangle2;
            break;
        }
        return (T)tAbstractTriangle;
    }

    @Override
    public E findEdge(V v, V v2) {
        if (!this.h.contains(v)) {
            throw new RuntimeException("Cannot found 'sourceVertex' in triangle");
        }
        if (!this.h.contains(v2)) {
            throw new RuntimeException("Cannot found 'targetVertex' in triangle");
        }
        TAbstractEdge tAbstractEdge = null;
        for (TAbstractEdge tAbstractEdge2 : this.k) {
            TAbstractVertex tAbstractVertex = (TAbstractVertex)tAbstractEdge2.getSource();
            TAbstractVertex tAbstractVertex2 = (TAbstractVertex)tAbstractEdge2.getTarget();
            if ((tAbstractVertex != v || tAbstractVertex2 != v2) && (tAbstractVertex != v2 || tAbstractVertex2 != v)) continue;
            tAbstractEdge = tAbstractEdge2;
            break;
        }
        return (E)tAbstractEdge;
    }

    protected void addTriangle(T t) {
        List<E> list = this.findAllSharedEdges(t);
        if (list.isEmpty()) {
            throw new RuntimeException("Cannot found shared edge in 'triangle'");
        }
        this.d.add(t);
    }

    protected void removeTriangle(T t) {
        if (!this.d.contains(t)) {
            throw new RuntimeException("Cannot found 'triangle' in triangle");
        }
        this.d.remove(t);
    }

    @Override
    public boolean isCircumcircle(double d2, double d3) {
        double d4 = d2 - this.j[0];
        double d5 = d3 - this.j[1];
        double d6 = d4 * d4 + d5 * d5;
        return d6 <= this.j[2] + 0.001;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Triangle {");
        int n2 = 0;
        while (n2 < this.getVertices().size()) {
            if (n2 != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.getVertices().get(n2));
            ++n2;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

