/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.internal.triangulation.impl;

import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.internal.graph.geo.impl.GAbstractGeoGraph;
import com.anylogic.engine.internal.graph.impl.GAbstractVertex;
import com.anylogic.engine.internal.triangulation.ITTriangulation;
import com.anylogic.engine.internal.triangulation.impl.TAbstractEdge;
import com.anylogic.engine.internal.triangulation.impl.TAbstractTriangle;
import com.anylogic.engine.internal.triangulation.impl.TAbstractVertex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class TAbstractTriangulation<G extends TAbstractTriangulation<G, V, E, T>, V extends TAbstractVertex<G, V, E, T>, E extends TAbstractEdge<G, V, E, T>, T extends TAbstractTriangle<G, V, E, T>>
extends GAbstractGeoGraph<G, V, E>
implements ITTriangulation<G, V, E, T> {
    private static final long serialVersionUID = 1L;
    protected Set<T> triangles = new LinkedHashSet<T>();
    protected Set<E> constraints = new LinkedHashSet();
    @AnyLogicCustomSerialization
    protected transient Set<T> unmodifiableTriangles = Collections.unmodifiableSet(this.triangles);
    @AnyLogicCustomSerialization
    protected transient Set<E> unmodifiableConstraints = Collections.unmodifiableSet(this.constraints);

    @Override
    public Set<T> getTriangles() {
        return this.unmodifiableTriangles;
    }

    @Override
    public Set<E> getConstraints() {
        return this.unmodifiableConstraints;
    }

    @Override
    public void setConstraint(E e2, boolean bl) {
        if (!this.getEdges().contains(e2)) {
            throw new RuntimeException("Cannot found 'edge' in triangulation");
        }
        ((TAbstractEdge)e2).setConstraint(bl);
        if (bl) {
            this.constraints.add(e2);
        } else {
            this.constraints.remove(e2);
        }
    }

    @Override
    public void addEdge(E e2, V v, V v2) {
        if (((GAbstractVertex)v).findEdge(v2) != null) {
            throw new RuntimeException("'edge' exists in triangulation");
        }
        super.addEdge(e2, v, v2);
        if (((TAbstractEdge)e2).isConstraint()) {
            this.constraints.add(e2);
        }
    }

    @Override
    public void addTriangle(T t, E e2, E e3, E e4) {
        if (!this.getEdges().contains(e2)) {
            throw new RuntimeException("Cannot found 'edge1' in triangulation");
        }
        if (!this.getEdges().contains(e3)) {
            throw new RuntimeException("Cannot found 'edge2' in triangulation");
        }
        if (!this.getEdges().contains(e4)) {
            throw new RuntimeException("Cannot found 'edge3' in triangulation");
        }
        ((TAbstractTriangle)t).setTriangulation((TAbstractTriangulation)this);
        ((TAbstractTriangle)t).set(e2, e3, e4);
        this.a(t);
        this.triangles.add(t);
    }

    @Override
    public void removeTriangle(T t) {
        if (!this.triangles.contains(t)) {
            throw new RuntimeException("Cannot found 'triangle' in triangulation");
        }
        this.e(t);
        this.triangles.remove(t);
    }

    @Override
    public void removeVertex(V v) {
        if (!this.getVertices().contains(v)) {
            throw new RuntimeException("Cannot found 'vertex' in triangulation");
        }
        ArrayList arrayList = new ArrayList(((TAbstractVertex)v).getTriangles());
        for (TAbstractTriangle tAbstractTriangle : arrayList) {
            this.removeTriangle((T)tAbstractTriangle);
        }
        super.removeVertex(v);
    }

    @Override
    public void removeEdge(E e2) {
        if (!this.getEdges().contains(e2)) {
            throw new RuntimeException("Cannot found 'edge' in triangulation");
        }
        ArrayList arrayList = new ArrayList(((TAbstractEdge)e2).getTriangles());
        for (TAbstractTriangle tAbstractTriangle : arrayList) {
            this.removeTriangle((T)tAbstractTriangle);
        }
        this.constraints.remove(e2);
        super.removeEdge(e2);
    }

    @Override
    public List<T> findTriangles(E e2, E e3, E e4) {
        ArrayList arrayList = new ArrayList(4);
        arrayList.addAll(((TAbstractEdge)e2).getTriangles());
        arrayList.retainAll(((TAbstractEdge)e3).getTriangles());
        arrayList.retainAll(((TAbstractEdge)e4).getTriangles());
        return arrayList;
    }

    @Override
    public List<T> findTriangles(V v, V v2, V v3) {
        ArrayList arrayList = new ArrayList(4);
        arrayList.addAll(((TAbstractVertex)v).getTriangles());
        arrayList.retainAll(((TAbstractVertex)v2).getTriangles());
        arrayList.retainAll(((TAbstractVertex)v3).getTriangles());
        return arrayList;
    }

    private void a(V v, T t) {
        ((TAbstractVertex)v).addTriangle(t);
    }

    private void a(T t) {
        for (Serializable serializable : ((TAbstractTriangle)t).getEdges()) {
            this.a((E)serializable, t);
        }
        for (Serializable serializable : ((TAbstractTriangle)t).getVertices()) {
            this.a((E)serializable, t);
        }
    }

    private void a(E e2, T tAbstractTriangle) {
        for (TAbstractTriangle tAbstractTriangle2 : ((TAbstractEdge)e2).getTriangles()) {
            if (tAbstractTriangle == tAbstractTriangle2) continue;
            tAbstractTriangle2.addTriangle(tAbstractTriangle);
            tAbstractTriangle.addTriangle((TAbstractTriangle)tAbstractTriangle2);
        }
        ((TAbstractEdge)e2).addTriangle(tAbstractTriangle);
    }

    private void e(V v, T t) {
        ((TAbstractVertex)v).removeTriangle(t);
    }

    private void e(T t) {
        for (Serializable serializable : ((TAbstractTriangle)t).getEdges()) {
            this.e((E)serializable, t);
        }
        for (Serializable serializable : ((TAbstractTriangle)t).getVertices()) {
            this.e((E)serializable, t);
        }
    }

    private void e(E e2, T tAbstractTriangle) {
        for (TAbstractTriangle tAbstractTriangle2 : ((TAbstractEdge)e2).getTriangles()) {
            if (tAbstractTriangle2 == tAbstractTriangle) continue;
            tAbstractTriangle2.removeTriangle(tAbstractTriangle);
            tAbstractTriangle.removeTriangle((TAbstractTriangle)tAbstractTriangle2);
        }
        ((TAbstractEdge)e2).removeTriangle(tAbstractTriangle);
    }
}

