/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.internal.triangulation.impl;

import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.internal.graph.geo.impl.GAbstractGeoVertex;
import com.anylogic.engine.internal.triangulation.ITVertex;
import com.anylogic.engine.internal.triangulation.impl.TAbstractEdge;
import com.anylogic.engine.internal.triangulation.impl.TAbstractTriangle;
import com.anylogic.engine.internal.triangulation.impl.TAbstractTriangulation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TAbstractVertex<G extends TAbstractTriangulation<G, V, E, T>, V extends TAbstractVertex<G, V, E, T>, E extends TAbstractEdge<G, V, E, T>, T extends TAbstractTriangle<G, V, E, T>>
extends GAbstractGeoVertex<G, V, E>
implements ITVertex<G, V, E, T> {
    private static final long serialVersionUID = 1L;
    @AnyLogicCustomSerialization
    protected transient List<T> triangles = new ArrayList<T>();
    @AnyLogicCustomSerialization
    protected transient List<T> unmodifiableTriangles = Collections.unmodifiableList(this.triangles);

    @Override
    public List<T> getTriangles() {
        return this.unmodifiableTriangles;
    }

    protected void addTriangle(T t) {
        if (!((TAbstractTriangle)t).getVertices().contains(this)) {
            throw new RuntimeException("Cannot found vertex in 'triangle'");
        }
        this.triangles.add(t);
    }

    protected void removeTriangle(T t) {
        if (!((TAbstractTriangle)t).getVertices().contains(this)) {
            throw new RuntimeException("Cannot found vertex in 'triangle'");
        }
        this.triangles.remove(t);
    }

    public boolean isConstraint() {
        for (TAbstractEdge tAbstractEdge : this.edges) {
            if (!tAbstractEdge.isConstraint()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.x);
        return (int)(l2 ^= Double.doubleToLongBits(this.y) * 31L) ^ (int)(l2 >> 32);
    }

    public boolean equals(Object object) {
        if (object instanceof TAbstractVertex) {
            TAbstractVertex tAbstractVertex = (TAbstractVertex)object;
            return tAbstractVertex.getX() == this.x && tAbstractVertex.getY() == this.y;
        }
        return false;
    }
}

