/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.internal.triangulation.rc;

import com.anylogic.engine.internal.triangulation.ITEdge;
import com.anylogic.engine.internal.triangulation.ITTriangle;
import com.anylogic.engine.internal.triangulation.ITTriangulation;
import com.anylogic.engine.internal.triangulation.ITTriangulationFactory;
import com.anylogic.engine.internal.triangulation.ITVertex;
import com.anylogic.engine.internal.triangulation.TUtilities;

public class TAbstractTriangulator<G extends ITTriangulation<G, V, E, T>, V extends ITVertex<G, V, E, T>, E extends ITEdge<G, V, E, T>, T extends ITTriangle<G, V, E, T>> {
    protected G triangulation;
    protected ITTriangulationFactory<G, V, E, T> factory;

    protected TAbstractTriangulator(G g2, ITTriangulationFactory<G, V, E, T> iTTriangulationFactory) {
        this.triangulation = g2;
        this.factory = iTTriangulationFactory;
    }

    public G getTriangulation() {
        return this.triangulation;
    }

    public ITTriangulationFactory<G, V, E, T> getFactory() {
        return this.factory;
    }

    protected V addVertex(double d2, double d3) {
        ITVertex iTVertex = (ITVertex)this.factory.createVertex();
        iTVertex.setX(d2);
        iTVertex.setY(d3);
        this.triangulation.addVertex((ITVertex)iTVertex);
        return (V)iTVertex;
    }

    protected E addEdge(V v, V v2, boolean bl) {
        ITEdge iTEdge = (ITEdge)v.findEdge(v2);
        if (iTEdge != null) {
            return (E)iTEdge;
        }
        iTEdge = (ITEdge)this.factory.createEdge();
        this.triangulation.addEdge((ITEdge)iTEdge, v, v2);
        this.triangulation.setConstraint((ITEdge)iTEdge, bl);
        return (E)iTEdge;
    }

    protected T addTriangle(V v, V v2, V v3) {
        if (!this.triangulation.findTriangles(v, v2, v3).isEmpty()) {
            throw new RuntimeException("Cannot create triangle: {" + v + "}, {" + v2 + "}, {" + v3 + "}");
        }
        if (TUtilities.isVertexOnTheLine(v, v2, v3)) {
            throw new RuntimeException("Cannot create triangle: {" + v + "}, {" + v2 + "}, {" + v3 + "}");
        }
        E e2 = this.addEdge(v, v2, false);
        E e3 = this.addEdge(v2, v3, false);
        E e4 = this.addEdge(v3, v, false);
        return this.addTriangle(e2, e3, e4);
    }

    protected T addTriangle(E e2, E e3, E e4) {
        if (!this.triangulation.findTriangles(e2, e3, e4).isEmpty()) {
            throw new RuntimeException();
        }
        T t = this.factory.createTriangle();
        this.triangulation.addTriangle(t, e2, e3, e4);
        return t;
    }
}

