/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.LengthUnits;
import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.ae;
import com.anylogic.engine.internal.ff;
import com.anylogic.engine.markup.AbstractMarkupAggregator;
import com.anylogic.engine.markup.GISPoint;
import com.anylogic.engine.markup.INetwork;
import com.anylogic.engine.markup.INetworkMarkupElement;
import com.anylogic.engine.markup.INode;
import com.anylogic.engine.markup.IPath;
import com.anylogic.engine.markup.NodeType;
import com.anylogic.engine.markup.PointNode;
import com.anylogic.engine.markup.ShortestPathData;
import com.anylogic.engine.markup.SimpleDirection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@AnyLogicInternalAPI
public abstract class AbstractNetwork<N extends INode<N, P>, P extends IPath<N>, Owner>
extends AbstractMarkupAggregator<Owner>
implements INetwork<N, P> {
    private static final long serialVersionUID = 8149849708938184338L;
    private static final double m = Double.POSITIVE_INFINITY;
    private boolean g;
    List<N> j = new ArrayList<N>();
    private int b = -1;
    private int ai = -1;
    List<P> c = new ArrayList<P>();
    boolean l = true;
    int[][] f;
    double[][] i;
    int n = Integer.MAX_VALUE;

    public AbstractNetwork(Owner Owner, String string) {
        super(Owner, string);
    }

    public AbstractNetwork(Owner Owner, String string, boolean bl, boolean bl2) {
        this(Owner, string);
        this.k = bl;
        this.h = bl2;
    }

    @Override
    public void add(N n2) {
        this.k();
        this.a((INetworkMarkupElement)n2, this.j.size());
        this.j.add(n2);
    }

    @Override
    public void add(P p) {
        this.k();
        this.a((INetworkMarkupElement)p, this.c.size());
        this.c.add(p);
    }

    @Override
    public N getNode(int n2) {
        return (N)((INode)this.j.get(n2));
    }

    @Override
    public int getNodeCount() {
        return this.j.size();
    }

    @Override
    public P getPath(int n2) {
        return (P)((IPath)this.c.get(n2));
    }

    @Override
    public int getPathCount() {
        if (this.b == -1) {
            return this.c.size();
        }
        return this.c.size() - 1;
    }

    @Override
    public List<N> nodes() {
        return Collections.unmodifiableList(this.j);
    }

    @Override
    public List<P> paths() {
        return Collections.unmodifiableList(this.c.subList(0, this.c.size() - 1));
    }

    @Override
    public double getDistance(N n2, N n3, ShortestPathData<N, P> shortestPathData) {
        shortestPathData = this.e(shortestPathData);
        shortestPathData.fromNode = n2;
        shortestPathData.toNode = n3;
        return this.h(shortestPathData);
    }

    @Override
    public double getDistance(N n2, N n3, ShortestPathData<N, P> shortestPathData, LengthUnits lengthUnits) {
        return this.a(this.getDistance(n2, n3, shortestPathData), lengthUnits);
    }

    @Override
    public double getDistance(N n2, P p, double d2, ShortestPathData<N, P> shortestPathData) {
        shortestPathData = this.e(shortestPathData);
        shortestPathData.fromNode = n2;
        shortestPathData.toPath = p;
        shortestPathData.toOffset = d2;
        return this.h(shortestPathData);
    }

    @Override
    public double getDistance(N n2, P p, double d2, ShortestPathData<N, P> shortestPathData, LengthUnits lengthUnits) {
        return this.a(this.getDistance(n2, p, d2, shortestPathData), lengthUnits);
    }

    @Override
    public double getDistance(P p, double d2, N n2, ShortestPathData<N, P> shortestPathData) {
        shortestPathData = this.e(shortestPathData);
        shortestPathData.fromPath = p;
        shortestPathData.fromOffset = d2;
        shortestPathData.toNode = n2;
        return this.h(shortestPathData);
    }

    @Override
    public double getDistance(P p, double d2, N n2, ShortestPathData<N, P> shortestPathData, LengthUnits lengthUnits) {
        return this.a(this.getDistance(p, d2, n2, shortestPathData), lengthUnits);
    }

    @Override
    public double getDistance(P p, double d2, P p2, double d3, ShortestPathData<N, P> shortestPathData) {
        shortestPathData = this.e(shortestPathData);
        shortestPathData.fromPath = p;
        shortestPathData.fromOffset = d2;
        shortestPathData.toPath = p2;
        shortestPathData.toOffset = d3;
        return this.h(shortestPathData);
    }

    @Override
    public double getDistance(P p, double d2, P p2, double d3, ShortestPathData<N, P> shortestPathData, LengthUnits lengthUnits) {
        return this.a(this.getDistance(p, d2, p2, d3, shortestPathData), lengthUnits);
    }

    @Override
    public double getDistance(Point point, Point point2, N n2, N n3, ShortestPathData<N, P> shortestPathData) {
        shortestPathData = this.e(shortestPathData);
        shortestPathData.source = this.e(point);
        shortestPathData.target = this.e(point2);
        shortestPathData.fromNode = n2;
        shortestPathData.toNode = n3;
        return this.h(shortestPathData);
    }

    @Override
    public double getDistance(Point point, Point point2, N n2, N n3, ShortestPathData<N, P> shortestPathData, LengthUnits lengthUnits) {
        return this.a(this.getDistance(point, point2, n2, n3, shortestPathData), lengthUnits);
    }

    @Override
    public double getDistance(Point point, Point point2, N n2, P p, double d2, ShortestPathData<N, P> shortestPathData) {
        shortestPathData = this.e(shortestPathData);
        shortestPathData.source = this.e(point);
        shortestPathData.target = this.e(point2);
        shortestPathData.fromNode = n2;
        shortestPathData.toPath = p;
        shortestPathData.toOffset = d2;
        return this.h(shortestPathData);
    }

    @Override
    public double getDistance(Point point, Point point2, N n2, P p, double d2, ShortestPathData<N, P> shortestPathData, LengthUnits lengthUnits) {
        return this.a(this.getDistance(point, point2, n2, p, d2, shortestPathData), lengthUnits);
    }

    @Override
    public double getDistance(Point point, Point point2, P p, double d2, N n2, ShortestPathData<N, P> shortestPathData) {
        shortestPathData = this.e(shortestPathData);
        shortestPathData.source = this.e(point);
        shortestPathData.target = this.e(point2);
        shortestPathData.fromPath = p;
        shortestPathData.fromOffset = d2;
        shortestPathData.toNode = n2;
        return this.h(shortestPathData);
    }

    @Override
    public double getDistance(Point point, Point point2, P p, double d2, N n2, ShortestPathData<N, P> shortestPathData, LengthUnits lengthUnits) {
        return this.a(this.getDistance(point, point2, p, d2, n2, shortestPathData), lengthUnits);
    }

    @Override
    public double getDistance(Point point, Point point2, P p, double d2, P p2, double d3, ShortestPathData<N, P> shortestPathData) {
        shortestPathData = this.e(shortestPathData);
        shortestPathData.source = this.e(point);
        shortestPathData.target = this.e(point2);
        shortestPathData.fromPath = p;
        shortestPathData.fromOffset = d2;
        shortestPathData.toPath = p2;
        shortestPathData.toOffset = d3;
        return this.h(shortestPathData);
    }

    @Override
    public double getDistance(Point point, Point point2, P p, double d2, P p2, double d3, ShortestPathData<N, P> shortestPathData, LengthUnits lengthUnits) {
        return this.a(this.getDistance(point, point2, p, d2, p2, d3, shortestPathData), lengthUnits);
    }

    @Override
    public double getDistance(Point point, Point point2, ShortestPathData<N, P> shortestPathData) {
        shortestPathData = this.e(shortestPathData);
        shortestPathData.source = this.e(point);
        shortestPathData.target = this.e(point2);
        return this.h(shortestPathData);
    }

    @Override
    public double getDistance(Point point, Point point2, ShortestPathData<N, P> shortestPathData, LengthUnits lengthUnits) {
        return this.a(this.getDistance(point, point2, shortestPathData), lengthUnits);
    }

    @Override
    public Position getPosition(ShortestPathData<N, P> shortestPathData, double d2, Position position) {
        if (shortestPathData.isPlainMovement()) {
            return this.h(shortestPathData, d2, position);
        }
        if (d2 <= shortestPathData.targetSegmentDistance + 1.0E-4) {
            return this.h(shortestPathData, d2, position);
        }
        if ((d2 -= shortestPathData.targetSegmentDistance) <= shortestPathData.distance) {
            double d3 = shortestPathData.distance - d2;
            return this.a(shortestPathData, d3, position);
        }
        return this.e(shortestPathData, d2 -= shortestPathData.distance, position);
    }

    @Override
    public Position getPosition(ShortestPathData<N, P> shortestPathData, double d2, LengthUnits lengthUnits, Position position) {
        double d3 = this.e(d2, lengthUnits);
        return this.getPosition(shortestPathData, d3, position);
    }

    @Override
    void e() {
        super.e();
        this.l = true;
        for (IPath iPath : this.c) {
            if (iPath.isBidirectional()) continue;
            this.l = false;
            break;
        }
        this.b = this.j.size();
        this.n = this.ai = this.c.size();
        this.c.add(null);
    }

    @Override
    void a() {
        super.a();
        this.g = true;
        if (!this.g) {
            for (INode iNode : this.j) {
                switch (iNode.getConnectionsCount()) {
                    case 0: {
                        this.h(iNode).l = NodeType.HANGING;
                        break;
                    }
                    case 1: {
                        this.h(iNode).l = NodeType.LEAF;
                        break;
                    }
                    case 2: {
                        this.h(iNode).l = NodeType.TRANSIT;
                    }
                }
            }
            int n2 = 0;
            for (Object object : this.j) {
                int n3 = object.getConnectionsCount();
                if (n3 < 3) continue;
                int n4 = 0;
                while (n4 < object.getConnectionsCount()) {
                    Object p = object.getConnection(n4);
                    if (this.h(p.getOtherNode((Object)object)).l == NodeType.LEAF) {
                        --n3;
                    }
                    ++n4;
                }
                if (n3 >= 3) {
                    this.h(object).l = NodeType.HUB;
                    ++n2;
                    continue;
                }
                this.h(object).l = NodeType.TRANSIT;
            }
            this.g |= (double)n2 > 0.9 * (double)this.b;
        }
        if (this.g) {
            for (INode iNode : this.j) {
                NodeType nodeType = this.h(iNode).l = iNode.getConnectionsCount() > 0 ? NodeType.HUB : NodeType.HANGING;
            }
        } else {
            ArrayList<N> arrayList = new ArrayList<N>(this.b);
            for (Object object : this.j) {
                if (!this.a((N)object)) continue;
                this.a((N)object, (N)arrayList.size());
                arrayList.add(object);
            }
            this.b = arrayList.size();
            for (Object object : this.j) {
                if (this.a((N)object)) continue;
                this.a((N)object, (N)-1);
                arrayList.add(object);
            }
            this.j = arrayList;
        }
        this.i = new double[this.b][];
        this.f = new int[this.b][];
        if (this.b <= 1000 && this.ai <= 4000) {
            int n5 = 0;
            while (n5 < this.b) {
                this.k((INode)this.j.get(n5));
                ++n5;
            }
        }
    }

    final boolean a(N n2) {
        NodeType nodeType = this.h(n2).l;
        return nodeType == NodeType.HUB;
    }

    private void k(N n2) {
        int n3 = this.e(n2);
        this.i[n3] = new double[this.b];
        double[] dArray = this.i[n3];
        Arrays.fill(dArray, Double.POSITIVE_INFINITY);
        dArray[n3] = 0.0;
        this.f[n3] = new int[this.b];
        int[] nArray = this.f[n3];
        Arrays.fill(nArray, this.n);
        boolean[] blArray = new boolean[this.b];
        PriorityQueue<N> priorityQueue = new PriorityQueue<N>(this.b, new n<N>(this, dArray){

            @Override
            int a(N n2) {
                return this.e(n2);
            }
        });
        priorityQueue.add(n2);
        Point point = new Point();
        Point point2 = new Point();
        h h2 = new h();
        do {
            INode iNode = (INode)priorityQueue.poll();
            blArray[this.e(iNode)] = true;
            this.a(iNode, blArray, dArray, nArray, priorityQueue, point, point2, h2);
        } while (!priorityQueue.isEmpty());
    }

    private void a(N n2, boolean[] blArray, double[] dArray, int[] nArray, PriorityQueue<N> priorityQueue, Point point, Point point2, h<P> h2) {
        int n3 = this.e(n2);
        P p = this.a(nArray[n3]);
        int n4 = 0;
        while (n4 < n2.getConnectionsCount()) {
            int n5;
            N n6;
            Object p2 = n2.getConnection(n4);
            if (p2 != p && (n6 = this.a(n2, p2, h2)) != null && !blArray[n5 = this.e(n6)]) {
                double d2;
                double d3 = dArray[n3] + h2.e;
                if (p != null) {
                    d3 += this.a(n2, p, p2, point, point2);
                }
                if (d3 < (d2 = dArray[n5])) {
                    if (d2 < Double.POSITIVE_INFINITY) {
                        priorityQueue.remove(n6);
                    }
                    dArray[n5] = d3;
                    Object p3 = h2.a;
                    nArray[n5] = n6 == p3.getSource() ? this.a((P)p3) : -1 - this.a((P)p3);
                    priorityQueue.add(n6);
                }
            }
            ++n4;
        }
    }

    private N a(N n2, P p, h<P> h2) {
        double d2 = 0.0;
        while (true) {
            if (!p.isBidirectional() && n2 != p.getTarget()) {
                return null;
            }
            d2 += p.length();
            if ((n2 = p.getOtherNode(n2)) == null || this.a(n2)) break;
            if ((p = this.a(n2, (N)p)) == null) {
                return null;
            }
            d2 += this.h(n2).f;
        }
        h2.a = p;
        h2.e = d2;
        return n2;
    }

    private P a(int n2) {
        if (n2 < 0) {
            n2 = -1 - n2;
        }
        return (P)((IPath)this.c.get(n2));
    }

    abstract void a(INetworkMarkupElement var1, int var2);

    abstract P a(N var1, P var2);

    abstract int a(P var1);

    abstract int e(N var1);

    abstract void a(N var1, int var2);

    abstract double a(N var1, P var2, P var3, Point var4, Point var5);

    abstract com.anylogic.engine.markup.n<N> h(N var1);

    void a(ShortestPathData<N, P> shortestPathData) {
        if (shortestPathData.source == null && shortestPathData.fromPath == null && shortestPathData.fromNode == null) {
            throw this.error("Insufficient input data: source point / path / node are not specified");
        }
        if (shortestPathData.target == null && shortestPathData.toPath == null && shortestPathData.toNode == null) {
            throw this.error("Insufficient input data: target point / path / node are not specified");
        }
        if (shortestPathData.fromNode != null && shortestPathData.fromNode.getNetwork() != this) {
            throw this.error("Both nodes should belong to this network");
        }
        if (shortestPathData.fromPath != null) {
            if (shortestPathData.fromPath.getNetwork() != this) {
                throw this.error("Both nodes should belong to this network");
            }
            if (shortestPathData.fromOffset < 0.0 && shortestPathData.fromOffset > shortestPathData.fromPath.length()) {
                throw this.error(String.format("Invalid offset for path %s: %s (should be in 0..%s)", shortestPathData.fromPath.getName(), shortestPathData.fromOffset, shortestPathData.fromPath.length()));
            }
        }
        if (shortestPathData.toNode != null && shortestPathData.toNode.getNetwork() != this) {
            throw this.error("Both nodes should belong to this network");
        }
        if (shortestPathData.toPath != null && shortestPathData.toPath.getNetwork() != this) {
            if (shortestPathData.toPath.getNetwork() != this) {
                throw this.error("Both nodes should belong to this network");
            }
            if (shortestPathData.toOffset < 0.0 && shortestPathData.toOffset > shortestPathData.toPath.length()) {
                throw this.error(String.format("Invalid offset for path %s: %s (should be in 0..%s)", shortestPathData.toPath.getName(), shortestPathData.toOffset, shortestPathData.toPath.length()));
            }
        }
    }

    private ShortestPathData<N, P> e(ShortestPathData<N, P> shortestPathData) {
        if (shortestPathData == null) {
            shortestPathData = this.c();
        } else {
            shortestPathData.reset();
        }
        return shortestPathData;
    }

    abstract ShortestPathData<N, P> c();

    private double h(ShortestPathData<N, P> shortestPathData) {
        Position position;
        Position position2;
        this.h();
        this.a(shortestPathData);
        shortestPathData.network = this;
        this.j(shortestPathData);
        SimpleDirection simpleDirection = null;
        SimpleDirection simpleDirection2 = null;
        Object var4_4 = null;
        if (shortestPathData.fromPath != null && shortestPathData.fromPath == shortestPathData.toPath) {
            if (shortestPathData.toOffset >= shortestPathData.fromOffset) {
                shortestPathData.distance = shortestPathData.toOffset - shortestPathData.fromOffset;
                simpleDirection = SimpleDirection.DIRECTION1;
                simpleDirection2 = SimpleDirection.DIRECTION0;
            } else if (shortestPathData.fromPath.isBidirectional()) {
                shortestPathData.distance = shortestPathData.fromOffset - shortestPathData.toOffset;
                simpleDirection = SimpleDirection.DIRECTION0;
                simpleDirection2 = SimpleDirection.DIRECTION1;
            } else {
                shortestPathData.distance = Double.POSITIVE_INFINITY;
            }
        } else {
            N n2 = null;
            N n3 = null;
            position2 = null;
            position = null;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            SimpleDirection simpleDirection3 = null;
            SimpleDirection simpleDirection4 = null;
            SimpleDirection simpleDirection5 = null;
            SimpleDirection simpleDirection6 = null;
            if (shortestPathData.fromPath != null) {
                if (shortestPathData.fromPath.isBidirectional() && shortestPathData.fromPath.getSource() != null) {
                    n2 = shortestPathData.fromPath.getSource();
                    d2 = shortestPathData.fromOffset;
                    simpleDirection3 = SimpleDirection.DIRECTION0;
                    n3 = shortestPathData.fromPath.getTarget();
                    d3 = shortestPathData.fromPath.length() - shortestPathData.fromOffset;
                    simpleDirection4 = SimpleDirection.DIRECTION1;
                } else {
                    n2 = shortestPathData.fromPath.getTarget();
                    d2 = shortestPathData.fromPath.length() - shortestPathData.fromOffset;
                    simpleDirection3 = SimpleDirection.DIRECTION1;
                }
            } else {
                n2 = shortestPathData.fromNode;
            }
            if (shortestPathData.toPath != null) {
                if (shortestPathData.toPath.isBidirectional() && shortestPathData.toPath.getTarget() != null) {
                    position2 = shortestPathData.toPath.getTarget();
                    d4 = shortestPathData.toPath.length() - shortestPathData.toOffset;
                    simpleDirection5 = SimpleDirection.DIRECTION1;
                    position = shortestPathData.toPath.getSource();
                    d5 = shortestPathData.toOffset;
                    simpleDirection6 = SimpleDirection.DIRECTION0;
                } else {
                    position2 = (Position)shortestPathData.toPath.getSource();
                    d4 = shortestPathData.toOffset;
                    simpleDirection5 = SimpleDirection.DIRECTION0;
                }
            } else {
                position2 = (Position)shortestPathData.toNode;
            }
            if (n2 == null || position2 == null) {
                shortestPathData.distance = Double.POSITIVE_INFINITY;
            } else {
                INode iNode;
                INode iNode2;
                INode iNode3;
                INode iNode4;
                double d6;
                N n4 = n2;
                Position position3 = position2;
                double d7 = d2 + this.a(n2, simpleDirection3, position2, simpleDirection5, shortestPathData) + d4;
                if (shortestPathData != null) {
                    simpleDirection = shortestPathData.fromDirection;
                    simpleDirection2 = shortestPathData.toDirectionReverse;
                    var4_4 = shortestPathData.toHubIncomingPath;
                }
                if (position != null && (d6 = d2 + this.a(n2, simpleDirection3, position, simpleDirection6, shortestPathData) + d5) < d7) {
                    d7 = d6;
                    n4 = n2;
                    position3 = position2;
                    if (shortestPathData != null) {
                        simpleDirection = shortestPathData.fromDirection;
                        simpleDirection2 = shortestPathData.toDirectionReverse;
                        var4_4 = shortestPathData.toHubIncomingPath;
                    }
                }
                if (n3 != null) {
                    d6 = d3 + this.a(n3, simpleDirection4, position2, simpleDirection5, shortestPathData) + d4;
                    if (d6 < d7) {
                        d7 = d6;
                        n4 = n3;
                        position3 = position2;
                        if (shortestPathData != null) {
                            simpleDirection = shortestPathData.fromDirection;
                            simpleDirection2 = shortestPathData.toDirectionReverse;
                            var4_4 = shortestPathData.toHubIncomingPath;
                        }
                    }
                    if (position != null && (d6 = d3 + this.a(n3, simpleDirection4, position, simpleDirection6, shortestPathData) + d5) < d7) {
                        d7 = d6;
                        n4 = n3;
                        position3 = position;
                        if (shortestPathData != null) {
                            simpleDirection = shortestPathData.fromDirection;
                            simpleDirection2 = shortestPathData.toDirectionReverse;
                            var4_4 = shortestPathData.toHubIncomingPath;
                        }
                    }
                }
                if (shortestPathData.fromPath != null && (iNode4 = simpleDirection.getNextNode((IPath)shortestPathData.fromPath)) != null && (iNode3 = this.a(iNode4, shortestPathData.fromPath, simpleDirection, position3, null, null)) != null) {
                    d7 += iNode4.getTransferDistance(shortestPathData.fromPath, iNode3);
                }
                if (shortestPathData.toPath != null && (iNode2 = simpleDirection2.getNextNode((IPath)shortestPathData.toPath)) != null && (iNode3 = this.e(n4, null, null, iNode2, shortestPathData.toPath, simpleDirection2)) != null) {
                    d7 += iNode2.getTransferDistance(shortestPathData.toPath, iNode3);
                }
                if (shortestPathData.fromPath != null && shortestPathData.toPath != null && (iNode = simpleDirection.getNextNode((IPath)shortestPathData.fromPath)) == (iNode3 = simpleDirection2.getNextNode((IPath)shortestPathData.toPath))) {
                    d7 += iNode.getTransferDistance(shortestPathData.fromPath, shortestPathData.toPath);
                }
                shortestPathData.distance = d7;
            }
        }
        shortestPathData.fromDirection = simpleDirection;
        shortestPathData.toDirectionReverse = simpleDirection2;
        shortestPathData.toHubIncomingPath = var4_4;
        double d8 = shortestPathData.distance;
        if (Double.isInfinite(shortestPathData.distance)) {
            d8 = this.getPlainDistance(shortestPathData.source, shortestPathData.target);
            shortestPathData.sourceSegmentDistance = 0.0;
            shortestPathData.targetSegmentDistance = d8;
            shortestPathData.distance = d8;
            shortestPathData.setFromTargetDirection(shortestPathData.source);
        } else if (shortestPathData.distance > 0.0) {
            position2 = new Position();
            position = this.a(shortestPathData, 0.0, position2);
            if (position != null) {
                shortestPathData.fromX = position.x;
                shortestPathData.fromY = position.y;
                shortestPathData.fromZ = position.z;
            }
            if ((position = this.a(shortestPathData, shortestPathData.distance, position2)) != null) {
                shortestPathData.toX = position.x;
                shortestPathData.toY = position.y;
                shortestPathData.toZ = position.z;
            }
            if (shortestPathData.source == null) {
                shortestPathData.sourceSegmentDistance = 0.0;
                shortestPathData.resetToSourceDirection();
            } else {
                shortestPathData.sourceSegmentDistance = this.getPlainDistance(shortestPathData.source, new Point(shortestPathData.fromX, shortestPathData.fromY, shortestPathData.fromZ));
                shortestPathData.setToSourceDirection(new Point(shortestPathData.fromX, shortestPathData.fromY, shortestPathData.fromZ));
            }
            if (shortestPathData.target == null) {
                shortestPathData.targetSegmentDistance = 0.0;
                shortestPathData.resetFromTargetDirection();
            } else {
                shortestPathData.targetSegmentDistance = this.getPlainDistance(shortestPathData.target, new Point(shortestPathData.toX, shortestPathData.toY, shortestPathData.toZ));
                shortestPathData.setFromTargetDirection(new Point(shortestPathData.toX, shortestPathData.toY, shortestPathData.toZ));
            }
            d8 += shortestPathData.sourceSegmentDistance + shortestPathData.targetSegmentDistance;
        } else {
            d8 = this.getPlainDistance(shortestPathData.source, shortestPathData.target);
            shortestPathData.sourceSegmentDistance = 0.0;
            shortestPathData.targetSegmentDistance = d8;
            shortestPathData.setFromTargetDirection(shortestPathData.source);
        }
        this.k(shortestPathData);
        this.d(shortestPathData);
        return d8;
    }

    private void k(ShortestPathData<N, P> shortestPathData) {
        if (shortestPathData.source instanceof Position) {
            Position position = (Position)shortestPathData.source;
            shortestPathData.sourceRotation = position.rotation;
            shortestPathData.sourceVerticalRotation = position.verticalRotation;
        }
    }

    private void d(ShortestPathData<N, P> shortestPathData) {
        Position position;
        if (shortestPathData.target instanceof Position) {
            position = (Position)shortestPathData.target;
            shortestPathData.targetRotation = position.rotation;
            shortestPathData.targetVerticalRotation = position.verticalRotation;
        }
        if (Double.isNaN(shortestPathData.targetRotation) && (shortestPathData.toNode instanceof PointNode || shortestPathData.toNode instanceof GISPoint) && (position = this.e(shortestPathData.fromNode, shortestPathData.fromPath, shortestPathData.fromDirection, shortestPathData.toNode, shortestPathData.toPath, shortestPathData.toDirectionReverse)) != null) {
            Object n2 = position.getTarget();
            if (n2 == shortestPathData.toNode && position.getSource() != null) {
                n2 = position.getSource();
            }
            int n3 = this.e(shortestPathData.toNode);
            int n4 = this.e(n2);
            this.h(n3);
            int[] nArray = this.f[n3];
            int n5 = nArray[n4];
            SimpleDirection simpleDirection = this.e(n5);
            Position position2 = simpleDirection.getEndPosition((IPath)((Object)position), null);
            shortestPathData.targetRotation = position2.rotation;
            shortestPathData.targetVerticalRotation = position2.verticalRotation;
        }
    }

    private void j(ShortestPathData<N, P> shortestPathData) {
        double d2;
        int n2;
        Point point;
        double d3;
        double d4;
        INetworkMarkupElement iNetworkMarkupElement;
        if (shortestPathData.source != null && shortestPathData.fromPath == null && shortestPathData.fromNode == null) {
            iNetworkMarkupElement = this.a(shortestPathData.source);
            if (iNetworkMarkupElement instanceof INode) {
                shortestPathData.fromNode = (INode)iNetworkMarkupElement;
            } else if (iNetworkMarkupElement instanceof IPath) {
                shortestPathData.fromPath = (IPath)iNetworkMarkupElement;
                d4 = Double.POSITIVE_INFINITY;
                d3 = 0.0;
                point = new Point();
                n2 = 0;
                while (n2 < shortestPathData.fromPath.getSegmentCount()) {
                    d2 = shortestPathData.fromPath.getSegment(n2).getNearestPoint(shortestPathData.source, point);
                    if (d2 < d4) {
                        d4 = d2;
                        shortestPathData.fromOffset = d3 + shortestPathData.fromPath.getSegment(n2).getOffsetOfPoint(point.x, point.y);
                    }
                    d3 += shortestPathData.fromPath.getSegment(n2).length();
                    ++n2;
                }
            }
        }
        if (shortestPathData.target != null && shortestPathData.toPath == null && shortestPathData.toNode == null) {
            iNetworkMarkupElement = this.a(shortestPathData.target);
            if (iNetworkMarkupElement instanceof INode) {
                shortestPathData.toNode = (INode)iNetworkMarkupElement;
            } else if (iNetworkMarkupElement instanceof IPath) {
                shortestPathData.toPath = (IPath)iNetworkMarkupElement;
                d4 = Double.POSITIVE_INFINITY;
                d3 = 0.0;
                point = new Point();
                n2 = 0;
                while (n2 < shortestPathData.toPath.getSegmentCount()) {
                    d2 = shortestPathData.toPath.getSegment(n2).getNearestPoint(shortestPathData.target, point);
                    if (d2 < d4) {
                        d4 = d2;
                        shortestPathData.toOffset = d3 + shortestPathData.toPath.getSegment(n2).getOffsetOfPoint(point.x, point.y);
                    }
                    d3 += shortestPathData.toPath.getSegment(n2).length();
                    ++n2;
                }
            }
        }
    }

    private INetworkMarkupElement a(Point point) {
        Point point2 = new Point();
        double d2 = Double.POSITIVE_INFINITY;
        INode iNode = null;
        for (INode iNode2 : this.j) {
            double d3 = iNode2.getNearestPoint(point, point2);
            if (!(d3 < d2)) continue;
            d2 = d3;
            iNode = iNode2;
        }
        double d4 = Double.POSITIVE_INFINITY;
        IPath iPath = null;
        for (IPath iPath2 : this.c) {
            double d5;
            if (iPath2 == null || !((d5 = iPath2.getNearestPoint(point, point2)) < d4)) continue;
            d4 = d5;
            iPath = iPath2;
        }
        if (iNode == null && iPath == null) {
            return null;
        }
        if (d2 <= d4) {
            return iNode;
        }
        return iPath;
    }

    private double a(N n2, SimpleDirection simpleDirection, N n3, SimpleDirection simpleDirection2, ShortestPathData<N, P> shortestPathData) {
        this.h();
        if (shortestPathData != null) {
            shortestPathData.fromDirection = simpleDirection;
            shortestPathData.toDirectionReverse = simpleDirection2;
        }
        if (n2 == null || n3 == null || n2.getNetwork() != this || n3.getNetwork() != this) {
            throw this.error("Both nodes should belong to this network");
        }
        if (this.h(n2).l == NodeType.HANGING || this.h(n3).l == NodeType.HANGING) {
            return Double.POSITIVE_INFINITY;
        }
        if (n2 == n3) {
            return 0.0;
        }
        double d2 = 0.0;
        if (this.h(n2).l == NodeType.LEAF) {
            if ((d2 += this.h(n2).k) == Double.POSITIVE_INFINITY) {
                return d2;
            }
            n2 = this.h(n2).a;
        }
        if (this.h(n3).l == NodeType.LEAF) {
            if ((d2 += this.h(n3).h) == Double.POSITIVE_INFINITY) {
                return d2;
            }
            n3 = this.h(n3).a;
        }
        return d2 += this.h(n2, n3);
    }

    private Position a(ShortestPathData<N, P> shortestPathData, double d2, Position position) {
        Object object;
        Object object2;
        double d3;
        double d4;
        P p;
        Object object3;
        double d5;
        SimpleDirection simpleDirection;
        double d6 = d2;
        double d7 = shortestPathData.distance - d6;
        if (shortestPathData.fromPath != null) {
            if (d6 <= 0.0) {
                this.a(position, null, shortestPathData.fromPath);
                return shortestPathData.fromPath.getPositionAtOffset(shortestPathData.fromOffset, position);
            }
            simpleDirection = shortestPathData.fromDirection;
            d5 = simpleDirection.getOffsetOnPath(shortestPathData.fromOffset, d6);
            if (d5 >= 0.0 && d5 <= shortestPathData.fromPath.length() + 1.0E-4) {
                this.a(position, null, shortestPathData.fromPath);
                return simpleDirection.getPositionAtOffset((IPath)shortestPathData.fromPath, d5, position);
            }
            object3 = simpleDirection.getNextNode((IPath)shortestPathData.fromPath);
            p = this.c(shortestPathData);
            d4 = simpleDirection.getRemainingLength((IPath)shortestPathData.fromPath, shortestPathData.fromOffset);
            if (d6 - d4 < (d3 = object3.getTransferDistance(shortestPathData.fromPath, p))) {
                this.a(position, (N)object3, (P)null);
                double d8 = (d6 - d4) / d3;
                return object3.getTransferPositionByPercent(shortestPathData.fromPath, p, d8, true, position);
            }
            object2 = object3;
            d6 -= d4 + d3;
        } else {
            object2 = shortestPathData.fromNode;
        }
        if (shortestPathData.toPath != null) {
            if (d7 <= 0.0) {
                this.a(position, null, shortestPathData.toPath);
                return shortestPathData.toPath.getPositionAtOffset(shortestPathData.toOffset, position);
            }
            simpleDirection = shortestPathData.toDirectionReverse;
            d5 = simpleDirection.getOffsetOnPath(shortestPathData.toOffset, d7);
            if (d5 >= 0.0 && d5 <= shortestPathData.toPath.length() + 1.0E-4) {
                this.a(position, null, shortestPathData.toPath);
                object3 = simpleDirection.reverse();
                return ((SimpleDirection)((Object)object3)).getPositionAtOffset((IPath)shortestPathData.toPath, d5, position);
            }
            object3 = simpleDirection.getNextNode((IPath)shortestPathData.toPath);
            p = this.l(shortestPathData);
            d4 = simpleDirection.getRemainingLength((IPath)shortestPathData.toPath, shortestPathData.toOffset);
            if (d7 - d4 < (d3 = object3.getTransferDistance(shortestPathData.toPath, p))) {
                this.a(position, (N)object3, (P)null);
                double d9 = (d3 - d7 + d4) / d3;
                return object3.getTransferPositionByPercent(p, shortestPathData.toPath, d9, true, position);
            }
            object = object3;
        } else {
            object = shortestPathData.toNode;
        }
        return this.a(object2, object, d6, position);
    }

    private void a(Position position, N n2, P p) {
        if (position instanceof ff) {
            ff ff2 = (ff)position;
            ff2.a(this, n2, p);
        }
    }

    private P c(ShortestPathData<N, P> shortestPathData) {
        if (shortestPathData.h != null) {
            return shortestPathData.h;
        }
        shortestPathData.h = this.a(shortestPathData.fromNode, shortestPathData.fromPath, shortestPathData.fromDirection, shortestPathData.toNode, shortestPathData.toPath, shortestPathData.toDirectionReverse);
        return shortestPathData.h;
    }

    private P a(N object, P p, SimpleDirection simpleDirection, N object2, P p2, SimpleDirection simpleDirection2) {
        if (p != null) {
            object = simpleDirection.getNextNode((IPath)p);
        }
        if (p2 != null && (object2 = simpleDirection2.getNextNode((IPath)p2)) == object) {
            return p2;
        }
        return this.a((N)object, (N)object2);
    }

    private P a(N n2, N n3) {
        int n4 = this.e(n3);
        int n5 = this.e(n2);
        this.h(n4);
        int[] nArray = this.f[n4];
        int n6 = nArray[n5];
        return this.a(n6);
    }

    private P e(N object, P p, SimpleDirection simpleDirection, N object2, P p2, SimpleDirection simpleDirection2) {
        if (p2 != null) {
            object2 = simpleDirection2.getNextNode((IPath)p2);
        }
        if (p != null && object2 == (object = simpleDirection.getNextNode((IPath)p))) {
            return p;
        }
        return this.e(object, object2);
    }

    private P e(N object, N n2) {
        IPath iPath = null;
        int n3 = this.e(n2);
        this.h(n3);
        int[] nArray = this.f[n3];
        while (object != n2) {
            int n4 = this.e(object);
            int n5 = nArray[n4];
            iPath = (IPath)this.a(n5);
            if (iPath == null) {
                return null;
            }
            SimpleDirection simpleDirection = this.e(n5);
            object = simpleDirection.getNextNode(iPath);
        }
        return (P)iPath;
    }

    private SimpleDirection e(int n2) {
        return n2 >= 0 ? SimpleDirection.DIRECTION1 : SimpleDirection.DIRECTION0;
    }

    private double a(int n2, int n3) {
        if (this.i[n3] == null) {
            if (this.l && this.i[n2] != null) {
                return this.i[n2][n3];
            }
            this.k((INode)this.j.get(n3));
        }
        return this.i[n3][n2];
    }

    private void h(int n2) {
        if (this.i[n2] == null) {
            this.k((INode)this.j.get(n2));
        }
    }

    private Position a(N n2, N n3, double d2, Position position) {
        if (!this.a(n2) || !this.a(n3)) {
            throw new UnsupportedOperationException("TODO");
        }
        IPath iPath = null;
        SimpleDirection simpleDirection = null;
        Object object = n2;
        int n4 = this.e(n3);
        int n5 = this.e(n2);
        this.h(n4);
        double[] dArray = this.i[n4];
        int[] nArray = this.f[n4];
        double d3 = dArray[n5] - d2;
        while (true) {
            INode iNode;
            int n6 = nArray[this.e(object)];
            Object object2 = this.a(n6);
            SimpleDirection simpleDirection2 = this.e(n6);
            if (dArray[this.e(object)] < d3) {
                return this.a(iPath, simpleDirection, object, object2, d3 - dArray[this.e(object)], position);
            }
            if (object2 == null) {
                this.a(position, null, iPath);
                return iPath != null ? simpleDirection.getEndPosition(iPath, position) : null;
            }
            while (true) {
                iNode = simpleDirection2.getNextNode((IPath)object2);
                if (this.h(iNode).l == NodeType.HUB) break;
                object2 = simpleDirection2.getNextPath(iNode);
            }
            while (this.h(iNode).l != NodeType.HUB) {
            }
            iPath = (IPath)object2;
            object = iNode;
            simpleDirection = simpleDirection2;
        }
    }

    private Position a(P p, SimpleDirection simpleDirection, N n2, P p2, double d2, Position position) {
        if (p == null) {
            this.a(position, null, p2);
            return p2.getStartPosition(position);
        }
        if (p2 != null) {
            double d3 = n2.getTransferDistance(p2, p);
            if (d2 < d3) {
                this.a(position, n2, (P)null);
                return n2.getTransferPositionByPercent(p2, p, d2 / d3, false, position);
            }
            d2 -= d3;
        }
        this.a(position, null, p);
        return simpleDirection.getPositionAtOffset((IPath)p, simpleDirection.reverse().getOffsetOnPath((IPath)p, d2), position);
    }

    private P l(ShortestPathData<N, P> shortestPathData) {
        if (shortestPathData.k != null) {
            return shortestPathData.k;
        }
        shortestPathData.k = this.e(shortestPathData.fromNode, shortestPathData.fromPath, shortestPathData.fromDirection, shortestPathData.toNode, shortestPathData.toPath, shortestPathData.toDirectionReverse);
        return shortestPathData.k;
    }

    private double h(N n2, N n3) {
        if (this.a(n2)) {
            if (this.a(n3)) {
                return this.a(this.e(n2), this.e(n3));
            }
            return this.a(n3, this.e(n2), false);
        }
        if (this.a(n3)) {
            return this.a(n2, this.e(n3), true);
        }
        throw new RuntimeException("TODO implement");
    }

    private double a(N n2, int n3, boolean bl) {
        double d2;
        double d3 = Double.POSITIVE_INFINITY;
        if (this.h(n2).a != null) {
            double d4 = d2 = bl ? this.h(n2).k : this.h(n2).h;
            if (d2 < Double.POSITIVE_INFINITY) {
                d2 += bl ? this.a(this.e(this.h(n2).a), n3) : this.a(n3, this.e(this.h(n2).a));
            }
            d3 = Math.min(d3, d2);
        }
        if (this.h(n2).e != null) {
            double d5 = d2 = bl ? this.h(n2).j : this.h(n2).d;
            if (d2 < Double.POSITIVE_INFINITY) {
                d2 += bl ? this.a(this.e(this.h(n2).e), n3) : this.a(n3, this.e(this.h(n2).e));
            }
            d3 = Math.min(d3, d2);
        }
        return d3;
    }

    private Position e(ShortestPathData<N, P> shortestPathData, double d2, Position position) {
        d2 = Utilities.limit(0.0, d2, shortestPathData.sourceSegmentDistance);
        if (position == null) {
            position = new Position();
        }
        position = shortestPathData.getToSourcePosition(d2, position);
        return position;
    }

    private Position h(ShortestPathData<N, P> shortestPathData, double d2, Position position) {
        d2 = Utilities.limit(0.0, d2, shortestPathData.targetSegmentDistance);
        if (position == null) {
            position = new Position();
        }
        position = shortestPathData.getFromTargetPosition(d2, position);
        return position;
    }

    private Point e(Point point) {
        return point == null ? null : point.clone();
    }

    @Override
    public N getNearestNode(Point point) {
        Point point2 = new Point();
        double d2 = Double.POSITIVE_INFINITY;
        INode iNode = null;
        for (INode iNode2 : this.j) {
            double d3 = iNode2.getNearestPoint(point, point2);
            if (!(d3 < d2)) continue;
            d2 = d3;
            iNode = iNode2;
        }
        return (N)iNode;
    }

    @Override
    public abstract double getPlainDistance(Point var1, Point var2);

    protected abstract double a(double var1, LengthUnits var3);

    protected abstract double e(double var1, LengthUnits var3);

    @Override
    public double getPlainDistance(Point point, Point point2, LengthUnits lengthUnits) {
        return this.a(this.getPlainDistance(point, point2), lengthUnits);
    }

    protected void l() {
        if (this.getSpace() == null) {
            this.error(ae.mkb);
        }
    }

    @Override
    public double getDistance(Point point, Point point2) {
        return this.getDistance(point, point2, (ShortestPathData<N, P>)null);
    }

    @Override
    public ShortestPathData<N, P> getPathData(Point point, Point point2, ShortestPathData<N, P> shortestPathData) {
        shortestPathData = this.e(shortestPathData);
        this.getDistance(point, point2, shortestPathData);
        return shortestPathData;
    }

    @Override
    public Position getPositionAtOffset(ShortestPathData<N, P> shortestPathData, double d2, Position position) {
        return this.getPosition(shortestPathData, d2, position);
    }

    @Override
    public double getLength(ShortestPathData<N, P> shortestPathData) {
        return this.h(shortestPathData);
    }

    private abstract class n<N extends INode<N, ?>>
    implements Comparator<N> {
        private final double[] a;

        n(double[] dArray) {
            this.a = dArray;
        }

        public int a(N n2, N n3) {
            return Double.compare(this.a[this.a(n2)], this.a[this.a(n3)]);
        }

        abstract int a(N var1);

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((INode)object, (INode)object2);
        }
    }

    private class h<P extends IPath> {
        P a;
        double e;

        private h() {
        }
    }
}

