/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.Pair;
import com.anylogic.engine.Point;
import com.anylogic.engine.internal.ae;
import com.anylogic.engine.markup.AbstractRoadConnectableElement;
import com.anylogic.engine.markup.MarkupSegment;
import com.anylogic.engine.markup.Road;
import com.anylogic.engine.markup.RoadBasicDataSource;
import com.anylogic.engine.markup.RoadConnectionPoint;
import com.anylogic.engine.markup.RoadConstants;
import com.anylogic.engine.markup.RoadEnd;
import com.anylogic.engine.markup.RoadLanesConnector;
import com.anylogic.engine.markup.l;
import com.anylogic.engine.presentation.Panel;
import com.anylogic.engine.presentation.ShapeDrawMode;
import com.anylogic.engine.presentation.ShapePolyLine;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@AnyLogicInternalAPI
public abstract class AbstractRoadConnector
extends AbstractRoadConnectableElement {
    private static final long serialVersionUID = -6412114235027299404L;
    protected final List<RoadConnectionPoint> a = new ArrayList<RoadConnectionPoint>();
    protected final List<RoadConnectionPoint> e = new ArrayList<RoadConnectionPoint>();
    protected final List<RoadConnectionPoint> c = new ArrayList<RoadConnectionPoint>();
    protected final Map<Pair<RoadConnectionPoint, RoadConnectionPoint>, List<MarkupSegment>> l = new LinkedHashMap<Pair<RoadConnectionPoint, RoadConnectionPoint>, List<MarkupSegment>>();
    protected final List<List<MarkupSegment>> f = new ArrayList<List<MarkupSegment>>();
    @AnyLogicCustomSerialization
    private transient RoadBasicDataSource ai;
    protected static final int i = 10;
    protected transient List<RoadEnd> n = new ArrayList<RoadEnd>();
    protected transient List<RoadLanesConnector> m = new ArrayList<RoadLanesConnector>();
    @Deprecated
    public List<ShapePolyLine> guidelineShapePolylines = new ArrayList<ShapePolyLine>();

    public AbstractRoadConnector() {
    }

    public AbstractRoadConnector(Agent agent, ShapeDrawMode shapeDrawMode, boolean bl, RoadEnd[] roadEndArray, RoadLanesConnector ... roadLanesConnectorArray) {
        super(agent, shapeDrawMode, bl);
        Collections.addAll(this.n, roadEndArray);
        Collections.addAll(this.m, roadLanesConnectorArray);
    }

    @AnyLogicInternalAPI
    public void setDataSource(RoadBasicDataSource roadBasicDataSource) {
        if (roadBasicDataSource == null) {
            this.a(ae.ind, "dataSource");
        }
        if (roadBasicDataSource == this.ai) {
            return;
        }
        if (this.ai != null) {
            this.a(ae.ldh, roadBasicDataSource);
        }
        this.ai = roadBasicDataSource;
    }

    public int nCars() {
        return this.ai == null ? 0 : this.ai.nCars();
    }

    public List<Agent> getCars() {
        return this.ai == null ? Collections.emptyList() : this.ai.getCars();
    }

    protected void a(RoadConnectionPoint[][] roadConnectionPointArray) {
        RoadConnectionPoint[][] roadConnectionPointArray2 = roadConnectionPointArray;
        int n2 = roadConnectionPointArray.length;
        int n3 = 0;
        while (n3 < n2) {
            RoadConnectionPoint[] roadConnectionPointArray3;
            RoadConnectionPoint[] roadConnectionPointArray4 = roadConnectionPointArray3 = roadConnectionPointArray2[n3];
            int n4 = roadConnectionPointArray3.length;
            int n5 = 0;
            while (n5 < n4) {
                RoadConnectionPoint roadConnectionPoint = roadConnectionPointArray4[n5];
                RoadConnectionPoint roadConnectionPoint2 = roadConnectionPoint.createConnectedPoint(this);
                if (roadConnectionPoint2.isIncoming()) {
                    this.a.add(roadConnectionPoint2);
                } else {
                    this.e.add(roadConnectionPoint2);
                }
                this.c.add(roadConnectionPoint2);
                ++n5;
            }
            ++n3;
        }
    }

    protected void e() {
    }

    protected void h() {
    }

    protected void k() {
        boolean bl = false;
        boolean bl2 = false;
        for (RoadConnectionPoint roadConnectionPoint : this.c) {
            if (roadConnectionPoint.isIncoming()) {
                bl = true;
            } else {
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            return;
        }
        this.error("The road element should have at least one incoming and at least one outgoing road connection point.");
    }

    public static List<MarkupSegment> generateDefaultGuideline(RoadConnectionPoint roadConnectionPoint, RoadConnectionPoint roadConnectionPoint2) {
        MarkupSegment markupSegment = com.anylogic.engine.markup.l.a(roadConnectionPoint.getDirectionSegment(), roadConnectionPoint2.getDirectionSegment());
        return Collections.singletonList(markupSegment);
    }

    public void setGuideline(RoadConnectionPoint roadConnectionPoint, RoadConnectionPoint roadConnectionPoint2, List<MarkupSegment> list) {
        if (roadConnectionPoint.getOwner() != this) {
            this.error("Incoming connection point should belong to markup element.");
        }
        if (roadConnectionPoint2.getOwner() != this) {
            this.error("Outgoing connection point should belong to markup element.");
        }
        if (!roadConnectionPoint.isIncoming()) {
            this.error("Incoming connection point is not incoming.");
        }
        if (roadConnectionPoint2.isIncoming()) {
            this.error("Outgoing connection point is not outgoing.");
        }
        if (list == null || list.isEmpty()) {
            throw this.error("Guideline should contain at least one segment.");
        }
        Point point = roadConnectionPoint.getDirectionSegment().getStart(new Point());
        Point point2 = list.get(0).getStart(new Point());
        if (!point2.equals(point, 1.0E-6)) {
            this.a("Guideline should start at incoming connection point: %s, %s", point2, point);
        }
        Point point3 = roadConnectionPoint2.getDirectionSegment().getStart(new Point());
        point2 = list.get(list.size() - 1).getEnd(new Point());
        if (!point2.equals(point3, 1.0E-6)) {
            this.a("Guideline should end at outgoing connection point: %s, %s", point2, point3);
        }
        Pair<RoadConnectionPoint, RoadConnectionPoint> pair = new Pair<RoadConnectionPoint, RoadConnectionPoint>(roadConnectionPoint, roadConnectionPoint2);
        this.l.put(pair, list);
        this.f.add(list);
    }

    public List<RoadConnectionPoint> getIncomingConnectionPoints() {
        return this.a;
    }

    public List<RoadConnectionPoint> getOutgoingConnectionPoints() {
        return this.e;
    }

    public RoadConnectionPoint getConnectionPoint(RoadConnectionPoint roadConnectionPoint) {
        RoadConnectionPoint roadConnectionPoint2 = null;
        for (RoadConnectionPoint roadConnectionPoint3 : this.c) {
            if (roadConnectionPoint3.getConnectedPoint() != roadConnectionPoint) continue;
            roadConnectionPoint2 = roadConnectionPoint3;
            break;
        }
        return roadConnectionPoint2;
    }

    public RoadConnectionPoint getConnectionPoint(RoadConstants.ConnectionPointDirection connectionPointDirection, Road road, int n2) {
        RoadConnectionPoint roadConnectionPoint = null;
        for (RoadConnectionPoint roadConnectionPoint2 : this.c) {
            if (roadConnectionPoint2.isIncoming() != (connectionPointDirection == RoadConstants.ConnectionPointDirection.INCOMING) || roadConnectionPoint2.getConnectedPoint().getOwner() != road || road.getLaneIndex(roadConnectionPoint2.getConnectedPoint()) != n2) continue;
            roadConnectionPoint = roadConnectionPoint2;
            break;
        }
        return roadConnectionPoint;
    }

    public void setGuideline(RoadConnectionPoint roadConnectionPoint, RoadConnectionPoint roadConnectionPoint2) {
        List<MarkupSegment> list = AbstractRoadConnector.generateDefaultGuideline(roadConnectionPoint, roadConnectionPoint2);
        this.setGuideline(roadConnectionPoint, roadConnectionPoint2, list);
    }

    public Map<Pair<RoadConnectionPoint, RoadConnectionPoint>, List<MarkupSegment>> getGuidelines() {
        return this.l;
    }

    @Override
    public List<RoadConnectionPoint> getConnectionPoints() {
        return this.c;
    }

    @Override
    void i() {
        super.i();
        if (this.n.size() < 2) {
            this.error("This markup should connect at least two roads");
        }
    }

    @Override
    protected void c() {
        Serializable serializable;
        Serializable serializable2;
        super.c();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        for (RoadEnd object : this.n) {
            serializable2 = object.getRoad();
            serializable = new ArrayList<Object>();
            for (RoadConnectionPoint roadConnectionPoint : serializable2.getOutgoingConnectionPoints(object.getType())) {
                RoadConnectionPoint roadConnectionPoint2 = roadConnectionPoint.createConnectedPoint(this);
                this.a.add(roadConnectionPoint2);
                serializable.add(roadConnectionPoint2);
            }
            ArrayList<RoadConnectionPoint> arrayList = new ArrayList<RoadConnectionPoint>();
            for (RoadConnectionPoint roadConnectionPoint : serializable2.getIncomingConnectionPoints(object.getType())) {
                RoadConnectionPoint roadConnectionPoint3 = roadConnectionPoint.createConnectedPoint(this);
                this.e.add(roadConnectionPoint3);
                arrayList.add(roadConnectionPoint3);
            }
            hashMap.put((Road)serializable2, serializable);
            hashMap2.put((Road)serializable2, arrayList);
        }
        this.c.addAll(this.a);
        this.c.addAll(this.e);
        for (RoadLanesConnector roadLanesConnector : this.m) {
            try {
                serializable2 = (RoadConnectionPoint)((List)hashMap.get(roadLanesConnector.a)).get(roadLanesConnector.e);
                serializable = (RoadConnectionPoint)((List)hashMap2.get(roadLanesConnector.h)).get(roadLanesConnector.k);
            }
            catch (IndexOutOfBoundsException | NullPointerException runtimeException) {
                throw this.a("Roads/lanes not found: %s", roadLanesConnector);
            }
            if (roadLanesConnector.d != null) {
                this.setGuideline((RoadConnectionPoint)serializable2, (RoadConnectionPoint)serializable, roadLanesConnector.d);
                continue;
            }
            this.setGuideline((RoadConnectionPoint)serializable2, (RoadConnectionPoint)serializable);
        }
        this.k();
        this.h();
        this.e();
        this.m = null;
        this.n = null;
    }

    public void addRoad(Road road, RoadEnd.Type type) {
        this.j();
        this.n.add(new RoadEnd(road, type));
    }

    public void addConnection(Road road, int n2, Road road2, int n3) {
        this.j();
        this.m.add(new RoadLanesConnector(road, n2, road2, n3));
    }

    public void addConnection(Road road, int n2, Road road2, int n3, MarkupSegment ... markupSegmentArray) {
        this.j();
        this.m.add(new RoadLanesConnector(road, n2, road2, n3, markupSegmentArray));
    }

    public void addConnection(Road road, int n2, Road road2, int n3, List<MarkupSegment> list) {
        this.j();
        this.m.add(new RoadLanesConnector(road, n2, road2, n3, list));
    }

    @Override
    public void draw(Panel panel, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl) {
        this.a(panel, graphics2D, affineTransform, bl);
    }

    @Deprecated
    public void createTemporaryVisualization() {
        this.guidelineShapePolylines.clear();
        for (List<MarkupSegment> list : this.f) {
            this.guidelineShapePolylines.add(com.anylogic.engine.markup.l.a(list, 10.0, (Paint)this.b.getRoadBackgroundColor(), null));
        }
    }

    @Deprecated
    private void a(Panel panel, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl) {
        this.createTemporaryVisualization();
        if (this.g) {
            for (RoadConnectionPoint serializable : this.c) {
                serializable.draw(panel, graphics2D, affineTransform, true);
            }
            for (ShapePolyLine shapePolyLine : this.guidelineShapePolylines) {
                shapePolyLine.draw(panel, graphics2D, affineTransform, true);
            }
        }
    }
}

