/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.LengthUnits;
import com.anylogic.engine.internal.ae;
import com.anylogic.engine.internal.presentation.e;
import com.anylogic.engine.markup.AbstractRoadSidePart;
import com.anylogic.engine.markup.MarkupSegment;
import com.anylogic.engine.markup.MarkupSegmentLine;
import com.anylogic.engine.markup.PathDrawingType;
import com.anylogic.engine.markup.Road;
import com.anylogic.engine.markup.RoadBasicDataSource;
import com.anylogic.engine.markup.RoadConstants;
import com.anylogic.engine.markup.l;
import com.anylogic.engine.presentation.Panel;
import com.anylogic.engine.presentation.ShapeDrawMode;
import com.anylogic.engine.presentation.ShapePolyLine;
import com.anylogic.engine.presentation.UtilitiesColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BusStop
extends AbstractRoadSidePart {
    private static final long serialVersionUID = -8064550826783339219L;
    private final double l = 8.0;
    private double f;
    private List<MarkupSegment> i;
    private List<MarkupSegment> n;
    private List<MarkupSegment> m;
    @AnyLogicCustomSerialization
    private transient RoadBasicDataSource ai;
    private Path2D hn;
    private Path2D gd;
    @Deprecated
    private ShapePolyLine fc = new ShapePolyLine();
    @Deprecated
    private ShapePolyLine jc = new ShapePolyLine();

    private void h() {
        if (this.f < 8.0) {
            this.a("Error while creating road bus stop: length cannot be less then %s meters.", 8.0);
        }
    }

    public BusStop() {
    }

    public BusStop(Road road, ShapeDrawMode shapeDrawMode, boolean bl, boolean bl2, double d2, double d3) {
        super(road, shapeDrawMode, bl, bl2, d2);
        this.f = d3;
        this.initialize();
    }

    @AnyLogicInternalAPI
    public void setDataSource(RoadBasicDataSource roadBasicDataSource) {
        if (roadBasicDataSource == null) {
            this.a(ae.ind, "dataSource");
        }
        if (roadBasicDataSource == this.ai) {
            return;
        }
        if (this.ai != null) {
            this.a(ae.ldh, roadBasicDataSource);
        }
        this.ai = roadBasicDataSource;
    }

    public int nCars() {
        return this.ai == null ? 0 : this.ai.nCars();
    }

    public List<Agent> getCars() {
        return this.ai == null ? Collections.emptyList() : this.ai.getCars();
    }

    @Override
    void i() {
        super.i();
        this.h();
    }

    @Override
    protected void c() {
        super.c();
        double d2 = this.bj.toPixels(this.f, LengthUnits.METER);
        double d3 = this.b.getDrivingDirection() == RoadConstants.DrivingDirection.RIGHT_HAND ? 1 : -1;
        double d4 = this.c ? 1 : -1;
        int n2 = this.c ? this.a.getForwardLanesCount() : this.a.getBackwardLanesCount();
        double d5 = d3 * d4 * this.b.getLaneWidthInPixels();
        double d6 = d5 * ((double)n2 + 0.5);
        double d7 = d5 * ((double)n2 - 0.5);
        double d8 = this.c ? this.e : this.e - d2;
        double d9 = d8 + d2;
        this.i = com.anylogic.engine.markup.l.h(this.a.getAxisMarkupSegments(), d7);
        this.i = com.anylogic.engine.markup.l.a(this.i, d8, d9);
        this.n = com.anylogic.engine.markup.l.h(this.a.getAxisMarkupSegments(), d6);
        this.n = com.anylogic.engine.markup.l.a(this.n, d8, d9);
        ArrayList<MarkupSegment> arrayList = new ArrayList<MarkupSegment>();
        MarkupSegmentLine markupSegmentLine = com.anylogic.engine.markup.l.a(com.anylogic.engine.markup.l.a(this.i, 0.0), com.anylogic.engine.markup.l.a(this.i, 10.0));
        MarkupSegmentLine markupSegmentLine2 = com.anylogic.engine.markup.l.a(com.anylogic.engine.markup.l.a(this.n, 15.0), com.anylogic.engine.markup.l.a(this.n, 25.0));
        arrayList.add(com.anylogic.engine.markup.l.a(markupSegmentLine, markupSegmentLine2));
        arrayList.addAll(com.anylogic.engine.markup.l.a(this.n, 26.0, d2 - 26.0));
        MarkupSegmentLine markupSegmentLine3 = com.anylogic.engine.markup.l.a(com.anylogic.engine.markup.l.a(this.n, d2 - 25.0), com.anylogic.engine.markup.l.a(this.n, d2 - 15.0));
        MarkupSegmentLine markupSegmentLine4 = com.anylogic.engine.markup.l.a(com.anylogic.engine.markup.l.a(this.i, d2 - 10.0), com.anylogic.engine.markup.l.a(this.i, d2));
        arrayList.add(com.anylogic.engine.markup.l.a(markupSegmentLine3, markupSegmentLine4));
        this.m = arrayList;
        this.n();
    }

    public double getLengthInPixels() {
        return this.bj.toPixels(this.f, LengthUnits.METER);
    }

    public double getLength() {
        return this.f;
    }

    public double getLength(LengthUnits lengthUnits) {
        return LengthUnits.METER.convertTo(this.getLength(), lengthUnits);
    }

    public void setLength(double d2) {
        this.j();
        this.f = d2;
    }

    public void setLength(double d2, LengthUnits lengthUnits) {
        this.setLength(lengthUnits.convertTo(d2, LengthUnits.METER));
    }

    @Override
    public void draw(Panel panel, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl) {
        if (this.hn == null) {
            this.hn = com.anylogic.engine.internal.presentation.e.a(this.m);
        }
        if (this.gd == null) {
            this.gd = com.anylogic.engine.internal.presentation.e.a(this.n);
        }
        com.anylogic.engine.internal.presentation.e.a(graphics2D, this.gd, PathDrawingType.PATH_LINE, (float)this.b.getLaneWidthInPixels(), (Paint)this.b.getRoadBackgroundColor());
        Color color = UtilitiesColor.darker(this.b.getRoadBackgroundColor(), 0.5);
        com.anylogic.engine.internal.presentation.e.a(graphics2D, this.hn, PathDrawingType.PATH_LINE, 0.5f, (Paint)color);
    }

    @Deprecated
    private void n() {
        this.fc = com.anylogic.engine.markup.l.a(this.m, 0.5, (Paint)UtilitiesColor.darker(this.b.getRoadBackgroundColor(), 0.5), null);
        this.jc = com.anylogic.engine.markup.l.a(this.n, this.b.getLaneWidthInPixels(), (Paint)this.b.getRoadBackgroundColor(), null);
    }

    @Deprecated
    private void a(Panel panel, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl) {
        this.jc.draw(panel, graphics2D, affineTransform, true);
        this.fc.draw(panel, graphics2D, affineTransform, true);
    }
}

