/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.Path3D;
import com.anylogic.engine.Point;
import com.anylogic.engine.markup.AbstractNetworkCurve;
import com.anylogic.engine.markup.MarkupSegment;
import com.anylogic.engine.markup.MarkupSegmentArc;
import com.anylogic.engine.markup.MarkupSegmentLine;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;

@AnyLogicInternalAPI
public abstract class CircularCurve
extends AbstractNetworkCurve<MarkupSegment> {
    private static final long serialVersionUID = 4318663022525303660L;
    private transient Path3D k = null;
    private transient Path2D d;
    private transient Rectangle2D j;

    public void startDrawing(double d2, double d3, double d4) {
        this.e();
        this.h = new double[]{d2, d3, d4};
    }

    @Override
    public void startDrawing(Point point) {
        this.startDrawing(point.x, point.y, point.z);
    }

    public void lineTo(double d2, double d3, double d4) {
        this.e();
        MarkupSegmentLine markupSegmentLine = new MarkupSegmentLine();
        this.a(markupSegmentLine);
        markupSegmentLine.setEnd(d2, d3, d4);
        markupSegmentLine.initialize();
        this.a.add(markupSegmentLine);
    }

    @Override
    public void lineTo(Point point) {
        this.lineTo(point.x, point.y, point.z);
    }

    public void arcTo(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.e();
        MarkupSegmentArc markupSegmentArc = new MarkupSegmentArc();
        this.a(markupSegmentArc);
        markupSegmentArc.setEnd(d2, d3, d4);
        markupSegmentArc.setAngles(d5, d6, d7);
        markupSegmentArc.initialize();
        this.a.add(markupSegmentArc);
    }

    public final Point getPointAtOffset(double d2, Point point) {
        if (point == null) {
            point = new Point();
        }
        this.a(d2, point);
        return point;
    }

    public double getNearestPoint(double d2, double d3, double d4, Point point) {
        return this.getNearestPoint(new Point(d2, d3, d4), point);
    }

    public double getNearestPoint(double d2, double d3, Point point) {
        this.a();
        double d4 = Double.POSITIVE_INFINITY;
        Point point2 = new Point();
        for (MarkupSegment markupSegment : this.a) {
            double d5 = markupSegment.getNearestPoint(d2, d3, point2);
            if (!(d5 < d4)) continue;
            d4 = d5;
            point.setLocation(point2);
        }
        return d4;
    }

    public Path3D toPath3D() {
        if (this.k == null) {
            this.a();
            this.k = new Path3D(){

                @Override
                public double getZOffset() {
                    return 0.0;
                }

                @Override
                public double getX() {
                    return 0.0;
                }

                @Override
                public double getY() {
                    return 0.0;
                }

                @Override
                public double getZ() {
                    return 0.0;
                }

                @Override
                public int getNPoints() {
                    return CircularCurve.this.a.size() + 1;
                }

                @Override
                public double getPointDx(int n2) {
                    return n2 < CircularCurve.this.a.size() ? ((MarkupSegment)CircularCurve.this.a.get(n2)).getStartX() : ((MarkupSegment)CircularCurve.this.a.get(CircularCurve.this.a.size() - 1)).getEndX();
                }

                @Override
                public double getPointDy(int n2) {
                    return n2 < CircularCurve.this.a.size() ? ((MarkupSegment)CircularCurve.this.a.get(n2)).getStartY() : ((MarkupSegment)CircularCurve.this.a.get(CircularCurve.this.a.size() - 1)).getEndY();
                }

                @Override
                public double getPointDz(int n2) {
                    return n2 < CircularCurve.this.a.size() ? ((MarkupSegment)CircularCurve.this.a.get(n2)).getStartZ() : ((MarkupSegment)CircularCurve.this.a.get(CircularCurve.this.a.size() - 1)).getEndZ();
                }
            };
        }
        return this.k;
    }

    public Path2D getPath2D() {
        Path2D path2D = this.d;
        if (path2D == null) {
            this.a();
            path2D = new Path2D.Float(0);
            if (!this.a.isEmpty()) {
                MarkupSegment markupSegment = (MarkupSegment)this.a.get(0);
                path2D.moveTo(markupSegment.getStartX(), markupSegment.getStartY());
            }
            for (MarkupSegment markupSegment : this.a) {
                markupSegment.addTo(path2D);
            }
            this.d = path2D;
        }
        return path2D;
    }

    public Rectangle2D getBounds() {
        Rectangle2D rectangle2D = this.j;
        if (rectangle2D == null) {
            this.j = rectangle2D = this.getPath2D().getBounds2D();
        }
        return rectangle2D;
    }
}

