/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.markup.Node;
import com.anylogic.engine.markup.Path;
import com.anylogic.engine.markup.ShortestPathData;

public class ContinuousShortestPathData
extends ShortestPathData<Node, Path> {
    private static final long serialVersionUID = 6804682432264992972L;
    public double toSourceNx;
    public double toSourceNy;
    public double toSourceNz;
    public double sourceAutoRotation;
    public double sourceAutoVerticalRotation = Double.NaN;
    public double fromTargetNx;
    public double fromTargetNy;
    public double fromTargetNz;
    public double targetAutoRotation;
    public double targetAutoVerticalRotation = Double.NaN;

    @Override
    public void setFromTargetDirection(Point point) {
        this.fromTargetNx = point.x - this.target.x;
        this.fromTargetNy = point.y - this.target.y;
        this.fromTargetNz = point.z - this.target.z;
        if (this.targetSegmentDistance > 0.0) {
            this.fromTargetNx /= this.targetSegmentDistance;
            this.fromTargetNy /= this.targetSegmentDistance;
            this.fromTargetNz /= this.targetSegmentDistance;
        }
        this.targetAutoRotation = this.targetSegmentDistance != 0.0 ? Math.atan2(-this.fromTargetNy, -this.fromTargetNx) : Double.NaN;
        this.targetAutoVerticalRotation = this.targetSegmentDistance != 0.0 ? -Math.atan2(-this.fromTargetNz, Utilities.getLength(this.fromTargetNx, this.fromTargetNy)) : Double.NaN;
    }

    @Override
    public void setToSourceDirection(Point point) {
        this.toSourceNx = this.source.x - point.x;
        this.toSourceNy = this.source.y - point.y;
        this.toSourceNz = this.source.z - point.z;
        if (this.sourceSegmentDistance > 0.0) {
            this.toSourceNx /= this.sourceSegmentDistance;
            this.toSourceNy /= this.sourceSegmentDistance;
            this.toSourceNz /= this.sourceSegmentDistance;
        }
        this.sourceAutoRotation = this.sourceSegmentDistance != 0.0 ? Math.atan2(-this.toSourceNy, -this.toSourceNx) : Double.NaN;
        this.sourceAutoVerticalRotation = this.sourceSegmentDistance != 0.0 ? -Math.atan2(-this.toSourceNz, Utilities.getLength(this.toSourceNx, this.toSourceNy)) : Double.NaN;
    }

    @Override
    public Position getToSourcePosition(double d2, Position position) {
        if (position == null) {
            position = new Position();
        }
        position.setPosition(this.fromX + this.toSourceNx * d2, this.fromY + this.toSourceNy * d2, this.fromZ + this.toSourceNz * d2, this.sourceAutoRotation, this.sourceAutoVerticalRotation);
        return position;
    }

    @Override
    public Position getFromTargetPosition(double d2, Position position) {
        if (position == null) {
            position = new Position();
        }
        position.setPosition(this.target.x + this.fromTargetNx * d2, this.target.y + this.fromTargetNy * d2, this.target.z + this.fromTargetNz * d2, d2 > 0.0 ? this.targetAutoRotation : this.targetRotation, d2 > 0.0 ? this.targetAutoVerticalRotation : this.targetVerticalRotation);
        return position;
    }

    @Override
    public void resetFromTargetDirection() {
        this.fromTargetNz = 0.0;
        this.fromTargetNy = 0.0;
        this.fromTargetNx = 0.0;
    }

    @Override
    public void resetToSourceDirection() {
        this.toSourceNz = 0.0;
        this.toSourceNy = 0.0;
        this.toSourceNx = 0.0;
    }

    @Override
    public void reset() {
        super.reset();
        this.sourceAutoVerticalRotation = Double.NaN;
        this.sourceAutoRotation = Double.NaN;
        this.targetAutoVerticalRotation = Double.NaN;
        this.targetAutoRotation = Double.NaN;
    }
}

