/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.ga;
import com.anylogic.engine.markup.GISMarkupSegment;
import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.Intersection;
import java.awt.geom.Path2D;

public class GISMarkupSegmentLine
extends GISMarkupSegment {
    private static final long serialVersionUID = 8730348091371353008L;
    private double c;
    double j = 1.0;
    private Geo l;
    private Geo f;
    private Geo i = new Geo();
    private Geo n;

    public GISMarkupSegmentLine() {
    }

    public GISMarkupSegmentLine(double d2, double d3, double d4, double d5) {
        super(d2, d3, d4, d5);
        this.initialize();
    }

    public GISMarkupSegmentLine(double d2, double d3, double d4, double d5, double d6) {
        super(d2, d3, d4, d5);
        this.a = d6;
        this.initialize();
    }

    @Override
    public void initialize() {
        double d2 = Utilities.getDistanceGIS(this.e, this.h, this.k, this.d);
        if (this.a == -1.0) {
            this.a = d2;
        } else {
            this.j = d2 / this.a;
        }
        this.c = ga.e(this.e, this.h, this.k, this.d);
        this.l = new Geo(this.e, this.h);
        this.f = new Geo(this.k, this.d);
    }

    public double getNearestPoint(double d2, double d3, Point point) {
        Point point2 = ga.a(point, this.e, this.h, this.k, this.d, d2, d3);
        double d4 = Utilities.getDistanceGIS(point2.x, point2.y, d2, d3);
        return d4 * d4;
    }

    @Override
    public double getNearestPoint(Point point, Point point2) {
        return this.getNearestPoint(point.x, point.y, point2);
    }

    @Override
    public double getOffsetOfPoint(double d2, double d3) {
        return Utilities.getDistanceGIS(this.e, this.h, d2, d3) / this.j;
    }

    @Override
    public Point getStart(Point point) {
        if (point == null) {
            point = new Point();
        }
        point.setLocation(this.e, this.h);
        return point;
    }

    @Override
    public Point getEnd(Point point) {
        if (point == null) {
            point = new Point();
        }
        point.setLocation(this.k, this.d);
        return point;
    }

    @Override
    public double getNearestPointOnRay2D(double d2, double d3, double d4, double d5, Point point) {
        Geo geo;
        Geo geo2;
        if (point == null) {
            point = new Point();
        }
        if (this.getDistanceSq(d2, d3) <= 1.0E-30) {
            point.setLocation(d2, d3);
            return 0.0;
        }
        Geo geo3 = Intersection.getIntersectionGeo((double)d2, (double)d3, (double)d4, (double)d5, (double)this.e, (double)this.h, (double)this.k, (double)this.d);
        Geo geo4 = this.l;
        if ((Double.isNaN(geo3.x()) || Double.isNaN(geo3.y()) || Double.isNaN(geo3.z())) && (Geo.distance((Geo)(geo2 = new Geo(d2, d3)), (Geo)(geo = Intersection.getIntersectionGeo((double)d2, (double)d3, (double)d4, (double)d5, (double)this.e, (double)this.h, (double)this.k, (double)this.d))) <= 1.0E-15 || Geo.distance((Geo)geo2, (Geo)geo.antipode()) <= 1.0E-15)) {
            if (ga.a(geo4, this.f, geo2)) {
                point.setLocation(d2, d3);
                return 0.0;
            }
            double d6 = ga.a(d2, d3, this.e, this.h);
            double d7 = ga.a(d2, d3, this.k, this.d);
            if (Geo.angle((Geo)new Geo(d4, d5), (Geo)geo2, (Geo)geo4) != 0.0) {
                d6 = Math.PI * 2 - d6;
                d7 = Math.PI * 2 - d7;
            }
            if (d6 < d7) {
                point.setLocation(this.e, this.h);
                return ga.h(d6);
            }
            point.setLocation(this.k, this.d);
            return ga.h(d7);
        }
        if (!ga.a(geo4, this.f, geo3)) {
            return -1.0;
        }
        point.setLocation(geo3.getLatitude(), geo3.getLongitude());
        return Utilities.getDistanceGIS(d2, d3, geo3.getLatitude(), geo3.getLongitude());
    }

    @Override
    public void addTo(Path2D path2D) {
        path2D.lineTo(this.k, this.d);
    }

    @Override
    public void setStart(Point point) {
        this.setStart(point.x, point.y);
    }

    public double getDistanceSq(double d2, double d3) {
        return this.getNearestPoint(d2, d3, null);
    }

    @Override
    public double getDistanceSq(Point point) {
        return this.getNearestPoint(point.x, point.y, null);
    }

    @Override
    void a(double d2, Position position) {
        this.a(d2, (Point)position);
        position.verticalRotation = Double.NaN;
        if (this.a == 0.0) {
            position.rotation = Double.NaN;
            return;
        }
        if (position.getLatitude() == this.k && position.getLongitude() == this.d) {
            double d3;
            position.rotation = d3 + ((d3 = ga.a(ga.e(this.k, this.d, this.e, this.h))) > 0.0 ? Math.PI : -Math.PI);
            return;
        }
        position.setRotation(ga.a(ga.e(position.getLatitude(), position.getLongitude(), this.k, this.d)));
    }

    @Override
    void a(double d2, Point point) {
        this.i = this.l.offset(ga.e(d2) * this.j, this.c, this.i);
        if (ga.a(this.l, this.f, this.i)) {
            point.setLocation(this.i.getLatitude(), this.i.getLongitude());
            return;
        }
        this.n = ga.e(this.l, this.f, this.i);
        if (ga.a(this.l, this.f, this.n)) {
            point.setLocation(this.n.getLatitude(), this.n.getLongitude());
        } else {
            point.setLocation(this.k, this.d);
        }
    }

    @Override
    public Position getStart(Position position) {
        if (position == null) {
            position = new Position();
        }
        position.setPosition(this.e, this.h, 0.0, ga.a(this.c), 0.0);
        return position;
    }

    @Override
    public Position getEnd(Position position) {
        if (position == null) {
            position = new Position();
        }
        position.setPosition(this.k, this.d, 0.0, ga.a(this.c), 0.0);
        return position;
    }
}

