/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.LengthUnits;
import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.anylogic.engine.Presentable;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.markup.GISNode;
import com.anylogic.engine.markup.GISRoute;
import com.anylogic.engine.presentation.LineStyle;
import com.anylogic.engine.presentation.ShapeGISMap;
import com.anylogic.engine.presentation.UtilitiesColor;
import com.bbn.openmap.geo.OMGeo;
import com.bbn.openmap.omGraphics.OMGraphic;
import java.awt.Paint;
import java.util.Random;

public class GISPoint
extends GISNode {
    private static final long serialVersionUID = -4791814701058580652L;
    private double m;
    private double g;
    private String b;
    private double ai = 3.0;

    public GISPoint(ShapeGISMap shapeGISMap, boolean bl, double d2, double d3) {
        this(shapeGISMap, bl, d2, d3, 3.0, UtilitiesColor.defaultGisFillColor, UtilitiesColor.defaultGisLineColor, 1.0, Presentable.LINE_STYLE_SOLID, "");
    }

    public GISPoint(ShapeGISMap shapeGISMap, double d2, double d3) {
        this(shapeGISMap, true, d2, d3);
    }

    public GISPoint(ShapeGISMap shapeGISMap, boolean bl, double d2, double d3, double d4, Paint paint, Paint paint2, double d5, LineStyle lineStyle, String string) {
        super(shapeGISMap, bl, paint, paint2, d5, lineStyle, string);
        this.m = d2;
        this.g = d3;
        this.ai = d4;
        this.initialize();
    }

    public double getLatitude() {
        return this.m;
    }

    public double getLongitude() {
        return this.g;
    }

    public double getNearestPoint(double d2, double d3, Point point) {
        point.x = this.m;
        point.y = this.g;
        return Utilities.getDistanceGIS(this.m, this.g, d2, d3);
    }

    @Override
    public double getNearestPoint(Point point, Point point2) {
        double d2 = this.getNearestPoint(point.x, point.y, point2);
        return d2 * d2;
    }

    @Override
    public boolean contains(double d2, double d3) {
        return this.m == d2 && this.g == d3;
    }

    @Override
    @AnyLogicInternalAPI
    public OMGraphic createOMGraphicObject() {
        OMGeo.Pt pt = new OMGeo.Pt(this.m, this.g, true);
        pt.setFillPaint(this.n);
        pt.setRadius((int)this.ai);
        this.a((OMGraphic)pt);
        return pt;
    }

    public Point getLocation() {
        return this.getLocation(null);
    }

    public Point getLocation(Point point) {
        if (point == null) {
            point = new Point();
        }
        return point.setLatLon(this.m, this.g);
    }

    @Override
    public Position getPosition(int n2, int n3, Position position) {
        if (position == null) {
            position = new Position();
        }
        position.setLocation(this.m, this.g);
        position.verticalRotation = Double.NaN;
        position.rotation = Double.NaN;
        return position;
    }

    @Override
    double a(GISRoute gISRoute, GISRoute gISRoute2, Point point, Point point2) {
        return 0.0;
    }

    public void setRadius(double d2) {
        if (this.ai == d2) {
            return;
        }
        this.ai = d2;
        if (this.e) {
            ((OMGeo.Pt)this.l).setRadius((int)d2);
            if (this.l.isVisible()) {
                this.a.onMarkupChanged();
            }
        }
    }

    public double getRadius() {
        return this.ai;
    }

    @Override
    public Point randomPointInside(Random random, Point point) {
        return this.getLocation(point);
    }

    public double distance(double d2, double d3) {
        return Utilities.getDistanceGIS(this.m, this.g, d2, d3);
    }

    public double distance(double d2, double d3, LengthUnits lengthUnits) {
        return Utilities.getDistanceGIS(this.m, this.g, d2, d3, lengthUnits);
    }

    public double distance(GISPoint gISPoint) {
        return this.distance(gISPoint.getLatitude(), gISPoint.getLongitude());
    }

    public double distance(GISPoint gISPoint, LengthUnits lengthUnits) {
        return this.distance(gISPoint.getLatitude(), gISPoint.getLongitude(), lengthUnits);
    }

    public String toString() {
        if (this.b == null) {
            this.b = String.valueOf(this.getClass().getSimpleName()) + " " + "latitude: " + this.m + " longitude: " + this.g + (this.getTitle() != null ? " " + this.getTitle() : "");
        }
        return this.b;
    }
}

