/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.AnyLogicCustomProposalType;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.AreaUnits;
import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.ae;
import com.anylogic.engine.internal.ga;
import com.anylogic.engine.internal.presentation.SharedUtils;
import com.anylogic.engine.markup.GISNode;
import com.anylogic.engine.presentation.LineStyle;
import com.anylogic.engine.presentation.ShapeGISMap;
import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.GeoArray;
import com.bbn.openmap.geo.Intersection;
import com.bbn.openmap.geo.OMGeo;
import com.bbn.openmap.omGraphics.OMGraphic;
import java.awt.Paint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;

public class GISRegion
extends GISNode {
    private static final long serialVersionUID = -6480633512264496299L;
    private transient GeoArray m;
    private final double g;
    private double b = 90.0;
    private double ai = 180.0;
    private double hn = -90.0;
    private double lg = -180.0;
    private Position[] gf = null;
    private static final int di = 1000;

    public GISRegion(ShapeGISMap shapeGISMap, double[] dArray) {
        super(shapeGISMap, true);
        this.m = GeoArray.Double.createFromLatLonDegrees((double[])dArray);
        this.g = SharedUtils.getGISRegionArea(dArray);
        this.initialize();
    }

    public GISRegion(ShapeGISMap shapeGISMap, boolean bl, double[] dArray, double[] dArray2, Paint paint, Paint paint2, double d2, LineStyle lineStyle, String string, double d3) {
        super(shapeGISMap, bl, paint, paint2, d2, lineStyle, string);
        this.g = d3;
        if (dArray2 == null || dArray == null || dArray2.length == 0 || dArray2.length != dArray.length) {
            throw ga.a(shapeGISMap.getPresentable(), ae.fbb, new Object[]{"lat/lon", ae.ked});
        }
        Geo[] geoArray = new Geo[dArray2.length];
        int n2 = 0;
        while (n2 < geoArray.length) {
            geoArray[n2] = new Geo(dArray[n2], dArray2[n2]);
            ++n2;
        }
        this.m = new GeoArray.Double(geoArray);
        this.initialize();
    }

    public GISRegion(ShapeGISMap shapeGISMap, boolean bl, double[] dArray, Paint paint, Paint paint2, double d2, LineStyle lineStyle, String string, double d3) {
        super(shapeGISMap, bl, paint, paint2, d2, lineStyle, string);
        this.g = d3;
        if (dArray == null || dArray.length == 0) {
            throw ga.a(shapeGISMap.getPresentable(), ae.fbb, new Object[]{"lat/lon", ae.ked});
        }
        this.m = GeoArray.Double.createFromLatLonDegrees((double[])dArray);
        this.initialize();
    }

    @Override
    public void doInitialize() {
        super.doInitialize();
        int n2 = this.m.getSize();
        if (n2 < 3) {
            throw this.error("Error: node polygon should have at least 3 vertices");
        }
        Geo geo = new Geo();
        int n3 = 0;
        while (n3 < this.m.getSize()) {
            geo = this.m.get(n3, geo);
            this.b = Math.min(this.b, geo.getLatitude());
            this.hn = Math.max(this.hn, geo.getLatitude());
            this.ai = Math.min(this.ai, geo.getLongitude());
            this.lg = Math.max(this.lg, geo.getLongitude());
            ++n3;
        }
    }

    @Override
    public boolean contains(double d2, double d3) {
        return Intersection.isPointInPolygon((Geo)new Geo(d2, d3), (GeoArray)this.m);
    }

    public double getNearestPoint(double d2, double d3, Point point) {
        this.d();
        if (point == null) {
            point = new Point();
        }
        if (this.contains(d2, d3)) {
            point.setLocation(d2, d3);
            return 0.0;
        }
        int n2 = this.m.getSize();
        if (n2 < 2) {
            return -1.0;
        }
        double d4 = Double.POSITIVE_INFINITY;
        int n3 = 0;
        while (n3 < n2) {
            Geo geo = this.m.get(n3);
            Geo geo2 = this.m.get(n3 + 1 == n2 ? 0 : n3 + 1);
            Point point2 = ga.a(point, geo.getLatitude(), geo.getLongitude(), geo2.getLatitude(), geo2.getLongitude(), d2, d3);
            double d5 = ga.a(d2, d3, point2.x, point2.y);
            if (d4 > d5) {
                point.setLocation(point2);
                d4 = d5;
            }
            ++n3;
        }
        return ga.h(d4 * d4);
    }

    @Override
    public double getNearestPoint(Point point, Point point2) {
        double d2 = this.getNearestPoint(point.x, point.y, point2);
        return d2 * d2;
    }

    @Override
    @AnyLogicInternalAPI
    public OMGraphic createOMGraphicObject() {
        OMGeo.Polygon polygon = new OMGeo.Polygon(this.m);
        polygon.setFillPaint(this.n);
        this.a((OMGraphic)polygon);
        return polygon;
    }

    private Position[] a(int n2) {
        Position[] positionArray;
        if (n2 <= 0 || n2 > 1000) {
            n2 = 1000;
        }
        if ((positionArray = this.gf) == null || positionArray.length < n2) {
            positionArray = new Position[n2];
            int n3 = 0;
            while (n3 < positionArray.length) {
                Position position = new Position();
                this.randomPointInside(position);
                position.rotation = this.getSpace().uniform(Math.PI * 2);
                position.verticalRotation = Double.NaN;
                positionArray[n3] = position;
                ++n3;
            }
            this.gf = positionArray;
        }
        return positionArray;
    }

    Position a(int n2, int n3, Position position) {
        if (n2 >= n3) {
            n2 %= n3;
        }
        Position[] positionArray = this.a(n3);
        return positionArray[n2 % positionArray.length].clone(position);
    }

    @Override
    public Position getPosition(int n2, int n3, Position position) {
        return this.a(n2, n3, position);
    }

    @AnyLogicCustomProposalType(value=AnyLogicCustomProposalType.Label.SQ_METER)
    public double area() {
        return this.g;
    }

    public double area(AreaUnits areaUnits) {
        return AreaUnits.SQ_METER.convertTo(this.g, areaUnits);
    }

    @Override
    public Point randomPointInside(Random random, Point point) {
        this.d();
        Geo geo = new Geo();
        do {
            geo.initialize(Utilities.uniform(this.b, this.hn, random), Utilities.uniform(this.ai, this.lg, random));
        } while (!Intersection.isPointInPolygon((Geo)geo, (GeoArray)this.m));
        if (point == null) {
            point = new Point();
        }
        return point.setLatLon(geo.getLatitude(), geo.getLongitude());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        double[] dArray = this.m.toLLDegrees();
        objectOutputStream.writeObject(dArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m = GeoArray.Double.createFromLatLonDegrees((double[])((double[])objectInputStream.readObject()));
    }

    public double[] getPoints() {
        return this.m.toLLDegrees();
    }
}

