/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.AnyLogicCustomProposalType;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.LengthUnits;
import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.markup.AbstractMarkupSegment;
import com.anylogic.engine.markup.Curve;
import com.anylogic.engine.markup.GISCurve;
import com.anylogic.engine.markup.GISMarkupElement;
import com.anylogic.engine.markup.GISMarkupSegment;
import com.anylogic.engine.markup.GISMarkupSegmentLine;
import com.anylogic.engine.markup.GISNode;
import com.anylogic.engine.markup.GISPoint;
import com.anylogic.engine.markup.IPath;
import com.anylogic.engine.presentation.LineStyle;
import com.anylogic.engine.presentation.ShapeGISMap;
import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.OMGeo;
import com.bbn.openmap.omGraphics.OMGraphic;
import java.awt.Paint;
import java.util.Random;

public class GISRoute
extends GISMarkupElement
implements IPath<GISNode> {
    private static final long serialVersionUID = -764981448255870039L;
    private GISNode f;
    private GISNode i;
    private boolean n = true;
    private final GISCurve m = new GISCurve(){
        private static final long serialVersionUID = 5783980319575335873L;

        @Override
        void a() {
            GISRoute.this.d();
        }

        @Override
        void e() {
            GISRoute.this.j();
        }

        @Override
        RuntimeException a(String string) {
            return GISRoute.this.error(string);
        }

        @Override
        RuntimeException a(String string, Object ... objectArray) {
            return GISRoute.this.error(String.format(string, objectArray));
        }
    };

    public GISRoute(ShapeGISMap shapeGISMap, Curve curve) {
        this(shapeGISMap, curve, null, null, true);
    }

    public GISRoute(ShapeGISMap shapeGISMap, Curve curve, GISPoint gISPoint, GISPoint gISPoint2, boolean bl) {
        super(shapeGISMap, true);
        int n2 = 0;
        while (n2 < curve.getSegmentCount()) {
            Object t = curve.getSegment(n2);
            Position position = ((AbstractMarkupSegment)t).getStart(null);
            Position position2 = ((AbstractMarkupSegment)t).getEnd(null);
            this.m.addSegment(new GISMarkupSegmentLine(position.x, position.y, position2.x, position2.y));
            ++n2;
        }
        this.n = bl;
        this.setSource(gISPoint);
        this.setTarget(gISPoint2);
        this.initialize();
    }

    public GISRoute(ShapeGISMap shapeGISMap, GISMarkupSegment ... gISMarkupSegmentArray) {
        super(shapeGISMap, true);
        GISMarkupSegment[] gISMarkupSegmentArray2 = gISMarkupSegmentArray;
        int n2 = gISMarkupSegmentArray.length;
        int n3 = 0;
        while (n3 < n2) {
            GISMarkupSegment gISMarkupSegment = gISMarkupSegmentArray2[n3];
            this.m.addSegment(gISMarkupSegment);
            ++n3;
        }
        this.initialize();
    }

    public GISRoute(ShapeGISMap shapeGISMap, boolean bl, Paint paint, double d2, LineStyle lineStyle, boolean bl2, GISNode gISNode, GISNode gISNode2, GISMarkupSegment ... gISMarkupSegmentArray) {
        super(shapeGISMap, bl, paint, d2, lineStyle);
        this.n = bl2;
        GISMarkupSegment[] gISMarkupSegmentArray2 = gISMarkupSegmentArray;
        int n2 = gISMarkupSegmentArray.length;
        int n3 = 0;
        while (n3 < n2) {
            GISMarkupSegment gISMarkupSegment = gISMarkupSegmentArray2[n3];
            this.m.addSegment(gISMarkupSegment);
            ++n3;
        }
        this.setSource(gISNode);
        this.setTarget(gISNode2);
        this.initialize();
    }

    public double getNearestPoint(double d2, double d3, Point point) {
        return this.m.getNearestPoint(new Point(d2, d3), point);
    }

    @Override
    public double getNearestPoint(Point point, Point point2) {
        return this.getNearestPoint(point.x, point.y, point2);
    }

    @Override
    public boolean contains(double d2, double d3) {
        return this.containsSq(d2, d3, 1.0E-8);
    }

    public boolean containsSq(double d2, double d3, double d4) {
        return this.m.containsSq(d2, d3, d4);
    }

    public boolean contains(double d2, double d3, double d4) {
        return this.containsSq(d2, d3, Utilities.sqr(d4));
    }

    @Override
    public boolean isBidirectional() {
        return this.n;
    }

    @Override
    public void setSource(GISNode gISNode) {
        this.j();
        if (this.f == gISNode) {
            return;
        }
        if (this.f != null) {
            boolean bl = this.f.e(this);
        }
        this.f = gISNode;
        if (this.f != null) {
            if (this.f == this.i) {
                this.error("Error: source is the same as target for %s");
            }
            this.f.a(this);
        }
    }

    @Override
    public GISNode getSource() {
        return this.f;
    }

    @Override
    public void setTarget(GISNode gISNode) {
        this.j();
        if (this.i == gISNode) {
            return;
        }
        if (this.i != null) {
            boolean bl = this.i.e(this);
        }
        this.i = gISNode;
        if (this.i != null) {
            if (this.i == this.f) {
                this.error("Error: source is the same as target for %s");
            }
            this.i.a(this);
        }
    }

    @Override
    public GISNode getTarget() {
        return this.i;
    }

    @Override
    public void setBidirectional(boolean bl) {
        this.j();
        this.n = bl;
    }

    @Override
    public Point getStartPoint() {
        return this.getStartPoint(null);
    }

    @Override
    public Point getStartPoint(Point point) {
        return this.m.getStartPoint(point);
    }

    @Override
    public Point getEndPoint() {
        return this.getEndPoint(null);
    }

    @Override
    public Point getEndPoint(Point point) {
        return this.m.getEndPoint(point);
    }

    @Override
    public int getSegmentCount() {
        return this.m.getSegmentCount();
    }

    @Override
    public GISNode getOtherNode(GISNode gISNode) {
        return this.f == gISNode ? this.i : this.f;
    }

    @Override
    @AnyLogicCustomProposalType(value=AnyLogicCustomProposalType.Label.METER)
    public final double length() {
        return this.m.length();
    }

    @Override
    public final double length(LengthUnits lengthUnits) {
        this.d();
        return this.a.toLengthUnits(this.length(), lengthUnits);
    }

    @Override
    public GISMarkupSegment getSegment(int n2) {
        return (GISMarkupSegment)this.m.getSegment(n2);
    }

    @Override
    public Position getPositionAtOffset(double d2, Position position) {
        return this.m.getPositionAtOffset(d2, position);
    }

    @Override
    public Position getPositionAtOffset(double d2, LengthUnits lengthUnits, Position position) {
        this.d();
        double d3 = this.a.fromLengthUnits(d2, lengthUnits);
        return this.getPositionAtOffset(d3, position);
    }

    @Override
    public Position getStartPosition(Position position) {
        return this.m.a(position);
    }

    @Override
    public Position getEndPosition(Position position) {
        return this.m.e(position);
    }

    @Override
    @AnyLogicInternalAPI
    public OMGraphic createOMGraphicObject() {
        GISMarkupSegment gISMarkupSegment;
        int n2 = this.m.a.size();
        Geo[] geoArray = new Geo[n2 + 1];
        int n3 = 0;
        while (n3 < n2) {
            gISMarkupSegment = (GISMarkupSegment)this.m.getSegment(n3);
            Position position = gISMarkupSegment.getStart(null);
            geoArray[n3] = new Geo(position.x, position.y);
            ++n3;
        }
        Position position = this.getSegment(n2 - 1).getEnd(null);
        geoArray[n2] = new Geo(position.x, position.y);
        gISMarkupSegment = new OMGeo.Polyline(geoArray);
        this.a((OMGraphic)gISMarkupSegment);
        return gISMarkupSegment;
    }

    @Override
    public Position getPosition(double d2, double d3, Position position) {
        double d4 = d3 > 0.0 ? (!(d2 >= 0.0) ? 0.0 : (d2 > d3 ? d3 : d2)) * this.length() / d3 : 0.0;
        Position position2 = this.getPositionAtOffset(d4, position);
        return position2;
    }

    @Override
    public Position getPosition(int n2, int n3, Position position) {
        double d2 = n2 >= 0 && n3 > 1 && n2 < n3 ? (double)n2 * this.length() / (double)(n3 - 1) : 0.0;
        Position position2 = this.getPositionAtOffset(this.length() - d2, position);
        return position2;
    }

    @Override
    public final Point randomPointInside(Random random, Point point) {
        double d2 = Utilities.uniform(0.0, this.length(), random);
        if (point == null) {
            point = new Point();
        }
        this.m.a(d2, point);
        return point;
    }

    @Override
    void doInitialize() {
        super.doInitialize();
        this.m.initialize();
    }

    public void addSegment(GISMarkupSegment gISMarkupSegment) {
        this.m.addSegment(gISMarkupSegment);
    }
}

