/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.ga;
import com.anylogic.engine.markup.MarkupSegment;
import com.anylogic.engine.markup.d;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.List;

public final class MarkupSegmentArc
extends MarkupSegment {
    private static final long serialVersionUID = -8548181700911090455L;
    private double m;
    private double g;
    private double b;
    private double ai;
    private double hn;
    private double lg;
    private double gf;
    private double di;
    private double bj;
    private double aj;
    private double nj;
    private double dk;
    private double ec;
    private double mj;
    private double ic;
    private double mf;
    private double ib;
    private double hl;
    private double fb;
    protected double l;
    protected double f;
    protected double i;
    protected double n;
    private double bd;
    private double hf;
    private double am;
    private double km;
    private double ba;
    private double ld;

    public MarkupSegmentArc() {
    }

    public MarkupSegmentArc(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        super(d2, d3, d4, d5, d6, d7);
        this.m = d8;
        this.g = d9;
        this.b = d10;
        this.initialize();
    }

    public MarkupSegmentArc(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17, double d18, double d19, double d20) {
        super(d2, d3, d4, d5, d6, d7);
        this.m = d8;
        this.g = d9;
        this.b = d10;
        this.ai = d11;
        this.hn = d12;
        this.lg = d13;
        this.gf = d14;
        this.di = Math.abs(d15 %= Math.PI * 2);
        this.bj = Math.signum(d15);
        this.dk = d16;
        this.ec = d17;
        this.mj = d18;
        this.ic = d19;
        this.mf = Math.abs(d20 %= Math.PI * 2);
        this.ib = Math.signum(d20);
        this.h();
    }

    @Override
    public void initialize() {
        d.n[] nArray = com.anylogic.engine.markup.d.a(new Point(this.e, this.h), new Point(this.e + Math.cos(this.m - 1.5707963267948966) * this.b, this.h + Math.sin(this.m - 1.5707963267948966) * this.b), new Point(this.d, this.j), new Point(this.d + Math.cos(this.g - 1.5707963267948966), this.j + Math.sin(this.g - 1.5707963267948966)));
        if (nArray == null || nArray.length < 2) {
            throw ga.k("Error when building arcs. Please consider using line segment instead or change angles");
        }
        if (nArray[0].a()) {
            throw ga.k("NaN arc0: " + nArray[0]);
        }
        if (nArray[1].a()) {
            throw ga.k("NaN arc1: " + nArray[1]);
        }
        this.ai = nArray[0].a;
        this.hn = nArray[0].e;
        this.lg = nArray[0].h;
        this.gf = Math.toRadians(-nArray[0].k);
        this.di = Math.abs(Math.toRadians(-nArray[0].d));
        this.bj = Math.signum(-nArray[0].d);
        this.dk = nArray[1].a;
        this.ec = nArray[1].e;
        this.mj = nArray[1].h;
        this.ic = Math.toRadians(-nArray[1].k);
        this.mf = Math.abs(Math.toRadians(-nArray[1].d));
        this.ib = Math.signum(-nArray[1].d);
        this.h();
    }

    private void h() {
        this.n = this.lg * this.di;
        this.bd = this.n + this.mj * this.mf;
        if (!(this.bd > 0.0)) {
            System.out.println(String.valueOf(this.di) + ", " + this.mf);
            throw ga.k("Segment should have non-zero length in 2D (XY-plane)");
        }
        double d2 = this.gf + this.di / 2.0 * this.bj;
        this.aj = this.ai + Math.cos(d2) * this.lg;
        this.nj = this.hn + Math.sin(d2) * this.lg;
        d2 = this.ic + this.mf / 2.0 * this.ib;
        this.hl = this.dk + Math.cos(d2) * this.mj;
        this.fb = this.ec + Math.sin(d2) * this.mj;
        d2 = this.ic;
        this.l = this.dk + Math.cos(d2) * this.mj;
        this.f = this.ec + Math.sin(d2) * this.mj;
        double d3 = this.c - this.k;
        this.a = Utilities.getLength(this.bd, d3);
        double d4 = d3 / this.bd;
        this.km = d4 * this.lg;
        this.ba = d4 * this.mj;
        this.i = this.k + d4 * this.n;
        this.hf = this.bd / this.a;
        this.am = d3 / this.a;
        this.ld = -Math.asin(this.am);
    }

    public void setAngles(double d2, double d3, double d4) {
        this.e();
        this.m = d2;
        this.g = d3;
        this.b = d4;
    }

    public double getStartAngle() {
        return this.m;
    }

    public double getEndAngle() {
        return this.g;
    }

    public double getRatioStartToEnd() {
        return this.b;
    }

    @Override
    void a(double d2, Point point) {
        this.a();
        point.z = this.k + d2 * this.am;
        d2 *= this.hf;
        if (d2 <= this.n) {
            double d3 = this.gf + d2 / this.lg * this.bj;
            point.x = this.ai + Math.cos(d3) * this.lg;
            point.y = this.hn + Math.sin(d3) * this.lg;
        } else {
            double d4 = this.ic + (d2 - this.n) / this.mj * this.ib;
            point.x = this.dk + Math.cos(d4) * this.mj;
            point.y = this.ec + Math.sin(d4) * this.mj;
        }
    }

    @Override
    void a(double d2, Position position) {
        this.a();
        position.z = this.k + d2 * this.am;
        position.verticalRotation = this.ld;
        if ((d2 *= this.hf) <= this.n || this.mj == 0.0 && d2 <= this.n + 1.0E-4) {
            double d3 = this.gf + d2 / this.lg * this.bj;
            position.x = this.ai + Math.cos(d3) * this.lg;
            position.y = this.hn + Math.sin(d3) * this.lg;
            position.rotation = d3 + 1.5707963267948966 * this.bj;
        } else {
            double d4 = this.ic + (d2 - this.n) / this.mj * this.ib;
            position.x = this.dk + Math.cos(d4) * this.mj;
            position.y = this.ec + Math.sin(d4) * this.mj;
            position.rotation = d4 + 1.5707963267948966 * this.ib;
        }
    }

    @Override
    public Position getStart(Position position) {
        if (position == null) {
            position = new Position();
        }
        position.setPosition(this.e, this.h, this.k, this.gf + 1.5707963267948966 * this.bj, this.ld);
        return position;
    }

    @Override
    public Position getEnd(Position position) {
        if (position == null) {
            position = new Position();
        }
        position.setPosition(this.d, this.j, this.c, this.ic + (this.mf + 1.5707963267948966) * this.ib, this.ld);
        return position;
    }

    @Override
    public double getNearestPoint(double d2, double d3, Point point) {
        this.a();
        if (this.am != 0.0) {
            throw ga.a("This function is available for 2D segments only: ", new Object[]{this});
        }
        double d4 = this.a(this.ai, this.hn, this.e, this.h, this.l, this.f, this.aj, this.nj, this.lg, this.di, this.bj, d2, d3, point);
        Point point2 = new Point();
        double d5 = this.a(this.dk, this.ec, this.l, this.f, this.d, this.j, this.hl, this.fb, this.mj, this.mf, this.ib, d2, d3, point2);
        if (d5 < d4) {
            d4 = d5;
            point.setLocation(point2);
        }
        return d4;
    }

    @Override
    public double getNearestPoint(double d2, double d3, double d4, Point point) {
        this.a();
        double d5 = this.a(this.ai, this.hn, this.e, this.h, this.l, this.f, this.aj, this.nj, this.lg, this.di, this.bj, d2, d3, point);
        Point point2 = new Point();
        double d6 = this.a(this.dk, this.ec, this.l, this.f, this.d, this.j, this.hl, this.fb, this.mj, this.mf, this.ib, d2, d3, point2);
        if (d6 < d5) {
            d5 = d6;
            point.setLocation(point2);
            if (this.k == this.c) {
                point.z = this.k;
            } else if (point.x == this.d && point.y == this.j) {
                point.z = this.c;
            } else if (point.x == this.l && point.y == this.f) {
                point.z = this.i;
            } else {
                double d7 = Math.atan2(point.y - this.ec, point.x - this.dk);
                if (d7 < 0.0) {
                    d7 += Math.PI * 2;
                }
                point.z = this.i + this.ba * d7;
            }
        } else if (this.k == this.c) {
            point.z = this.k;
        } else if (point.x == this.e && point.y == this.h) {
            point.z = this.k;
        } else if (point.x == this.l && point.y == this.f) {
            point.z = this.i;
        } else {
            double d8 = Math.atan2(point.y - this.hn, point.x - this.ai);
            if (d8 < 0.0) {
                d8 += Math.PI * 2;
            }
            point.z = this.k + this.km * d8;
        }
        return d5 += Utilities.sqr(point.z - d4);
    }

    private double a(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, Point point) {
        double d15 = d13 - d2;
        double d16 = d14 - d3;
        if (d11 <= Math.PI ? (d15 * (d7 - d3) - (d6 - d2) * d16) * d12 > 0.0 && (d15 * (d5 - d3) - (d4 - d2) * d16) * d12 < 0.0 : !((d15 * (d7 - d3) - (d6 - d2) * d16) * d12 < 0.0) || !((d15 * (d5 - d3) - (d4 - d2) * d16) * d12 > 0.0)) {
            double d17 = Utilities.getLength(d15, d16);
            double d18 = d10 / d17;
            point.setLocation(d2 + d15 * d18, d3 + d16 * d18);
            return Utilities.sqr(d17 - d10);
        }
        if ((d15 * (d9 -= d3) - d16 * (d8 -= d2)) * d12 > 0.0) {
            point.setLocation(d4, d5);
            return Utilities.getDistanceSq(d13, d14, d4, d5);
        }
        point.setLocation(d6, d7);
        return Utilities.getDistanceSq(d13, d14, d6, d7);
    }

    @Override
    public double getDistanceSq(double d2, double d3) {
        return this.getNearestPoint(d2, d3, new Point());
    }

    @Override
    public double getDistanceSq(double d2, double d3, double d4) {
        return this.getNearestPoint(d2, d3, d4, new Point());
    }

    @Override
    public void addTo(Path2D path2D) {
        Arc2D.Double double_ = new Arc2D.Double();
        double d2 = this.lg + this.lg;
        double_.setArc(this.ai - this.lg, this.hn - this.lg, d2, d2, Math.toDegrees(-this.gf), Math.toDegrees(-this.di * this.bj), 0);
        path2D.append(double_, true);
        if (this.mj != 0.0) {
            d2 = this.mj + this.mj;
            double_.setArc(this.dk - this.mj, this.ec - this.mj, d2, d2, Math.toDegrees(-this.ic), Math.toDegrees(-this.mf * this.ib), 0);
            path2D.append(double_, true);
        }
    }

    public String toString() {
        return "(" + this.e + ", " + this.h + ", " + this.k + ")-arc-(" + this.d + ", " + this.j + ", " + this.c + ")";
    }

    @Override
    public double getOffsetOfPoint(double d2, double d3) {
        Point point = new Point();
        double d4 = this.a(this.ai, this.hn, this.e, this.h, this.l, this.f, this.aj, this.nj, this.lg, this.di, this.bj, d2, d3, point);
        Point point2 = new Point();
        double d5 = this.a(this.dk, this.ec, this.l, this.f, this.d, this.j, this.hl, this.fb, this.mj, this.mf, this.ib, d2, d3, point2);
        if (d5 < d4) {
            double d6 = this.a(point2.x, point2.y, this.dk, this.ec, this.ic, this.mf, this.ib);
            return (d6 * this.mj + this.n) / this.hf;
        }
        double d7 = this.a(point.x, point.y, this.ai, this.hn, this.gf, this.di, this.bj);
        return d7 * this.lg / this.hf;
    }

    private double a(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9;
        double d10;
        double d11 = Math.atan2(d3 - d5, d2 - d4);
        if (d11 < 0.0) {
            d11 += Math.PI * 2;
        }
        if ((d10 = d6) < 0.0) {
            d10 += Math.PI * 2;
        }
        if (Math.abs(d11 - d10) < 1.0E-4) {
            d11 = d10;
        }
        if (d8 > 0.0) {
            if (d11 < d10) {
                d11 += Math.PI * 2;
            }
            d9 = d11 - d10;
        } else {
            if (d11 > d10) {
                d10 += Math.PI * 2;
            }
            d9 = d10 - d11;
        }
        if (d9 < 1.0E-4) {
            d9 = d7;
        }
        return d9;
    }

    @Override
    public double getNearestPointOnRay2D(double d2, double d3, double d4, double d5, Point point) {
        Point point2 = this.getArgNearestPointOnRay2D(d2, d3, d4, d5, this.ai, this.hn, this.e, this.h, this.l, this.f, this.lg, this.di, this.bj, point);
        Point point3 = this.getArgNearestPointOnRay2D(d2, d3, d4, d5, this.dk, this.ec, this.l, this.f, this.d, this.j, this.mj, this.mf, this.ib, point);
        if (point2 != null && point3 != null) {
            double d6;
            double d7 = Utilities.getDistanceSq(d2, d3, point2.x, point2.y);
            if (d7 <= (d6 = Utilities.getDistanceSq(d2, d3, point3.x, point3.y))) {
                point.setLocation(point2);
                return Math.sqrt(d7);
            }
            point.setLocation(point3);
            return Math.sqrt(d6);
        }
        if (point2 != null) {
            point.setLocation(point2);
            return Utilities.getDistance(d2, d3, point2.x, point2.y);
        }
        if (point3 != null) {
            point.setLocation(point3);
            return Utilities.getDistance(d2, d3, point3.x, point3.y);
        }
        return -1.0;
    }

    public Point getArgNearestPointOnRay2D(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, Point point) {
        double d15;
        double d16;
        double d17 = d4 - d2;
        double d18 = d5 - d3;
        double d19 = Math.sqrt(d17 * d17 + d18 * d18);
        double d20 = d17 / d19;
        double d21 = d20 * (d6 - d2) + (d16 = d18 / d19) * (d7 - d3);
        double d22 = d21 * d20 + d2;
        double d23 = Math.sqrt((d22 - d6) * (d22 - d6) + ((d15 = d21 * d16 + d3) - d7) * (d15 - d7));
        if (d23 == d12) {
            if (point == null) {
                point = new Point();
            }
            double d24 = d21 * d20 + d2;
            double d25 = d21 * d16 + d3;
            double d26 = d24 - d2;
            double d27 = d25 - d3;
            if (Math.signum(d26) - Math.signum(d17) != 0.0 && Math.signum(d27) - Math.signum(d18) != 0.0) {
                point.setLocation(d24, d25);
                return point;
            }
        } else if (d23 < d12) {
            boolean bl;
            if (point == null) {
                point = new Point();
            }
            double d28 = Math.sqrt(d12 * d12 - d23 * d23);
            double d29 = (d21 - d28) * d20 + d2;
            double d30 = (d21 - d28) * d16 + d3;
            double d31 = (d21 + d28) * d20 + d2;
            double d32 = (d21 + d28) * d16 + d3;
            double d33 = d29 - d2;
            double d34 = d30 - d3;
            boolean bl2 = Math.signum(d33) + Math.signum(d17) != 0.0 && Math.signum(d34) + Math.signum(d18) != 0.0;
            boolean bl3 = bl = Math.signum(d33) + Math.signum(d17) != 0.0 && Math.signum(d34) + Math.signum(d18) != 0.0;
            if (!bl2 && !bl) {
                return null;
            }
            if (bl2) {
                bl2 = this.a(d6, d7, d8, d9, d10, d11, d13, d14, d29, d30, point);
            }
            if (bl) {
                bl = this.a(d6, d7, d8, d9, d10, d11, d13, d14, d31, d32, point);
            }
            if (bl2 && bl) {
                double d35;
                double d36 = Utilities.getDistanceSq(d2, d3, d29, d30);
                if (d36 <= (d35 = Utilities.getDistanceSq(d2, d3, d31, d32))) {
                    point.setLocation(d29, d30);
                    return point;
                }
                point.setLocation(d31, d32);
                return point;
            }
            if (bl2) {
                point.setLocation(d29, d30);
                return point;
            }
            if (bl) {
                point.setLocation(d31, d32);
                return point;
            }
        }
        return null;
    }

    private boolean a(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, Point point) {
        double d12 = d10 - d2;
        double d13 = d11 - d3;
        if (d8 <= Math.PI) {
            return (d12 * (d7 - d3) - (d6 - d2) * d13) * d9 > 0.0 && (d12 * (d5 - d3) - (d4 - d2) * d13) * d9 < 0.0;
        }
        return !((d12 * (d7 - d3) - (d6 - d2) * d13) * d9 < 0.0) || !((d12 * (d5 - d3) - (d4 - d2) * d13) * d9 > 0.0);
    }

    @AnyLogicInternalAPI
    public double getStartArcCenterX() {
        return this.ai;
    }

    @AnyLogicInternalAPI
    public double getStartArcCenterY() {
        return this.hn;
    }

    @AnyLogicInternalAPI
    public double getStartArcRadius() {
        return this.lg;
    }

    @AnyLogicInternalAPI
    public double getStartArcStartAngle() {
        return this.gf;
    }

    @AnyLogicInternalAPI
    public double getStartArcAngle() {
        return this.di;
    }

    @AnyLogicInternalAPI
    public double getStartArcSign() {
        return this.bj;
    }

    @AnyLogicInternalAPI
    public double getEndArcCenterX() {
        return this.dk;
    }

    @AnyLogicInternalAPI
    public double getEndArcCenterY() {
        return this.ec;
    }

    @AnyLogicInternalAPI
    public double getEndArcRadius() {
        return this.mj;
    }

    @AnyLogicInternalAPI
    public double getEndArcStartAngle() {
        return this.ic;
    }

    @AnyLogicInternalAPI
    public double getEndArcAngle() {
        return this.mf;
    }

    @AnyLogicInternalAPI
    public double getEndArcSign() {
        return this.ib;
    }

    @AnyLogicInternalAPI
    public double getJoinX() {
        return this.l;
    }

    @AnyLogicInternalAPI
    public double getJoinY() {
        return this.f;
    }

    @AnyLogicInternalAPI
    public double getJoinZ() {
        return this.i;
    }

    @Override
    public List<Shape> convertToShapes() {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        Arc2D.Double double_ = new Arc2D.Double();
        double d2 = this.lg + this.lg;
        double_.setArc(this.ai - this.lg, this.hn - this.lg, d2, d2, Math.toDegrees(-this.gf), Math.toDegrees(-this.di * this.bj), 0);
        arrayList.add(double_);
        if (this.mj != 0.0) {
            double_ = new Arc2D.Double();
            d2 = this.mj + this.mj;
            double_.setArc(this.dk - this.mj, this.ec - this.mj, d2, d2, Math.toDegrees(-this.ic), Math.toDegrees(-this.mf * this.ib), 0);
            arrayList.add(double_);
        }
        return arrayList;
    }
}

