/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.ga;
import com.anylogic.engine.markup.MarkupSegment;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.List;

public final class MarkupSegmentLine
extends MarkupSegment {
    private static final long serialVersionUID = -8638921250218870731L;
    private double l;
    private double f;
    private double i;
    private double n;
    private double m;

    public MarkupSegmentLine(double d2, double d3, double d4, double d5, double d6, double d7) {
        super(d2, d3, d4, d5, d6, d7);
        this.initialize();
    }

    public MarkupSegmentLine() {
    }

    @Override
    void a(double d2, Point point) {
        point.x = this.e + this.l * d2;
        point.y = this.h + this.f * d2;
        point.z = this.k + this.i * d2;
    }

    @Override
    void a(double d2, Position position) {
        this.a(d2, (Point)position);
        position.rotation = this.n;
        position.verticalRotation = this.m;
    }

    @Override
    public Position getStart(Position position) {
        if (position == null) {
            position = new Position();
        }
        position.setPosition(this.e, this.h, this.k, this.n, this.m);
        return position;
    }

    @Override
    public Position getEnd(Position position) {
        if (position == null) {
            position = new Position();
        }
        position.setPosition(this.d, this.j, this.c, this.n, this.m);
        return position;
    }

    @Override
    public final void initialize() {
        this.l = this.d - this.e;
        this.f = this.j - this.h;
        this.i = this.c - this.k;
        this.a = Utilities.getLength(this.l, this.f, this.i);
        if (!(this.a > 0.0)) {
            throw ga.k("Segment should have non-zero length: " + this.toString());
        }
        this.l /= this.a;
        this.f /= this.a;
        this.i /= this.a;
        this.n = Math.atan2(this.f, this.l);
        this.m = -Math.asin(this.i);
    }

    @Override
    public double getNearestPoint(double d2, double d3, Point point) {
        this.a();
        if (this.i != 0.0) {
            throw ga.a("This function is available for 2D segments only: ", new Object[]{this});
        }
        double d4 = (d2 - this.e) * this.l + (d3 - this.h) * this.f;
        if (d4 <= 0.0) {
            point.x = this.e;
            point.y = this.h;
        } else if (d4 >= this.a) {
            point.x = this.d;
            point.y = this.j;
        } else {
            point.x = this.e + this.l * d4;
            point.y = this.h + this.f * d4;
        }
        return Utilities.getDistanceSq(d2, d3, point.x, point.y);
    }

    @Override
    public double getDistanceSq(double d2, double d3) {
        this.a();
        if (this.i != 0.0) {
            throw ga.a("This function is available for horizontal segments only: ", new Object[]{this});
        }
        double d4 = d2 - this.e;
        double d5 = d3 - this.h;
        double d6 = d4 * this.l + d5 * this.f;
        double d7 = d6 <= 0.0 ? 0.0 : ((d6 = (d4 = this.d - d2) * this.l + (d5 = this.j - d3) * this.f) <= 0.0 ? 0.0 : d6 * d6);
        double d8 = Utilities.getLengthSq(d4, d5) - d7;
        if (d8 < 0.0) {
            d8 = 0.0;
        }
        return d8;
    }

    @Override
    public double getNearestPoint(double d2, double d3, double d4, Point point) {
        this.a();
        double d5 = (d2 - this.e) * this.l + (d3 - this.h) * this.f + (d4 - this.k) * this.i;
        if (d5 <= 0.0) {
            point.x = this.e;
            point.y = this.h;
            point.z = this.k;
        } else if (d5 >= this.a) {
            point.x = this.d;
            point.y = this.j;
            point.z = this.c;
        } else {
            point.x = this.e + this.l * d5;
            point.y = this.h + this.f * d5;
            point.z = this.k + this.i * d5;
        }
        return Utilities.getDistanceSq(d2, d3, d4, point.x, point.y, point.z);
    }

    @Override
    public double getDistanceSq(double d2, double d3, double d4) {
        this.a();
        d3 -= this.h;
        double d5 = (d2 -= this.e) * this.l + (d3 -= this.k) * this.f + d4 * this.i;
        double d6 = Utilities.sqr(d5);
        double d7 = Utilities.getLengthSq(d2, d3, d4) - d6;
        if (d7 < 0.0) {
            d7 = 0.0;
        }
        return d7;
    }

    @Override
    public double getNearestPointOnRay2D(double d2, double d3, double d4, double d5, Point point) {
        if (!Utilities.isRayIntersectingSegment(d2, d3, d4, d5, this.e, this.h, this.d, this.j)) {
            return -1.0;
        }
        double d6 = this.f / this.l;
        double d7 = (d5 - d3) / (d4 - d2);
        if (d6 == Double.POSITIVE_INFINITY) {
            d6 = 1.0E25;
        }
        if (d6 == Double.NEGATIVE_INFINITY) {
            d6 = -1.0E25;
        }
        if (d7 == Double.POSITIVE_INFINITY) {
            d7 = 1.0E25;
        }
        if (d7 == Double.NEGATIVE_INFINITY) {
            d7 = -1.0E25;
        }
        double d8 = this.h - d6 * this.e;
        double d9 = d3 - d7 * d2;
        if (d6 == d7) {
            double d10;
            double d11 = this.d - this.e;
            double d12 = this.j - this.h;
            double d13 = (d2 - this.e) * d11 + (d3 - this.h) * d12;
            if (d13 >= 0.0 && d13 <= Utilities.getLengthSq(d11, d12)) {
                point.setLocation(d2, d3);
                return 0.0;
            }
            double d14 = Utilities.getDistanceSq(d2, d3, this.e, this.h);
            if (d14 <= (d10 = Utilities.getDistanceSq(d2, d3, this.d, this.j))) {
                point.setLocation(this.e, this.h);
                return d14;
            }
            point.setLocation(this.d, this.j);
            return d10;
        }
        point.x = (d9 - d8) / (d6 - d7);
        point.y = Math.abs(this.d - this.e) > Math.abs(d4 - d2) ? d6 * point.x + d8 : d7 * point.x + d9;
        return Utilities.getDistanceSq(d2, d3, point.x, point.y);
    }

    @Override
    public double getOffsetOfPoint(double d2, double d3) {
        if (this.l != 0.0) {
            return Utilities.limit(0.0, (d2 - this.e) / this.l, this.a);
        }
        if (this.f != 0.0) {
            return Utilities.limit(0.0, (d3 - this.h) / this.f, this.a);
        }
        return 0.0;
    }

    @Override
    public void addTo(Path2D path2D) {
        path2D.lineTo(this.d, this.j);
    }

    public String toString() {
        return "(" + this.e + ", " + this.h + ", " + this.k + ")-line-(" + this.d + ", " + this.j + ", " + this.c + ")";
    }

    @Override
    public List<Shape> convertToShapes() {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        arrayList.add(new Line2D.Double(this.e, this.h, this.d, this.j));
        return arrayList;
    }
}

