/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.LengthUnits;
import com.anylogic.engine.Point;
import com.anylogic.engine.internal.ae;
import com.anylogic.engine.internal.presentation.e;
import com.anylogic.engine.markup.AbstractRoadSidePart;
import com.anylogic.engine.markup.MarkupSegment;
import com.anylogic.engine.markup.MarkupSegmentLine;
import com.anylogic.engine.markup.ParkingLotDataSource;
import com.anylogic.engine.markup.PathDrawingType;
import com.anylogic.engine.markup.Road;
import com.anylogic.engine.markup.RoadConstants;
import com.anylogic.engine.markup.l;
import com.anylogic.engine.presentation.Panel;
import com.anylogic.engine.presentation.ShapeDrawMode;
import com.anylogic.engine.presentation.ShapePolyLine;
import com.anylogic.engine.presentation.UtilitiesColor;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ParkingLot
extends AbstractRoadSidePart {
    private static final long serialVersionUID = -5501833494893390820L;
    private Type l = Type.PARALLEL;
    private int f = 5;
    private double i = 5.0;
    private double n = 2.5;
    @Deprecated
    private List<List<MarkupSegment>> m = new ArrayList<List<MarkupSegment>>();
    @AnyLogicCustomSerialization
    private transient ParkingLotDataSource ai;
    private List<MarkupSegment> hn;
    private Path2D gd;
    @Deprecated
    public List<ShapePolyLine> guidelineShapePolylines = new ArrayList<ShapePolyLine>();
    @Deprecated
    public List<ShapePolyLine> parkingLotBordersShapePolylines = new ArrayList<ShapePolyLine>();

    private void n() {
        if (!(this.n > 0.0)) {
            this.a(ae.fbb, "parkingSpaceWidthInMeters", this.n);
        }
        if (!(this.i > 0.0)) {
            this.a(ae.fbb, "parkingSpaceLengthInMeters", this.i);
        }
        if (this.f <= 0) {
            this.a(ae.fbb, "nSpaces", this.f);
        }
        if (this.l == null) {
            this.a(ae.ind, "parkingType");
        }
    }

    public ParkingLot() {
    }

    public ParkingLot(Road road, ShapeDrawMode shapeDrawMode, boolean bl, boolean bl2, double d2, Type type, int n2, double d3, double d4) {
        super(road, shapeDrawMode, bl, bl2, d2);
        this.l = type;
        this.f = n2;
        this.n = d3;
        this.i = d4;
        this.initialize();
    }

    @AnyLogicInternalAPI
    public void setDataSource(ParkingLotDataSource parkingLotDataSource) {
        if (parkingLotDataSource == null) {
            this.a(ae.ind, "dataSource");
        }
        if (parkingLotDataSource == this.ai) {
            return;
        }
        if (this.ai != null) {
            this.a(ae.ldh, parkingLotDataSource);
        }
        this.ai = parkingLotDataSource;
    }

    public int nFree() {
        return this.ai == null ? this.nSpaces() : this.ai.nFree();
    }

    public int randomFreeSpaceIndex() {
        return this.ai == null ? this.bj.uniform_discr(this.nSpaces() - 1) : this.ai.randomFreeSpaceIndex();
    }

    public Agent getCarOnSpace(int n2) {
        return this.ai == null ? null : this.ai.getCarOnSpace(n2);
    }

    public int nCars() {
        return this.ai == null ? 0 : this.ai.nCars();
    }

    public List<Agent> getCars() {
        return this.ai == null ? Collections.emptyList() : this.ai.getCars();
    }

    public int[] getFreeSpaceIndexes() {
        if (this.ai == null) {
            int[] nArray = new int[this.nSpaces()];
            int n2 = 0;
            while (n2 < nArray.length) {
                nArray[n2] = n2;
                ++n2;
            }
            return nArray;
        }
        return this.ai.getFreeSpaceIndexes();
    }

    @Override
    void i() {
        super.i();
        this.n();
    }

    @Override
    protected void c() {
        Object object;
        double d2;
        double d3;
        super.c();
        switch (this.l) {
            case PARALLEL: {
                d3 = this.n;
                d2 = this.i;
                break;
            }
            case PERPENDICULAR: {
                d3 = this.i;
                d2 = this.n;
                break;
            }
            default: {
                throw this.a(ae.fbb, new Object[]{"parkingType", this.l});
            }
        }
        d3 = this.bj.toPixels(d3, LengthUnits.METER);
        d2 = this.bj.toPixels(d2, LengthUnits.METER);
        double d4 = this.b.getDrivingDirection() == RoadConstants.DrivingDirection.RIGHT_HAND ? 1 : -1;
        double d5 = 0.0;
        List<MarkupSegment> list2 = this.e();
        for (MarkupSegment list3 : list2) {
            d5 += list3.length();
        }
        List<MarkupSegment> list = com.anylogic.engine.markup.l.a(list2, this.e, d5);
        List<MarkupSegment> list4 = com.anylogic.engine.markup.l.h(list, d4 * this.b.getLaneWidthInPixels() / 2.0);
        double d6 = 0.0;
        Object object2 = list4.iterator();
        while (object2.hasNext()) {
            object = (MarkupSegment)object2.next();
            d6 += ((MarkupSegment)object).length();
        }
        object = com.anylogic.engine.markup.l.a(list4, 0.0, d6);
        object2 = com.anylogic.engine.markup.l.h((List<MarkupSegment>)object, d4 * d3);
        double d7 = 0.0;
        double d8 = 0.0;
        int n2 = 0;
        while (n2 < this.f) {
            ArrayList<MarkupSegment> arrayList = new ArrayList<MarkupSegment>();
            List<MarkupSegment> list3 = com.anylogic.engine.markup.l.a((List<MarkupSegment>)object, d7, d7 + d2);
            List<MarkupSegment> list5 = com.anylogic.engine.markup.l.e(com.anylogic.engine.markup.l.a((List<MarkupSegment>)object2, d8, d8 + d2));
            MarkupSegmentLine markupSegmentLine = com.anylogic.engine.markup.l.a(list3.get(list3.size() - 1).getEnd(new Point()), list5.get(0).getStart(new Point()));
            MarkupSegmentLine markupSegmentLine2 = com.anylogic.engine.markup.l.a(list5.get(list5.size() - 1).getEnd(new Point()), list3.get(0).getStart(new Point()));
            arrayList.addAll(list3);
            arrayList.add(markupSegmentLine);
            arrayList.addAll(list5);
            arrayList.add(markupSegmentLine2);
            this.m.add(arrayList);
            ++n2;
        }
        double d9 = this.c ? 1 : -1;
        int n3 = this.c ? this.a.getForwardLanesCount() : this.a.getBackwardLanesCount();
        double d10 = d4 * d9 * this.b.getLaneWidthInPixels();
        double d11 = d10 * (double)n3 + d4 * d9 * d3 / 2.0;
        double d12 = d10 * ((double)n3 - 0.5);
        double d13 = (double)this.f * d2;
        double d14 = this.c ? this.e : this.e - d13;
        double d15 = d14 + d13;
        List<MarkupSegment> list7 = com.anylogic.engine.markup.l.h(this.a.getAxisMarkupSegments(), d12);
        list7 = com.anylogic.engine.markup.l.a(list7, d14, d15);
        this.hn = com.anylogic.engine.markup.l.h(this.a.getAxisMarkupSegments(), d11);
        this.hn = com.anylogic.engine.markup.l.a(this.hn, d14, d15);
    }

    public Type getParkingType() {
        return this.l;
    }

    public void setParkingType(Type type) {
        this.j();
        this.l = type;
    }

    public int nSpaces() {
        return this.f;
    }

    public void setNSpaces(int n2) {
        this.j();
        this.f = n2;
    }

    public double getParkingSpaceLengthInPixels() {
        return this.bj.toPixels(this.i, LengthUnits.METER);
    }

    public double getParkingSpaceLength() {
        return this.i;
    }

    public double getParkingSpaceLength(LengthUnits lengthUnits) {
        return LengthUnits.METER.convertTo(this.getParkingSpaceLength(), lengthUnits);
    }

    public void setParkingSpaceLength(double d2) {
        this.j();
        this.i = d2;
    }

    public void setParkingSpaceLength(double d2, LengthUnits lengthUnits) {
        this.setParkingSpaceLength(lengthUnits.convertTo(d2, LengthUnits.METER));
    }

    public double getParkingSpaceWidthInPixels() {
        return this.bj.toPixels(this.n, LengthUnits.METER);
    }

    public double getParkingSpaceWidth() {
        return this.n;
    }

    public double getParkingSpaceWidth(LengthUnits lengthUnits) {
        return LengthUnits.METER.convertTo(this.getParkingSpaceWidth(), lengthUnits);
    }

    public void setParkingSpaceWidth(double d2) {
        this.j();
        this.n = d2;
    }

    public void setParkingSpaceWidth(double d2, LengthUnits lengthUnits) {
        this.setParkingSpaceWidth(lengthUnits.convertTo(d2, LengthUnits.METER));
    }

    @Override
    public void draw(Panel panel, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl) {
        double d2;
        double d3;
        if (this.gd == null) {
            this.gd = com.anylogic.engine.internal.presentation.e.a(this.hn);
        }
        switch (this.l) {
            case PARALLEL: {
                d3 = this.n;
                d2 = this.i;
                break;
            }
            case PERPENDICULAR: {
                d3 = this.i;
                d2 = this.n;
                break;
            }
            default: {
                throw this.a(ae.fbb, new Object[]{"parkingType", this.l});
            }
        }
        d3 = this.bj.toPixels(d3, LengthUnits.METER);
        d2 = this.bj.toPixels(d2, LengthUnits.METER);
        com.anylogic.engine.internal.presentation.e.a(graphics2D, this.gd, PathDrawingType.PATH_LINE, (float)d2, (Paint)this.b.getRoadBackgroundColor());
    }

    @Deprecated
    public void createTemporaryVisualization() {
        this.parkingLotBordersShapePolylines.clear();
        this.guidelineShapePolylines.clear();
        for (List<MarkupSegment> list : this.m) {
            this.parkingLotBordersShapePolylines.add(com.anylogic.engine.markup.l.a(list, 0.5, (Paint)UtilitiesColor.white, (Paint)this.b.getRoadBackgroundColor()));
        }
    }

    @Deprecated
    private void a(Panel panel, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl) {
        this.createTemporaryVisualization();
        if (this.g) {
            for (ShapePolyLine shapePolyLine : this.parkingLotBordersShapePolylines) {
                shapePolyLine.draw(panel, graphics2D, affineTransform, true);
            }
            for (ShapePolyLine shapePolyLine : this.guidelineShapePolylines) {
                shapePolyLine.draw(panel, graphics2D, affineTransform, true);
            }
        }
    }

    public static enum Type {
        PARALLEL,
        PERPENDICULAR;

    }
}

