/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.ae;
import com.anylogic.engine.internal.presentation.e;
import com.anylogic.engine.internal.t.f;
import com.anylogic.engine.internal.t.fk;
import com.anylogic.engine.internal.t.jd;
import com.anylogic.engine.markup.AreaNode;
import com.anylogic.engine.markup.Attractor;
import com.anylogic.engine.markup.PositionChoiceMode;
import com.anylogic.engine.markup.Slope;
import com.anylogic.engine.presentation.LineStyle;
import com.anylogic.engine.presentation.Panel;
import com.anylogic.engine.presentation.ShapeDrawMode;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.util.Random;

public class PolygonalNode
extends AreaNode {
    private static final long serialVersionUID = -2294940773211731233L;
    protected double[] nm;
    protected double[] ch;
    private double in;
    private double da;
    private double jn;
    private double kn;
    private Path2D.Double fn;
    private double hm;
    private Position[] fi = null;
    private static final int md = 1000;
    private static final int li = 46337;
    private static final int nd = 46327;

    public PolygonalNode() {
    }

    public PolygonalNode(Agent agent, ShapeDrawMode shapeDrawMode, boolean bl, double d2, double d3, double d4, double[] dArray, double[] dArray2, Slope slope, Paint paint, Paint paint2, double d5, LineStyle lineStyle, PositionChoiceMode positionChoiceMode, Attractor ... attractorArray) {
        super(agent, shapeDrawMode, bl, d2, d3, d4, slope, paint, paint2, d5, lineStyle, positionChoiceMode, attractorArray);
        if (dArray == null || dArray2 == null || dArray.length == 0 || dArray.length != dArray2.length) {
            throw this.a(ae.fbb, "dx/dy/dz", ae.ked);
        }
        this.nm = dArray;
        this.ch = dArray2;
        this.initialize();
    }

    public PolygonalNode(Agent agent, ShapeDrawMode shapeDrawMode, boolean bl, double d2, double d3, double d4, double[] dArray, double[] dArray2, Paint paint, Paint paint2, double d5, LineStyle lineStyle, PositionChoiceMode positionChoiceMode, Attractor ... attractorArray) {
        super(agent, shapeDrawMode, bl, d2, d3, d4, null, paint, paint2, d5, lineStyle, positionChoiceMode, attractorArray);
        if (dArray == null || dArray2 == null || dArray.length == 0 || dArray.length != dArray2.length) {
            throw this.a(ae.fbb, "dx/dy/dz", ae.ked);
        }
        this.nm = dArray;
        this.ch = dArray2;
        this.initialize();
    }

    public void addVertex(double d2, double d3) {
        int n2;
        int n3;
        this.j();
        if (this.nm == null) {
            this.nm = new double[11];
            this.nm[0] = 0.0;
        }
        if ((n3 = (n2 = (int)(this.nm[0] = this.nm[0] + 1.0)) * 2 + 1) > this.nm.length) {
            double[] dArray = this.nm;
            this.nm = new double[n2 * 4 + 1];
            System.arraycopy(dArray, 0, this.nm, 0, (n2 - 1) * 2 + 1);
        }
        n3 -= 2;
        this.nm[n3++] = d2;
        this.nm[n3++] = d3;
    }

    @Override
    void i() {
        int n2;
        super.i();
        if (this.ch == null) {
            if (this.nm == null || this.nm[0] < 3.0) {
                throw this.error("Error: node polygon should have at least 3 vertices");
            }
            n2 = (int)this.nm[0];
            double[] dArray = this.nm;
            this.nm = new double[n2];
            this.ch = new double[n2];
            int n3 = 1;
            int n4 = 0;
            while (n4 < n2) {
                this.nm[n4] = dArray[n3++];
                this.ch[n4] = dArray[n3++];
                ++n4;
            }
        }
        if ((n2 = this.nm.length) < 3) {
            throw this.error("Error: node polygon should have at least 3 vertices");
        }
        if (PolygonalNode.a(this.nm, this.ch, n2)) {
            throw this.error("Error: node polygon is self-intersecting: its outline intersects itself");
        }
        this.fn = new Path2D.Double(0, n2);
        this.in = this.jn = this.nm[0];
        this.da = this.kn = this.ch[0];
        this.fn.moveTo(this.nm[0], this.ch[0]);
        this.hm = this.nm[n2 - 1] * this.ch[0] - this.nm[0] * this.ch[n2 - 1];
        int n5 = 1;
        while (n5 < n2) {
            double d2 = this.nm[n5];
            double d3 = this.ch[n5];
            this.fn.lineTo(d2, d3);
            if (d2 < this.in) {
                this.in = d2;
            }
            if (d2 > this.jn) {
                this.jn = d2;
            }
            if (d3 < this.da) {
                this.da = d3;
            }
            if (d3 > this.kn) {
                this.kn = d3;
            }
            this.hm += this.nm[n5 - 1] * this.ch[n5] - this.nm[n5] * this.ch[n5 - 1];
            ++n5;
        }
        if (this.hm < 0.0) {
            this.hm = -this.hm;
        }
        if (!(this.hm > 0.0)) {
            throw this.error("Error: node polygon has zero area");
        }
        this.hm /= 2.0;
        this.fn.closePath();
    }

    private static boolean a(double[] dArray, double[] dArray2, int n2) {
        if (n2 <= 3) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            double d2 = dArray[n3];
            double d3 = dArray2[n3];
            double d4 = dArray[(n3 + 1) % n2];
            double d5 = dArray2[(n3 + 1) % n2];
            int n4 = n3 + 2;
            int n5 = n3 == 0 ? n2 - 1 : n2;
            while (n4 < n5) {
                double d6 = dArray[n4];
                double d7 = dArray2[n4];
                double d8 = dArray[(n4 + 1) % n2];
                double d9 = dArray2[(n4 + 1) % n2];
                if (Line2D.linesIntersect(d2, d3, d4, d5, d6, d7, d8, d9)) {
                    return true;
                }
                ++n4;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public Point randomPointInside(Random random, Point point) {
        double d2;
        double d3;
        this.d();
        if (point == null) {
            point = new Point();
        }
        while (!this.fn.contains(d3 = Utilities.uniform(this.in, this.jn, random), d2 = Utilities.uniform(this.da, this.kn, random))) {
        }
        point.setLocation(d3, d2);
        this.e(point);
        return point;
    }

    private void e(Point point) {
        point.z = this.a(point.x, point.y);
        point.x += this.a;
        point.y += this.e;
    }

    @Override
    public double getNearestPoint(double d2, double d3, Point point) {
        this.d();
        double d4 = d2 - this.a;
        double d5 = d3 - this.e;
        if (this.fn.contains(d4, d5)) {
            point.setLocation(d4, d5);
            this.e(point);
            return 0.0;
        }
        int n2 = this.nm.length;
        Utilities.getNearestPointOnSegment(point, this.nm[n2 - 1], this.ch[n2 - 1], this.nm[0], this.ch[0], d4, d5);
        double d6 = Utilities.getDistanceSq(d4, d5, point.x, point.y);
        Point point2 = new Point();
        int n3 = 1;
        while (n3 < n2) {
            Utilities.getNearestPointOnSegment(point2, this.nm[n3 - 1], this.ch[n3 - 1], this.nm[n3], this.ch[n3], d4, d5);
            double d7 = Utilities.getDistanceSq(d4, d5, point2.x, point2.y);
            if (d7 < d6) {
                point.setLocation(point2);
                d6 = d7;
            }
            ++n3;
        }
        this.e(point);
        return d6;
    }

    @Override
    public double getNearestPoint(double d2, double d3, double d4, Point point) {
        double d5 = this.getNearestPoint(d2, d3, point);
        return d5 + Utilities.sqr(d4 - this.c);
    }

    private Position[] k(int n2) {
        Position[] positionArray;
        if (n2 <= 0 || n2 > 1000) {
            n2 = 1000;
        }
        if ((positionArray = this.fi) == null || positionArray.length < n2) {
            double d2;
            positionArray = new Position[n2];
            int n3 = 0;
            while (n3 < positionArray.length) {
                positionArray[n3] = new Position();
                ++n3;
            }
            double d3 = this.jn - this.in;
            double d4 = this.kn - this.da;
            double d5 = d3 / d4;
            double d6 = (double)n2 * (d3 * d4 / this.hm);
            double d7 = Math.sqrt(d6 / d5);
            double d8 = d5 * d7;
            double d9 = d3 / d8;
            double d10 = d4 / d7;
            int n4 = 0;
            double d11 = this.da + d10 * 0.5;
            block1: while (d11 < this.kn) {
                d2 = this.in + d9 * 0.5;
                while (d2 < this.jn) {
                    if (this.fn.contains(d2, d11)) {
                        positionArray[n4].setLocation(d2, d11);
                        if (++n4 >= positionArray.length) break block1;
                    }
                    d2 += d9;
                }
                d11 += d10;
            }
            if (n4 < positionArray.length) {
                d11 = this.da + d10;
                block3: while (d11 < this.kn) {
                    d2 = this.in + d9;
                    while (d2 < this.jn) {
                        if (this.fn.contains(d2, d11)) {
                            positionArray[n4].setLocation(d2, d11);
                            if (++n4 >= positionArray.length) break block3;
                        }
                        d2 += d9;
                    }
                    d11 += d10;
                }
                while (n4 < positionArray.length) {
                    while (!this.fn.contains(d11 = this.bj.uniform(this.in, this.jn), d2 = this.bj.uniform(this.da, this.kn))) {
                    }
                    positionArray[n4++].setLocation(d11, d2);
                }
            }
            Position[] positionArray2 = positionArray;
            int n5 = positionArray.length;
            int n6 = 0;
            while (n6 < n5) {
                Position position = positionArray2[n6];
                this.e(position);
                position.verticalRotation = Double.NaN;
                position.rotation = Double.NaN;
                ++n6;
            }
            this.fi = positionArray;
        }
        return positionArray;
    }

    static int a(int n2, int n3, int n4) {
        return (int)((long)n2 * 46337L / (long)n3 * 46327L % 46337L * (long)n4 / 46337L);
    }

    @Override
    public Position getPosition(int n2, int n3, Position position) {
        if (n2 < 0) {
            n2 = 0;
        }
        switch (this.ai) {
            case POSITION_CHOICE_ARRANGED: {
                if (n3 < 1) {
                    n3 = 1;
                }
                Position[] positionArray = this.k(n3);
                position = positionArray[n2 % positionArray.length].clone(position);
                return position;
            }
        }
        return super.getPosition(n2, n3, position);
    }

    public double getXMin() {
        return this.a + this.in;
    }

    public double getXMax() {
        return this.a + this.jn;
    }

    public double getYMin() {
        return this.e + this.da;
    }

    public double getYMax() {
        return this.e + this.kn;
    }

    public int getNPoints() {
        return this.nm.length;
    }

    public double getPointDx(int n2) {
        return this.nm[n2];
    }

    public double getPointDy(int n2) {
        return this.ch[n2];
    }

    @Override
    public boolean contains(double d2, double d3) {
        this.d();
        return this.in <= d2 && d2 <= this.jn && this.da <= d3 && d3 <= this.kn && this.fn.contains(d2 -= this.a, d3 -= this.e);
    }

    @Override
    public void draw(Panel panel, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl) {
        double d2;
        Rectangle rectangle;
        this.d();
        if (!this.a(bl)) {
            return;
        }
        if (this.if == null && (this.m == null || this.g == 0.0f)) {
            return;
        }
        com.anylogic.engine.internal.presentation.e.a(graphics2D, affineTransform);
        graphics2D.translate(this.a, this.e);
        if (panel != null && panel.isAnimationParameterEnabled(12) && (rectangle = com.anylogic.engine.internal.presentation.e.a(graphics2D)) != null && !rectangle.intersects(this.in - (double)this.g, this.da - (double)this.g, this.jn - this.in + (d2 = (double)(this.g + this.g)), this.kn - this.da + d2)) {
            return;
        }
        if (this.if != null) {
            com.anylogic.engine.internal.presentation.e.a(graphics2D, this.if);
            graphics2D.fill(this.fn);
        }
        if (this.m != null && this.g > 0.0f) {
            com.anylogic.engine.internal.presentation.e.a(graphics2D, this.m);
            com.anylogic.engine.internal.presentation.e.a(graphics2D, this.g, this.b, true);
            graphics2D.draw(this.fn);
        }
    }

    @Override
    @AnyLogicInternalAPI
    public void update3D(Panel panel, boolean bl) {
        if (!this.getDrawMode().has3D()) {
            return;
        }
        this.a(panel, bl);
    }

    @Override
    int ai() {
        return super.ai() + 1;
    }

    @Override
    f[] b() {
        f[] fArray = super.b();
        int n2 = super.ai();
        fArray[n2] = this.ec();
        return fArray;
    }

    private f ec() {
        int n2 = this.nm.length;
        Paint paint = n2 >= 3 ? this.if : null;
        double d2 = 0.0;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double d3 = Double.NaN;
        double d4 = Double.NaN;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (this.nm[n4] != d3 || this.ch[n4] != d4) {
                d3 = this.nm[n4];
                d4 = this.ch[n4];
                dArray[n3] = this.nm[n4];
                dArray2[n3] = -this.ch[n4];
                dArray3[n3] = d2;
                ++n3;
            }
            ++n4;
        }
        n4 = 1;
        if (n4 != 0 && n3 >= 2 && dArray[0] == dArray[n3 - 1] && dArray2[0] == dArray2[n3 - 1]) {
            --n3;
        }
        Boolean bl = null;
        if (paint != null) {
            if (bl == null) {
                boolean bl2 = true;
                if (n2 > 3) {
                    int n5 = 0;
                    block1: while (n5 < n2) {
                        double d5 = dArray[n5];
                        double d6 = dArray2[n5];
                        int n6 = (n5 + 1) % n2;
                        double d7 = dArray[n6];
                        double d8 = dArray2[n6];
                        int n7 = n5 + 2;
                        int n8 = n5 != 0 ? n2 : n2 - 1;
                        while (n7 < n8) {
                            int n9 = (n7 + 1) % n2;
                            if (Line2D.linesIntersect(d5, d6, d7, d8, dArray[n7], dArray2[n7], dArray[n9], dArray2[n9])) {
                                bl2 = false;
                                break block1;
                            }
                            ++n7;
                        }
                        ++n5;
                    }
                }
                bl = bl2;
            }
            if (!bl.booleanValue()) {
                paint = null;
            }
        }
        double d9 = 0.0;
        return new fk(this, n2, dArray, dArray2, dArray3, true, this.g, d9, this.m, paint);
    }

    @Override
    void a(jd jd2) {
        super.a(jd2);
        if (this.e(km)) {
            jd2.a(this.ec());
        }
    }
}

