/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Agent;
import com.anylogic.engine.LengthUnits;
import com.anylogic.engine.UtilitiesCollection;
import com.anylogic.engine.markup.AbstractDrawableMarkupAggregator;
import com.anylogic.engine.markup.AbstractMarkup;
import com.anylogic.engine.markup.AbstractRailwayMarkup;
import com.anylogic.engine.markup.PositionOnTrack;
import com.anylogic.engine.markup.RailwaySwitch;
import com.anylogic.engine.markup.RailwayTrack;
import com.anylogic.engine.presentation.ShapeDrawMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class RailwayNetwork
extends AbstractDrawableMarkupAggregator {
    private static final long serialVersionUID = -897041126840714279L;
    private List<RailwayTrack> j = new ArrayList<RailwayTrack>();
    private List<RailwaySwitch> c = new ArrayList<RailwaySwitch>();
    private List<PositionOnTrack> l = new ArrayList<PositionOnTrack>();
    private double f = 0.0;
    private double i;

    public RailwayNetwork(Agent agent, String string, ShapeDrawMode shapeDrawMode, double d2) {
        super(agent, string, shapeDrawMode);
        this.f = d2;
    }

    public RailwayNetwork(Agent agent, String string, ShapeDrawMode shapeDrawMode, double d2, boolean bl, boolean bl2) {
        this(agent, string, shapeDrawMode, d2);
        this.k = bl;
        this.h = bl2;
    }

    public RailwayNetwork(Agent agent, String string, ShapeDrawMode shapeDrawMode, double d2, boolean bl, boolean bl2, AbstractRailwayMarkup ... abstractRailwayMarkupArray) {
        this(agent, string, shapeDrawMode, d2);
        this.k = bl;
        this.h = bl2;
        this.addAll(abstractRailwayMarkupArray);
        this.initialize();
    }

    public void addAll(AbstractRailwayMarkup ... abstractRailwayMarkupArray) {
        AbstractRailwayMarkup[] abstractRailwayMarkupArray2 = abstractRailwayMarkupArray;
        int n2 = abstractRailwayMarkupArray.length;
        int n3 = 0;
        while (n3 < n2) {
            AbstractRailwayMarkup abstractRailwayMarkup = abstractRailwayMarkupArray2[n3];
            if (abstractRailwayMarkup instanceof RailwayTrack) {
                this.add((RailwayTrack)abstractRailwayMarkup);
            } else if (abstractRailwayMarkup instanceof RailwaySwitch) {
                this.add((RailwaySwitch)abstractRailwayMarkup);
            } else if (abstractRailwayMarkup instanceof PositionOnTrack) {
                this.add((PositionOnTrack)abstractRailwayMarkup);
            } else {
                throw new IllegalArgumentException("Unsupported element: " + abstractRailwayMarkup);
            }
            ++n3;
        }
    }

    public Agent getSpace() {
        return (Agent)this.a;
    }

    public double getZ() {
        return this.f;
    }

    public double getScale() {
        return this.i;
    }

    public List<RailwayTrack> getTracks() {
        this.h();
        return this.j;
    }

    public List<RailwaySwitch> getSwitches() {
        this.h();
        return this.c;
    }

    public List<PositionOnTrack> getPointOnTracks() {
        this.h();
        return this.l;
    }

    @Override
    void e() {
        super.e();
        this.j = Collections.unmodifiableList(this.j);
        this.c = Collections.unmodifiableList(this.c);
        this.l = Collections.unmodifiableList(this.l);
    }

    @Override
    Stream<? extends AbstractMarkup> d() {
        return UtilitiesCollection.streamOfElements(this.j, this.c, this.l);
    }

    public void add(RailwayTrack railwayTrack) {
        this.k();
        railwayTrack.a(this);
        this.j.add(railwayTrack);
    }

    public void add(RailwaySwitch railwaySwitch) {
        this.k();
        railwaySwitch.a(this);
        this.c.add(railwaySwitch);
    }

    public void add(PositionOnTrack positionOnTrack) {
        this.k();
        positionOnTrack.a(this);
        this.l.add(positionOnTrack);
    }

    public double pixelsToMeters(double d2) {
        this.h();
        return this.getSpace().toLengthUnits(d2, LengthUnits.METER);
    }

    public double metersToPixels(double d2) {
        this.h();
        return this.getSpace().toPixels(d2, LengthUnits.METER);
    }
}

