/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.AnyLogicInternalCodegenAPI;
import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.ae;
import com.anylogic.engine.internal.presentation.e;
import com.anylogic.engine.markup.AbstractRailwayMarkup;
import com.anylogic.engine.markup.RailwayTrack;
import com.anylogic.engine.markup.SwitchDataSource;
import com.anylogic.engine.presentation.LineStyle;
import com.anylogic.engine.presentation.Panel;
import com.anylogic.engine.presentation.ShapeDrawMode;
import com.anylogic.engine.presentation.UtilitiesColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RailwaySwitch
extends AbstractRailwayMarkup {
    private static final long serialVersionUID = 3490247508785288178L;
    private static final double a = 0.001;
    private static final double e = 1.0E-6;
    private double c;
    private double l;
    private double f;
    private double i;
    private double n;
    private double m = 1.0;
    private Color g = UtilitiesColor.markupDefaultSwitchSelection;
    private Paint b = UtilitiesColor.markupDefaultSwitch;
    @AnyLogicCustomSerialization
    private transient RailwayTrack ai;
    @AnyLogicCustomSerialization
    private transient List<RailwayTrack> hn;
    @AnyLogicCustomSerialization
    private transient RailwayTrack gd;
    @AnyLogicCustomSerialization
    private transient SwitchDataSource fc;

    public RailwaySwitch() {
    }

    public RailwaySwitch(Agent agent, ShapeDrawMode shapeDrawMode, boolean bl) {
        super(agent, shapeDrawMode, bl);
    }

    public RailwaySwitch(Agent agent, ShapeDrawMode shapeDrawMode, boolean bl, double d2, Color color, Paint paint, RailwayTrack railwayTrack, RailwayTrack ... railwayTrackArray) {
        super(agent, shapeDrawMode, bl);
        this.m = d2;
        this.b = paint;
        this.g = color;
        this.setSwitch(railwayTrack, railwayTrackArray);
        this.initialize();
    }

    @Override
    void g_() {
        this.setColor(UtilitiesColor.red);
    }

    public void setSwitch(RailwayTrack railwayTrack, RailwayTrack ... railwayTrackArray) {
        this.j();
        if (railwayTrack == null) {
            this.error("Argument 'track' is null");
        }
        if (railwayTrackArray == null) {
            this.error("Argument 'alternativeTracks' is null");
        }
        this.ai = railwayTrack;
        this.hn = new ArrayList<RailwayTrack>(railwayTrackArray.length);
        RailwayTrack[] railwayTrackArray2 = railwayTrackArray;
        int n2 = railwayTrackArray.length;
        int n3 = 0;
        while (n3 < n2) {
            RailwayTrack railwayTrack2 = railwayTrackArray2[n3];
            if (railwayTrack2 != null) {
                this.hn.add(railwayTrack2);
            }
            ++n3;
        }
    }

    @Override
    void i() {
        super.i();
        if (this.ai == null) {
            this.error("Main track is not defined. Please check that this switch has three connected tracks");
        }
        if (this.hn.size() == 0 || this.hn.size() > 2) {
            this.error("There should be 1-2 alternative tracks. Please check that this switch has three connected tracks");
        }
        Point[] pointArray = new Point[]{this.ai.h(), this.ai.n()};
        Point point = null;
        boolean[] blArray = new boolean[this.hn.size() + 1];
        int n2 = 0;
        while (n2 < pointArray.length) {
            blArray[0] = n2 == 0;
            point = pointArray[n2];
            int n3 = 0;
            while (n3 < this.hn.size()) {
                boolean bl = blArray[n3 + 1] = point.distanceSq(this.hn.get(n3).h()) <= 1.0E-6;
                if (!blArray[n3 + 1] && point.distanceSq(this.hn.get(n3).n()) > 1.0E-6) {
                    point = null;
                    break;
                }
                ++n3;
            }
            if (point != null) break;
            ++n2;
        }
        if (point == null) {
            this.error("Error during switch initialization: couldn't find matching point on alternative track");
        }
        this.c = point.x;
        this.l = point.y;
        double d2 = blArray[0] ? 0.0 : this.ai.length();
        Position position = this.ai.getPositionAtOffset(d2, new Position());
        this.f = position.z;
        int n4 = 0;
        while (n4 < blArray.length) {
            if (blArray[n4]) {
                if (n4 == 0) {
                    this.ai.a(this);
                } else {
                    this.hn.get(n4 - 1).a(this);
                }
            } else if (n4 == 0) {
                this.ai.e(this);
            } else {
                this.hn.get(n4 - 1).e(this);
            }
            ++n4;
        }
        this.gd = this.hn.get(0);
        this.hn = Collections.unmodifiableList(this.hn);
        this.h();
    }

    private void h() {
        double d2 = this.m * 1.5;
        boolean bl = this.gd.getStartSwitch() == this;
        double d3 = bl ? d2 : this.gd.length() - d2;
        Position position = this.gd.getPositionAtOffset(d3, new Position());
        this.i = position.x - this.c;
        this.n = position.y - this.l;
    }

    public void setDataSource(SwitchDataSource switchDataSource) {
        if (switchDataSource == null) {
            this.a(ae.ind, "dataSource");
        }
        if (switchDataSource == this.fc) {
            return;
        }
        if (this.fc != null) {
            this.a(ae.ldh, switchDataSource);
        }
        this.fc = switchDataSource;
    }

    public double getX() {
        return this.c;
    }

    public double getY() {
        return this.l;
    }

    public double getZ() {
        return this.f;
    }

    public double getRadius() {
        return this.m;
    }

    public void setRadius(double d2) {
        this.m = d2;
        if (this.hn != null) {
            this.h();
        }
    }

    public Color getSelectionColor() {
        return this.g;
    }

    public void setSelectionColor(Color color) {
        this.g = color;
    }

    public Paint getColor() {
        return this.b;
    }

    public void setColor(Paint paint) {
        this.b = paint;
    }

    public RailwayTrack getMainTrack() {
        return this.ai;
    }

    public List<RailwayTrack> getAlternativeTracks() {
        return this.hn;
    }

    public RailwayTrack getTrack(int n2) {
        this.d();
        if (n2 == 0) {
            return this.ai;
        }
        return this.hn.get(n2 - 1);
    }

    public RailwayTrack getSelectedTrack() {
        this.d();
        return this.gd;
    }

    public void setSelectedTrack(RailwayTrack railwayTrack) {
        this.d();
        if (!this.hn.contains(railwayTrack)) {
            this.a("The track %s is not connected to the switch '%s'", railwayTrack.getName(), this.getName());
        }
        this.gd = railwayTrack;
        this.h();
        if (this.fc != null) {
            this.fc.onToggle();
        }
    }

    public void toggle() {
        this.d();
        int n2 = this.hn.indexOf(this.gd);
        if (++n2 == this.hn.size()) {
            n2 = 0;
        }
        this.setSelectedTrack(this.hn.get(n2));
    }

    public RailwayTrack nextTrack(RailwayTrack railwayTrack) {
        this.d();
        if (railwayTrack == this.ai) {
            return this.gd;
        }
        if (this.hn.contains(railwayTrack)) {
            return this.ai;
        }
        this.a("The track %s is not connected to the switch '%s'", railwayTrack.getName(), this.getName());
        return null;
    }

    public boolean isTrailingPoint(RailwayTrack railwayTrack) {
        this.d();
        if (railwayTrack == this.ai) {
            return false;
        }
        if (this.hn.contains(railwayTrack)) {
            return true;
        }
        this.a("The track %s is not connected to the switch '%s'", railwayTrack.getName(), this.getName());
        return false;
    }

    public boolean trackStarts(RailwayTrack railwayTrack) {
        this.d();
        if (railwayTrack != this.ai && !this.hn.contains(railwayTrack)) {
            this.a("The track %s is not connected to the switch '%s'", railwayTrack.getName(), this.getName());
        }
        return railwayTrack.getStartSwitch() == this;
    }

    @Override
    public boolean contains(double d2, double d3) {
        return d2 == this.c && d3 == this.l;
    }

    @Override
    public void draw(Panel panel, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl) {
        if (!this.a(bl)) {
            return;
        }
        com.anylogic.engine.internal.presentation.e.a(graphics2D, this.b);
        com.anylogic.engine.internal.presentation.e.e(panel, graphics2D, affineTransform, this.c, this.l, 0.0, 1.0, 1.0, this.b, null, this.m, this.m, 2.0, LineStyle.LINE_STYLE_SOLID);
        graphics2D.setStroke(com.anylogic.engine.internal.presentation.e.e());
        com.anylogic.engine.internal.presentation.e.a(panel, graphics2D, affineTransform, this.c, this.l, 0.0, 1.0, 1.0, this.g, this.i, this.n, 1.0f, LineStyle.LINE_STYLE_SOLID);
    }

    @Override
    @AnyLogicInternalCodegenAPI
    public boolean onClick(double d2, double d3) {
        this.toggle();
        return true;
    }

    @Override
    @AnyLogicInternalCodegenAPI
    public boolean onClickAt(double d2, double d3, boolean bl) {
        if (!this.a(bl)) {
            this.aj = false;
            return false;
        }
        double d4 = d2 - this.c;
        double d5 = d3 - this.l;
        this.aj = Utilities.getLengthSq(d4, d5) <= this.m * this.m;
        if (this.aj) {
            return this.onClick(d4, d5);
        }
        return false;
    }
}

