/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Agent;
import com.anylogic.engine.LengthUnits;
import com.anylogic.engine.UtilitiesCollection;
import com.anylogic.engine.internal.ae;
import com.anylogic.engine.markup.AbstractDrawableMarkupAggregator;
import com.anylogic.engine.markup.AbstractRoadConnectableElement;
import com.anylogic.engine.markup.AbstractRoadConnector;
import com.anylogic.engine.markup.AbstractRoadMarkup;
import com.anylogic.engine.markup.BusStop;
import com.anylogic.engine.markup.ParkingLot;
import com.anylogic.engine.markup.Road;
import com.anylogic.engine.markup.RoadConnectionPoint;
import com.anylogic.engine.markup.RoadConstants;
import com.anylogic.engine.markup.StopLine;
import com.anylogic.engine.presentation.ShapeDrawMode;
import com.anylogic.engine.presentation.Texture;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class RoadNetwork
extends AbstractDrawableMarkupAggregator {
    private static final long serialVersionUID = -937909314958968329L;
    private RoadConstants.DrivingDirection j = RoadConstants.DrivingDirection.RIGHT_HAND;
    private double c = 3.5;
    private double l;
    private Paint f = Color.gray;
    private Paint i = Color.white;
    private RoadConstants.RoadLineStyle n = RoadConstants.RoadLineStyle.SINGLE_DASHED;
    private Paint m = Color.white;
    private RoadConstants.RoadLineStyle g = RoadConstants.RoadLineStyle.SINGLE;
    private List<Road> b = new ArrayList<Road>();
    private List<AbstractRoadConnector> ai = new ArrayList<AbstractRoadConnector>();
    private List<StopLine> hn = new ArrayList<StopLine>();
    private List<ParkingLot> lg = new ArrayList<ParkingLot>();
    private List<BusStop> gf = new ArrayList<BusStop>();

    public RoadNetwork(Agent agent, String string, ShapeDrawMode shapeDrawMode) {
        super(agent, string, shapeDrawMode);
    }

    public RoadNetwork(Agent agent, String string, ShapeDrawMode shapeDrawMode, RoadConstants.DrivingDirection drivingDirection, double d2, Paint paint, Paint paint2, RoadConstants.RoadLineStyle roadLineStyle, Paint paint3, RoadConstants.RoadLineStyle roadLineStyle2) {
        super(agent, string, shapeDrawMode);
        this.j = drivingDirection;
        this.c = d2;
        this.f = paint;
        this.i = paint2;
        this.n = roadLineStyle;
        this.m = paint3;
        this.g = roadLineStyle2;
        this.c();
    }

    public RoadNetwork(Agent agent, String string, ShapeDrawMode shapeDrawMode, RoadConstants.DrivingDirection drivingDirection, double d2, Paint paint, Paint paint2, RoadConstants.RoadLineStyle roadLineStyle, Paint paint3, RoadConstants.RoadLineStyle roadLineStyle2, AbstractRoadMarkup ... abstractRoadMarkupArray) {
        this(agent, string, shapeDrawMode, drivingDirection, d2, paint, paint2, roadLineStyle, paint3, roadLineStyle2);
        this.addAll(abstractRoadMarkupArray);
        this.initialize();
    }

    private void c() {
        if (this.c <= 0.0) {
            throw this.a(ae.fbb, "laneWidthInMeters", this.c);
        }
    }

    public void addAll(AbstractRoadMarkup ... abstractRoadMarkupArray) {
        AbstractRoadMarkup[] abstractRoadMarkupArray2 = abstractRoadMarkupArray;
        int n2 = abstractRoadMarkupArray.length;
        int n3 = 0;
        while (n3 < n2) {
            AbstractRoadMarkup abstractRoadMarkup = abstractRoadMarkupArray2[n3];
            if (abstractRoadMarkup instanceof Road) {
                this.add((Road)abstractRoadMarkup);
            } else if (abstractRoadMarkup instanceof AbstractRoadConnector) {
                this.add((AbstractRoadConnector)abstractRoadMarkup);
            } else if (abstractRoadMarkup instanceof StopLine) {
                this.add((StopLine)abstractRoadMarkup);
            } else if (abstractRoadMarkup instanceof ParkingLot) {
                this.add((ParkingLot)abstractRoadMarkup);
            } else if (abstractRoadMarkup instanceof BusStop) {
                this.add((BusStop)abstractRoadMarkup);
            } else {
                throw new IllegalArgumentException("Unsupported element: " + abstractRoadMarkup);
            }
            ++n3;
        }
    }

    public void add(Road road) {
        this.k();
        road.setRoadNetwork(this);
        this.b.add(road);
    }

    public void add(AbstractRoadConnector abstractRoadConnector) {
        this.k();
        abstractRoadConnector.setRoadNetwork(this);
        this.ai.add(abstractRoadConnector);
    }

    public void add(StopLine stopLine) {
        this.k();
        stopLine.setRoadNetwork(this);
        this.hn.add(stopLine);
    }

    public void add(ParkingLot parkingLot) {
        this.k();
        parkingLot.setRoadNetwork(this);
        this.lg.add(parkingLot);
    }

    public void add(BusStop busStop) {
        this.k();
        busStop.setRoadNetwork(this);
        this.gf.add(busStop);
    }

    public List<Road> getRoads() {
        this.h();
        return this.b;
    }

    public List<StopLine> getStopLines() {
        this.h();
        return this.hn;
    }

    public List<AbstractRoadConnector> getRoadConnectors() {
        this.h();
        return this.ai;
    }

    public List<ParkingLot> getParkingLots() {
        this.h();
        return this.lg;
    }

    public List<BusStop> getBusStops() {
        this.h();
        return this.gf;
    }

    public RoadConstants.DrivingDirection getDrivingDirection() {
        return this.j;
    }

    public void setDrivingDirection(RoadConstants.DrivingDirection drivingDirection) {
        this.k();
        this.j = drivingDirection;
    }

    public double getLaneWidthInPixels() {
        return this.l;
    }

    public double getLaneWidth() {
        return this.c;
    }

    public double getLaneWidth(LengthUnits lengthUnits) {
        return LengthUnits.METER.convertTo(this.getLaneWidth(), lengthUnits);
    }

    public void setLaneWidth(double d2) {
        this.k();
        this.c = d2;
    }

    public void setLaneWidth(double d2, LengthUnits lengthUnits) {
        this.setLaneWidth(lengthUnits.convertTo(d2, LengthUnits.METER));
    }

    public void setRoadBackgroundColor(Color color) {
        this.setRoadBackgroundColor((Paint)color);
    }

    public void setRoadBackgroundColor(Paint paint) {
        this.f = paint;
    }

    public Color getRoadBackgroundColor() {
        return this.f instanceof Color ? (Color)this.f : null;
    }

    public Texture getRoadBackgroundTexture() {
        return this.f instanceof Texture ? (Texture)this.f : null;
    }

    public void setLanesDelimitingLineColor(Color color) {
        this.setLanesDelimitingLineColor((Paint)color);
    }

    public void setLanesDelimitingLineColor(Paint paint) {
        this.k();
        this.i = paint;
    }

    public Color getLanesDelimitingLineColor() {
        return this.i instanceof Color ? (Color)this.i : null;
    }

    public Texture getLanesDelimitingLineTexture() {
        return this.i instanceof Texture ? (Texture)this.i : null;
    }

    public void setLanesDelimitingLineStyle(RoadConstants.RoadLineStyle roadLineStyle) {
        this.n = roadLineStyle;
    }

    public RoadConstants.RoadLineStyle getLanesDelimitingLineStyle() {
        return this.n;
    }

    public void setDirectionsDelimitingLineColor(Color color) {
        this.setDirectionsDelimitingLineColor((Paint)color);
    }

    public void setDirectionsDelimitingLineColor(Paint paint) {
        this.k();
        this.m = paint;
    }

    public Color getDirectionsDelimitingLineColor() {
        return this.m instanceof Color ? (Color)this.m : null;
    }

    public Texture getDirectionsDelimitingLineTexture() {
        return this.m instanceof Texture ? (Texture)this.m : null;
    }

    public void setDirectionsDelimitingLineStyle(RoadConstants.RoadLineStyle roadLineStyle) {
        this.k();
        this.g = roadLineStyle;
    }

    public RoadConstants.RoadLineStyle getDirectionsDelimitingLineStyle() {
        return this.g;
    }

    @Override
    void e() {
        super.e();
        this.b = Collections.unmodifiableList(this.b);
        this.ai = Collections.unmodifiableList(this.ai);
        this.hn = Collections.unmodifiableList(this.hn);
        this.lg = Collections.unmodifiableList(this.lg);
        this.gf = Collections.unmodifiableList(this.gf);
        this.l = ((Agent)this.a).toPixels(this.c, LengthUnits.METER);
    }

    @Override
    void a() {
        super.a();
        this.l();
    }

    private void l() {
        ArrayList<AbstractRoadConnectableElement> arrayList = new ArrayList<AbstractRoadConnectableElement>();
        arrayList.addAll(this.b);
        arrayList.addAll(this.ai);
        for (AbstractRoadConnectableElement abstractRoadConnectableElement : arrayList) {
            for (RoadConnectionPoint roadConnectionPoint : abstractRoadConnectableElement.getConnectionPoints()) {
                for (AbstractRoadConnectableElement abstractRoadConnectableElement2 : arrayList) {
                    if (abstractRoadConnectableElement2 == abstractRoadConnectableElement) continue;
                    for (RoadConnectionPoint roadConnectionPoint2 : abstractRoadConnectableElement2.getConnectionPoints()) {
                        if (!roadConnectionPoint.canConnectTo(roadConnectionPoint2) || roadConnectionPoint.getConnectedPoint() != null) continue;
                        roadConnectionPoint.connectTo(roadConnectionPoint2);
                    }
                }
            }
        }
    }

    @Override
    Stream<? extends AbstractRoadMarkup> d() {
        return UtilitiesCollection.streamOfElements(this.b, this.ai, this.hn, this.lg, this.gf);
    }

    @Deprecated
    public void setDebugInfoVisible(boolean bl) {
        this.d().forEach(abstractRoadMarkup -> abstractRoadMarkup.setDebugInfoVisible(bl));
    }
}

