/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Agent;
import com.anylogic.engine.Path2D;
import com.anylogic.engine.Point;
import com.anylogic.engine.Presentable;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.presentation.e;
import com.anylogic.engine.markup.AbstractGroundMarkup;
import com.anylogic.engine.markup.GroundMarkup;
import com.anylogic.engine.presentation.Panel;
import com.anylogic.engine.presentation.ShapeDrawMode;
import com.anylogic.engine.presentation.UtilitiesColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import java.util.Random;

public class TargetLine
extends AbstractGroundMarkup
implements GroundMarkup {
    private static final long serialVersionUID = -5644504854285254364L;
    protected double a;
    protected double e;
    protected double[] c;
    protected double[] l;
    protected Color f = UtilitiesColor.markupDefaultPedestrian;
    private double i;
    private double[] n;
    private transient Path2D m = null;

    public TargetLine() {
    }

    public TargetLine(Agent agent, ShapeDrawMode shapeDrawMode, boolean bl, double d2, double d3, double[] dArray, double[] dArray2, Color color) {
        super(agent, shapeDrawMode, bl);
        this.a = d2;
        this.e = d3;
        this.f = color;
        if (dArray == null || dArray2 == null || dArray.length == 0 || dArray.length != dArray2.length) {
            throw this.error("Error: Invalid dx, dy arguments: should be not empty arrays with equal sizes");
        }
        this.c = dArray;
        this.l = dArray2;
        this.initialize();
    }

    @Override
    void g_() {
        this.setColor(UtilitiesColor.red);
    }

    public double getX() {
        return this.a;
    }

    public double getY() {
        return this.e;
    }

    public void setPos(double d2, double d3) {
        this.j();
        this.a = d2;
        this.e = d3;
    }

    public void addPoint(double d2, double d3) {
        int n2;
        int n3;
        this.j();
        if (this.c == null) {
            this.c = new double[11];
            this.c[0] = 0.0;
        }
        if ((n3 = (n2 = (int)(this.c[0] = this.c[0] + 1.0)) * 2 + 1) > this.c.length) {
            double[] dArray = this.c;
            this.c = new double[n2 * 4 + 1];
            System.arraycopy(dArray, 0, this.c, 0, (n2 - 1) * 2 + 1);
        }
        n3 -= 2;
        this.c[n3++] = d2;
        this.c[n3++] = d3;
    }

    @Override
    void i() {
        int n2;
        int n3;
        super.i();
        if (this.l == null) {
            if (this.c == null || this.c[0] < 2.0) {
                throw this.error("Error: line should have at least 2 points");
            }
            n3 = (int)this.c[0];
            double[] dArray = this.c;
            this.c = new double[n3];
            this.l = new double[n3];
            n2 = 1;
            int n4 = 0;
            while (n4 < n3) {
                this.c[n4] = dArray[n2++];
                this.l[n4] = dArray[n2++];
                ++n4;
            }
        }
        if ((n3 = this.c.length) < 2) {
            throw this.error("Error: line should have at least 2 points");
        }
        this.n = new double[n3 - 1];
        int n5 = 0;
        n2 = 0;
        while (n2 < this.n.length) {
            double d2 = Utilities.getDistance(this.c[n2], this.l[n2], this.c[n2 + 1], this.l[n2 + 1]);
            if (d2 == 0.0) {
                this.error("Empty segment in line");
            }
            n5 = (int)((double)n5 + d2);
            this.n[n2] = n5;
            ++n2;
        }
        this.i = n5;
        if (n5 == 0) {
            this.error("Empty line");
        }
    }

    public int getNPoints() {
        return this.c.length;
    }

    public double getPointDx(int n2) {
        return this.c[n2];
    }

    public double getPointDy(int n2) {
        return this.l[n2];
    }

    public void setColor(Color color) {
        this.f = color;
    }

    public Color getColor() {
        return this.f instanceof Color ? this.f : null;
    }

    public final double length() {
        this.d();
        return this.i;
    }

    public final Point getPointAtOffset(double d2, Point point) {
        if (point == null) {
            point = new Point();
        }
        this.a(d2, point);
        return point;
    }

    private void a(double d2, Point point) {
        this.d();
        if (d2 > this.i) {
            if (d2 < this.i + 1.0E-4) {
                d2 = this.i;
            } else {
                this.a("Offset (%s) is greater than length (%s)", d2, this.i);
            }
        } else if (d2 < 0.0) {
            if (d2 > -1.0E-4) {
                d2 = 0.0;
            } else {
                this.a("Offset (%s) is negative", d2);
            }
        }
        int n2 = Arrays.binarySearch(this.n, d2);
        if (n2 < 0) {
            n2 = -n2 - 1;
        }
        double d3 = n2 > 0 ? this.n[n2 - 1] : 0.0;
        double d4 = (d2 - d3) / (this.n[n2] - d3);
        point.x = this.a + this.c[n2] + d4 * (this.c[n2 + 1] - this.c[n2]);
        point.y = this.e + this.l[n2] + d4 * (this.l[n2 + 1] - this.l[n2]);
    }

    @Override
    public boolean contains(double d2, double d3) {
        return this.containsSq(d2, d3, 1.0E-8);
    }

    public boolean contains(double d2, double d3, double d4) {
        return this.containsSq(d2, d3, Utilities.sqr(d4));
    }

    public boolean containsSq(double d2, double d3, double d4) {
        this.d();
        d2 -= this.a;
        d3 -= this.e;
        int n2 = 1;
        while (n2 < this.c.length) {
            if (Utilities.getDistanceFromPointToSegmentSq(this.c[n2 - 1], this.l[n2 - 1], this.c[n2], this.l[n2], d2, d3) <= d4) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void draw(Panel panel, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl) {
        this.d();
        if (!this.a(bl)) {
            return;
        }
        if (this.f == null) {
            return;
        }
        com.anylogic.engine.internal.presentation.e.a(panel, graphics2D, affineTransform, this.a, this.e, 0.0, 1.0, 1.0, (Paint)this.f, null, this.c.length, this.c, this.l, false, 2.0, Presentable.LINE_STYLE_SOLID, false);
        graphics2D.setStroke(com.anylogic.engine.internal.presentation.e.e());
        com.anylogic.engine.internal.presentation.e.a(graphics2D, this.c[0], this.l[0], this.c[1], this.l[1]);
        com.anylogic.engine.internal.presentation.e.a(graphics2D, this.c[this.c.length - 1], this.l[this.c.length - 1], this.c[this.c.length - 2], this.l[this.c.length - 2]);
    }

    public Point randomPointInside() {
        return this.randomPointInside(this.bj.getEngine().getDefaultRandomGenerator(), null);
    }

    public final Point randomPointInside(Random random, Point point) {
        double d2 = Utilities.uniform(0.0, this.length(), random);
        if (point == null) {
            point = new Point();
        }
        this.a(d2, point);
        return point;
    }

    public double getNearestPoint(double d2, double d3, Point point) {
        this.d();
        double d4 = Double.POSITIVE_INFINITY;
        Point point2 = new Point();
        d2 -= this.a;
        d3 -= this.e;
        int n2 = 1;
        while (n2 < this.c.length) {
            Utilities.getNearestPointOnSegment(point2, this.c[n2 - 1], this.l[n2 - 1], this.c[n2], this.l[n2], d2, d3);
            double d5 = point2.distanceSq(d2, d3);
            if (d5 < d4) {
                d4 = d5;
                point.setLocation(point2);
            }
            ++n2;
        }
        point.x += this.a;
        point.y += this.e;
        return d4;
    }

    public Path2D toPath2D() {
        if (this.m == null) {
            this.d();
            this.m = new Path2D(){

                @Override
                public double getY() {
                    return TargetLine.this.e;
                }

                @Override
                public double getX() {
                    return TargetLine.this.a;
                }

                @Override
                public double getPointDy(int n2) {
                    return TargetLine.this.l[n2];
                }

                @Override
                public double getPointDx(int n2) {
                    return TargetLine.this.c[n2];
                }

                @Override
                public int getNPoints() {
                    return TargetLine.this.c.length;
                }
            };
        }
        return this.m;
    }
}

