/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.presentation;

import com.anylogic.engine.AbstractShapeGISMap;
import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.AnyLogicInternalCodegenAPI;
import com.anylogic.engine.LengthUnits;
import com.anylogic.engine.Point;
import com.anylogic.engine.Presentable;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.gis.AbstractGISRouteProvider;
import com.anylogic.engine.gis.BuiltInTileCache;
import com.anylogic.engine.gis.GISMultiRegion;
import com.anylogic.engine.gis.IGISRouteProvider;
import com.anylogic.engine.gis.IImageLoadedListener;
import com.anylogic.engine.gis.ITileURLProvider;
import com.anylogic.engine.gis.NominatimSearch;
import com.anylogic.engine.gis.PlainGISRouteProvider;
import com.anylogic.engine.gis.RouteProviderTransportType;
import com.anylogic.engine.gis.RoutingMethod;
import com.anylogic.engine.gis.TileFactory;
import com.anylogic.engine.gis.TileImageProvider;
import com.anylogic.engine.gis.TileURLProviderImpl;
import com.anylogic.engine.gis.YoursOSMRouteProvider;
import com.anylogic.engine.internal.ae;
import com.anylogic.engine.internal.ga;
import com.anylogic.engine.internal.presentation.SharedUtils;
import com.anylogic.engine.internal.presentation.d;
import com.anylogic.engine.internal.presentation.e;
import com.anylogic.engine.internal.presentation.l;
import com.anylogic.engine.internal.t.f;
import com.anylogic.engine.internal.t.gl;
import com.anylogic.engine.internal.t.ha;
import com.anylogic.engine.internal.t.jd;
import com.anylogic.engine.markup.GISMarkupElement;
import com.anylogic.engine.markup.GISNode;
import com.anylogic.engine.markup.GISPoint;
import com.anylogic.engine.markup.GISRegion;
import com.anylogic.engine.markup.GISRoute;
import com.anylogic.engine.presentation.ImageChangedListener;
import com.anylogic.engine.presentation.Panel;
import com.anylogic.engine.presentation.Presentation;
import com.anylogic.engine.presentation.ShapeDrawMode;
import com.anylogic.engine.presentation.UIEventData;
import com.anylogic.engine.presentation.UIEventListener;
import com.anylogic.engine.presentation.UIEventType;
import com.anylogic.engine.presentation.UIPointEventData;
import com.bbn.openmap.Environment;
import com.bbn.openmap.MoreMath;
import com.bbn.openmap.dataAccess.mapTile.MapTileFactory;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.layer.imageTile.MapTileLayer;
import com.bbn.openmap.layer.shape.SpatialIndex;
import com.bbn.openmap.layer.shape.areas.AreaShapeLayer;
import com.bbn.openmap.layer.shape.areas.PoliticalArea;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMList;
import com.bbn.openmap.proj.Cartesian;
import com.bbn.openmap.proj.CartesianLoader;
import com.bbn.openmap.proj.Gnomonic;
import com.bbn.openmap.proj.GnomonicLoader;
import com.bbn.openmap.proj.LLXY;
import com.bbn.openmap.proj.LLXYLoader;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.MercatorLoader;
import com.bbn.openmap.proj.Planet;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionException;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.proj.ProjectionLoader;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ShapeGISMap
extends AbstractShapeGISMap
implements UIEventListener {
    private static final long serialVersionUID = 8850502783383997658L;
    private static final ProjectionFactory am = new ProjectionFactory();
    private Point km;
    private int ba;
    private int ld;
    private transient NominatimSearch cf;
    private static int ea;
    private final IGISRouteProvider gd;
    private boolean fc;
    private transient OMGraphicList jc = new OMGraphicList();
    private transient BufferedImage if;
    private ITileURLProvider aa;
    private double[] nm;
    private transient ProjectionLoader ch;
    private static final UIEventType[] in;
    private transient boolean da;
    private static final String jn = ".shp";
    private static final String kn = ".ssx";
    @AnyLogicCustomSerialization
    private transient Presentable fn;
    private final String hm;
    private double fi = 50.0;
    private double md = 50.0;
    private double li = 1.0;
    private double nd = 1.0;
    private double id;
    private double gk;
    private double lc;
    private final Color nl;
    private final Color mm;
    private final Layer[] nh;
    private transient boolean na = false;
    private transient double ci;
    private transient double bb;
    private transient BufferedImage db;
    private transient Projection kl;
    private transient boolean ia = true;
    private AtomicBoolean ig = new AtomicBoolean();
    private boolean ik = true;
    private transient long ad;
    private volatile transient n nn;
    private volatile transient n cg;
    private transient MapTileLayer fk;
    private Class<? extends Projection> je;
    public static final ITileURLProvider MAPQUEST;
    public static final ITileURLProvider CLASSIC;
    public static final ITileURLProvider GERMANSTYLE;
    public static final ITileURLProvider SATELLITE;
    public static final ITileURLProvider LANDSTAT;
    public static final ITileURLProvider TRANSPORT;
    public static final ITileURLProvider CYCLEMAP;
    public static final AbstractGISRouteProvider STRAIGHT;
    public static Class<? extends Projection> MERCATOR;
    public static Class<? extends Projection> LLXY;
    public static Class<? extends Projection> CARTESIAN;
    public static Class<? extends Projection> GNOMONIC;
    com.anylogic.engine.internal.n<ImageChangedListener> a = new com.anylogic.engine.internal.n();
    private boolean mc = true;
    private transient BufferedImage kj;

    static {
        am.addProjectionLoader((ProjectionLoader)new MercatorLoader());
        am.addProjectionLoader((ProjectionLoader)new LLXYLoader());
        am.addProjectionLoader((ProjectionLoader)new CartesianLoader(){

            public Projection create(Properties properties) throws ProjectionException {
                try {
                    Point2D point2D = (Point2D)properties.get("CENTER");
                    float f2 = PropUtils.floatFromProperties((Properties)properties, (String)"SCALE", (float)1.0E7f);
                    int n2 = PropUtils.intFromProperties((Properties)properties, (String)"HEIGHT", (int)100);
                    int n3 = PropUtils.intFromProperties((Properties)properties, (String)"WIDTH", (int)100);
                    Cartesian cartesian = new Cartesian(point2D, f2, n3, n2){

                        public void init() {
                            super.init();
                            this.scaleFactor = 3.672E8;
                        }
                    };
                    cartesian.setLimits(this.topLimit, this.bottomLimit, this.leftLimit, this.rightLimit, this.limitAnchorPoint);
                    return cartesian;
                }
                catch (Exception exception) {
                    if (Debug.debugging((String)"proj")) {
                        Debug.output((String)("CartesianLoader: problem creating Cartesian projection " + exception.getMessage()));
                    }
                    throw new ProjectionException("CartesianLoader: problem creating Cartesian projection");
                }
            }
        });
        am.addProjectionLoader((ProjectionLoader)new GnomonicLoader());
        ea = 90;
        in = new UIEventType[]{UIEventType.MOUSE_PRESSED, UIEventType.MOUSE_DRAGGED, UIEventType.MOUSE_WHEEL};
        MAPQUEST = new TileURLProviderImpl("MapQuest", "http://otile{rand4N}.mqcdn.com/tiles/1.0.0/osm/{zoom}/{x}/{y}.jpg");
        CLASSIC = new TileURLProviderImpl("OSM classic", "http://{rand4L}.tile.openstreetmap.org/{zoom}/{x}/{y}.png");
        GERMANSTYLE = new TileURLProviderImpl("OSM german", "http://{rand4L}.tile.openstreetmap.de/tiles/osmde/{zoom}/{x}/{y}.png");
        SATELLITE = new TileURLProviderImpl("Satellite", "http://otile{rand4N}.mqcdn.com/tiles/1.0.0/sat/{zoom}/{x}/{y}.png");
        LANDSTAT = new TileURLProviderImpl("LandSat", "http://irs.gis-lab.info/?layers=landsat&request=GetTile&z={zoom}&x={x}&y={y}");
        TRANSPORT = new TileURLProviderImpl("Transport", "http://www.openptmap.org/tiles/{zoom}/{x}/{y}.png");
        CYCLEMAP = new TileURLProviderImpl("Cycle map", "http://{rand4L}.tile.opencyclemap.org/cycle/{zoom}/{x}/{y}.png");
        STRAIGHT = new PlainGISRouteProvider();
        MERCATOR = Mercator.class;
        LLXY = LLXY.class;
        CARTESIAN = Cartesian.class;
        GNOMONIC = Gnomonic.class;
    }

    public ShapeGISMap(Presentable presentable, ShapeDrawMode shapeDrawMode, boolean bl, Class<? extends Projection> clazz, double d2, double d3, double d4, double d5, String string, Layer[] layerArray, double d6, double d7, double d8, Color color, Color color2, boolean bl2, ITileURLProvider iTileURLProvider, IGISRouteProvider iGISRouteProvider, int n2, boolean bl3) {
        this.fn = presentable;
        this.je = clazz;
        this.fc = bl2;
        this.aa = iTileURLProvider;
        this.gd = iGISRouteProvider;
        this.ld = n2;
        if (iGISRouteProvider != null && iGISRouteProvider instanceof AbstractGISRouteProvider) {
            AbstractGISRouteProvider abstractGISRouteProvider = (AbstractGISRouteProvider)iGISRouteProvider;
            abstractGISRouteProvider.setThrowError(bl3);
            abstractGISRouteProvider.setPrecisionInMeters(n2);
        }
        if (layerArray == null) {
            layerArray = new Layer[]{};
        }
        ShapeGISMap.a(presentable.getPresentation());
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        this.hm = string;
        this.aj = bl;
        this.nj = d2;
        this.dk = d3;
        this.fi = d4;
        this.md = d5;
        this.id = ShapeGISMap.a(d7);
        this.gk = ShapeGISMap.h(d6);
        this.lc = d8;
        this.nh = layerArray;
        this.nl = color;
        this.mm = color2;
        this.i();
        this.a(clazz, d6, d7, d4, d5, 1.0 / d8);
        SharedUtils.setProxySettings();
        this.ai();
    }

    public ShapeGISMap(Presentable presentable, ShapeDrawMode shapeDrawMode, boolean bl, double d2, double d3, double d4, double d5, String string, Layer[] layerArray, double d6, double d7, double d8, Color color, Color color2, boolean bl2, ITileURLProvider iTileURLProvider, IGISRouteProvider iGISRouteProvider, int n2, boolean bl3, ProjectionLoader projectionLoader) {
        this(presentable, shapeDrawMode, bl, projectionLoader.getProjectionClass(), d2, d3, d4, d5, string, layerArray, d6, d7, d8, color, color2, bl2, iTileURLProvider, iGISRouteProvider, n2, bl3);
        am.addProjectionLoader(projectionLoader);
        this.a(this.je, d6, d7, d4, d5, 1.0 / d8);
    }

    private void a(Class<? extends Projection> clazz, double d2, double d3, double d4, double d5, double d6) {
        Projection projection = ShapeGISMap.makeProjection(clazz, d2, d3, d6, (int)d4, (int)d5);
        Point2D point2D = projection.inverse(0.0, d5);
        Point2D point2D2 = projection.inverse(d4, 0.0);
        this.nm = new double[4];
        this.setSearchBounds(point2D.getY(), point2D.getX(), point2D2.getY(), point2D2.getX());
    }

    private void i() {
        this.fk = new MapTileLayer();
        TileImageProvider tileImageProvider = new TileImageProvider(new BuiltInTileCache(this.aa));
        TileFactory tileFactory = new TileFactory(tileImageProvider);
        this.fk.setTileFactory((MapTileFactory)tileFactory);
        tileImageProvider.addImageLoadedListener(new IImageLoadedListener(){
            private static final long serialVersionUID = 6588694594262395619L;

            @Override
            public void imageLoaded() {
                boolean bl = ShapeGISMap.this.ig.getAndSet(true);
                if (!bl) {
                    ShapeGISMap.this.a((int)(ShapeGISMap.this.fi / ShapeGISMap.this.li), (int)(ShapeGISMap.this.md / ShapeGISMap.this.nd));
                }
            }
        });
    }

    @Deprecated
    public ShapeGISMap(Presentable presentable, boolean bl, double d2, double d3, double d4, double d5, String string, Layer[] layerArray, double d6, double d7, double d8, Color color, Color color2) {
        this(presentable, ShapeDrawMode.SHAPE_DRAW_2D, bl, MERCATOR, d2, d3, d4, d5, string, layerArray, d7, d6, d8, color, color2, true, MAPQUEST, new YoursOSMRouteProvider(presentable, string, RouteProviderTransportType.CAR, RoutingMethod.FASTEST), 1000, false);
    }

    private Point a(Panel panel, MouseEvent mouseEvent) {
        double d2 = mouseEvent.getX() - panel.xToScreen(this.getX());
        double d3 = mouseEvent.getY() - panel.yToScreen(this.getY());
        return new Point(d2, d3);
    }

    private Point a(Point point, Projection projection) {
        Point2D point2D = projection.inverse(point.x, point.y);
        return new Point(point2D.getY(), point2D.getX());
    }

    private boolean a(Point point, Panel panel) {
        return point.x >= 0.0 && point.x <= this.fi * panel.getZoom() && point.y >= 0.0 && point.y <= this.md * panel.getZoom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void n() {
        if (this.na) {
            return;
        }
        Layer[] layerArray = this.nh;
        synchronized (this.nh) {
            if (this.na) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.m();
            this.na = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void m() {
        if (this.nh == null) {
            throw new IllegalArgumentException(ae.hka);
        }
        double d2 = Double.MIN_VALUE;
        double d3 = Double.MAX_VALUE;
        Layer[] layerArray = this.nh;
        int n2 = this.nh.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            Layer layer = layerArray[n3];
            if (layer.c != null) {
                throw new RuntimeException(ae.gef);
            }
            layer.c = this;
            String string = ga.a(this.fn, this.hm, layer.a);
            if (this.fn.getPresentation() == null || this.fn.getPresentation().getMode() != Presentation.MODE_APPLET) {
                try {
                    SpatialIndex.locateAndSetShapeData((String)string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if ((n4 = string.length() - jn.length()) < 0 || !jn.equalsIgnoreCase(string.substring(n4))) {
                throw new IllegalArgumentException(String.format(ae.hha, jn, string));
            }
            d d4 = new d();
            Properties properties = new Properties();
            properties.setProperty("shapeFile", string);
            string.substring(0, string.length() - jn.length());
            String string2 = layer.e;
            if (string2 != null && BinaryFile.exists((String)(string2 = ga.a(this.fn, this.hm, string2)))) {
                properties.setProperty("dbfFile", string2);
            }
            String string3 = String.valueOf(layer.d);
            properties.setProperty("nameIndex", string3);
            properties.setProperty("keyIndex", string3);
            properties.setProperty("lineColor", ShapeGISMap.a(layer.h));
            properties.setProperty("fillColor", ShapeGISMap.a(layer.k));
            d4.setProperties(properties);
            d2 = Math.max(d2, (double)d4.getMinScale());
            d3 = Math.min(d3, (double)d4.getMaxScale());
            DrawingAttributes.DEFAULT.setProperties((Properties)properties.clone());
            layer.j = d4;
            ++n3;
        }
        this.ci = 1.0 / d3;
        this.bb = 1.0 / d2;
    }

    private static String a(Color color) {
        if (color == null) {
            return "00000000";
        }
        return Integer.toHexString(color.getRGB());
    }

    public void setWidth(double d2) {
        if (d2 == this.fi) {
            return;
        }
        this.fi = d2;
        this.a(hl);
        this.b();
    }

    public double getWidth() {
        return this.fi;
    }

    public void setHeight(double d2) {
        if (d2 == this.md) {
            return;
        }
        this.md = d2;
        this.a(hl);
        this.b();
    }

    public double getHeight() {
        return this.md;
    }

    @Override
    @AnyLogicInternalCodegenAPI
    public boolean onClickAt(double d2, double d3, boolean bl) {
        double d4;
        if (!this.canHandleClick(bl)) {
            this.di = false;
            return false;
        }
        double d5 = com.anylogic.engine.internal.presentation.e.a(d2, d3, this.nj, this.dk, this.ec, this.mj);
        this.di = com.anylogic.engine.internal.presentation.e.e(d5, d4 = com.anylogic.engine.internal.presentation.e.e(d2, d3, this.nj, this.dk, this.ec, this.ic), this.fi, this.md);
        if (this.di) {
            this.g();
            Point2D.Double double_ = new Point2D.Double();
            this.kl.inverse(d5 / this.li, d4 / this.nd, (Point2D)double_);
            double d6 = double_.y;
            double d7 = double_.x;
            if (Math.abs(d7) > 180.0) {
                d7 = ShapeGISMap.a(d7);
            }
            if (Math.abs(d6) > 90.0) {
                d6 = ShapeGISMap.h(d6);
            }
            return this.onClick(d6, d7);
        }
        return false;
    }

    private void a(double d2, double d3, Point point) {
        Point2D.Double double_ = new Point2D.Double();
        this.kl.inverse(d2, d3, (Point2D)double_);
        point.x = double_.x;
        point.y = double_.y;
    }

    private void e(double d2, double d3, Point point) {
        Point2D.Double double_ = new Point2D.Double();
        this.kl.forward(d2, d3, (Point2D)double_);
        point.x = double_.x;
        point.y = double_.y;
    }

    @Override
    public void updateDynamicProperties(boolean bl) {
        if (!this.a(bl)) {
            return;
        }
        this.a(this.jc, bl);
    }

    private void a(OMGraphicList oMGraphicList, boolean bl) {
        for (OMGraphic oMGraphic : oMGraphicList) {
            GISMarkupElement gISMarkupElement = GISMarkupElement.getFromOMGraphic(oMGraphic);
            if (gISMarkupElement != null) {
                gISMarkupElement.updateDynamicProperties(bl);
            }
            if (!(oMGraphic instanceof OMList)) continue;
            this.a((OMGraphicList)oMGraphic, bl);
        }
    }

    @Override
    public boolean contains(double d2, double d3) {
        double d4 = com.anylogic.engine.internal.presentation.e.a(d2, d3, this.nj, this.dk, this.ec, this.mj);
        double d5 = com.anylogic.engine.internal.presentation.e.e(d2, d3, this.nj, this.dk, this.ec, this.ic);
        return com.anylogic.engine.internal.presentation.e.e(d4, d5, this.fi, this.md);
    }

    @Override
    public void draw(Panel panel, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl) {
        int n2;
        double d2;
        int n3;
        if (!this.e(bl)) {
            return;
        }
        if (this.fi == 0.0 || this.md == 0.0) {
            return;
        }
        com.anylogic.engine.internal.presentation.e.a(graphics2D, affineTransform, this.nj, this.dk, this.ec, this.mj, this.ic);
        double d3 = 1.0;
        AffineTransform affineTransform2 = graphics2D.getTransform();
        double[] dArray = com.anylogic.engine.internal.presentation.e.n.get();
        affineTransform2.transform(dArray, 0, dArray, 6, 3);
        double d4 = Utilities.getLength(dArray[8] - dArray[6], dArray[9] - dArray[7]);
        double d5 = Utilities.getLength(dArray[10] - dArray[6], dArray[11] - dArray[7]);
        if (d4 < 1.0 || d5 < 1.0) {
            if (d4 == d5) {
                d5 = 1.0;
                d4 = 1.0;
            } else if (d4 < d5) {
                d5 /= d4;
                d4 = 1.0;
            } else {
                d4 /= d5;
                d5 = 1.0;
            }
        }
        double d6 = d4 * this.fi;
        double d7 = d5 * this.md;
        while (!this.a(n3 = Utilities.roundToInt((d2 = Math.sqrt(d3)) * d6), n2 = Utilities.roundToInt(d2 * d7))) {
            d3 /= 1.5;
        }
        this.li = this.fi / (double)this.db.getWidth();
        this.nd = this.md / (double)this.db.getHeight();
        this.hn();
        int n4 = (int)this.fi;
        int n5 = (int)this.md;
        Rectangle2D.Double double_ = null;
        if (this.mm != null) {
            double_ = com.anylogic.engine.internal.presentation.e.l.get();
            double_.setRect(0.0, 0.0, this.fi, this.md);
            graphics2D.setColor(this.mm);
            graphics2D.fill(double_);
        }
        if (this.fc) {
            graphics2D.drawImage(this.if, 0, 0, n4, n5, null);
        }
        graphics2D.drawImage(this.db, 0, 0, n4, n5, null);
        if (this.kl != null) {
            SharedUtils.drawGISRuler(graphics2D, this.kl, n4, n5 ^ SharedUtils.class.hashCode(), this.li);
        }
        if (this.nl != null) {
            if (double_ == null) {
                double_ = com.anylogic.engine.internal.presentation.e.l.get();
                double_.setRect(0.0, 0.0, this.fi, this.md);
            }
            graphics2D.setColor(this.nl);
            graphics2D.draw(double_);
        }
        if (this.mc && panel != null) {
            panel.getUIEventsManager().confirmUIEventListener(this);
        }
    }

    @Override
    public double getMapScale() {
        return this.lc;
    }

    @Override
    public void setMapScale(double d2) {
        d2 = Math.min(this.getMaxMapScale(), Math.max(this.getMinMapScale(), d2));
        if (d2 != this.lc) {
            this.lc = d2;
            this.b();
            this.a(fb);
        }
    }

    @Override
    public double getMinMapScale() {
        this.g();
        return Math.max(this.ci, 1.0 / (double)this.kl.getMaxScale() * (this.fi / (double)this.kl.getWidth()));
    }

    @Override
    public double getMaxMapScale() {
        this.g();
        return Math.min(this.bb, 1.0 / (double)this.kl.getMinScale() * (this.fi / (double)this.kl.getWidth()));
    }

    @Override
    public void zoomIn() {
        this.di();
        this.setMapScale(this.getMapScale() * 2.0);
    }

    @Override
    public void zoomOut() {
        this.di();
        this.setMapScale(this.getMapScale() / 2.0);
    }

    @Override
    public void pan(double d2, double d3) {
        double d4;
        this.g();
        java.awt.Point point = new java.awt.Point();
        LatLonPoint.Double double_ = new LatLonPoint.Double();
        double d5 = this.id;
        double d6 = this.gk;
        if (d2 != 0.0) {
            point.setLocation(d2 > 0.0 ? this.db.getWidth() - 1 : 0, this.db.getHeight() / 2);
            this.kl.inverse((Point2D)point, (Point2D)double_);
            d4 = (double)double_.getLongitude() - this.id;
            if (d2 > 0.0 && d4 < 0.0) {
                d4 += 360.0;
            } else if (d2 < 0.0 && d4 > 0.0) {
                d4 -= 360.0;
            }
            d5 = this.id + (d4 /= 2.0) * Math.abs(d2);
        }
        if (d3 != 0.0) {
            point.setLocation(this.db.getWidth() / 2, d3 > 0.0 ? 0 : this.db.getHeight() - 1);
            this.kl.inverse((Point2D)point, (Point2D)double_);
            d4 = ((double)double_.getLatitude() - this.gk) / 2.0;
            d6 = this.gk + d4 * Math.abs(d3);
        }
        this.setProjectionCenter(d6, d5);
    }

    @Override
    public double getCenterLatitude() {
        return this.gk;
    }

    @Override
    public double getCenterLongitude() {
        return this.id;
    }

    @Override
    public void setProjectionCenter(double d2, double d3) {
        this.a(d2, d3, true);
    }

    private void a(double d2, double d3, boolean bl) {
        this.di();
        d2 = ShapeGISMap.h(d2);
        d3 = ShapeGISMap.a(d3);
        if (d3 != this.id || d2 != this.gk) {
            this.id = d3;
            this.gk = this.e(d2);
            if (bl) {
                this.b();
            }
        }
    }

    private double e(double d2) {
        if (d2 > (double)ea) {
            d2 = ea;
        } else if (d2 < (double)(-ea)) {
            d2 = -ea;
        }
        return d2;
    }

    @Override
    public void setCenterLatitude(double d2) {
        if ((d2 = ShapeGISMap.h(d2)) != this.gk) {
            this.gk = this.e(d2);
            this.b();
            this.a(fb);
        }
    }

    @Override
    public void setCenterLongitude(double d2) {
        if ((d2 = ShapeGISMap.a(d2)) != this.id) {
            this.id = d2;
            this.b();
            this.a(fb);
        }
    }

    @Override
    public double convertXForward(double d2, double d3) {
        n n2 = this.e(d2, d3);
        return n2.x * this.li;
    }

    @Override
    public double convertYForward(double d2, double d3) {
        n n2 = this.e(d2, d3);
        return n2.y * this.nd;
    }

    @Override
    public Point convertForward(double d2, double d3) {
        n n2 = this.e(d2, d3);
        return new Point(n2.x * this.li, n2.y * this.nd);
    }

    @Override
    public Point convertForward(double d2, double d3, Point point) {
        if (point == null) {
            point = new Point();
        }
        this.g();
        this.e(d2, d3, point);
        point.x *= this.li;
        point.y *= this.nd;
        return point;
    }

    @Override
    public double convertRotationAngleForward(double d2, double d3, double d4) {
        return -d4;
    }

    @Override
    public double convertXInverse(double d2, double d3) {
        n n2 = this.a(d2, d3);
        return n2.x;
    }

    @Override
    public double convertYInverse(double d2, double d3) {
        n n2 = this.a(d2, d3);
        return n2.y;
    }

    @Override
    public Point convertInverse(double d2, double d3) {
        n n2 = this.a(d2, d3);
        return new Point(n2);
    }

    @Override
    public Point convertInverse(double d2, double d3, Point point) {
        if (point == null) {
            point = new Point();
        }
        this.g();
        this.a(d2 / this.li, d3 / this.nd, point);
        return point;
    }

    private n a(double d2, double d3) {
        return this.h(d2 / this.li, d3 / this.nd);
    }

    @Override
    public double convertRotationAngleInverse(double d2, double d3, double d4) {
        return -d4;
    }

    @Override
    public boolean projectionContains(double d2, double d3) {
        n n2 = this.e(d2, d3);
        return n2.x >= 0.0 && n2.x < (double)this.kl.getWidth() && n2.y >= 0.0 && n2.y < (double)this.kl.getHeight();
    }

    @Override
    @Deprecated
    public float[] createTrajectory(double d2, double d3, double d4, double d5, int n2) {
        return Utilities.createTrajectoryGIS(d2, d3, d4, d5, n2);
    }

    @Override
    public double getDistance(double d2, double d3, double d4, double d5) {
        return Utilities.getDistanceGIS(d2, d3, d4, d5);
    }

    @Override
    public double getDistanceByRoute(double d2, double d3, double d4, double d5) {
        return this.getRouteProvider().getDistance(d2, d3, d4, d5);
    }

    public Layer[] getLayers() {
        this.n();
        return this.nh;
    }

    public void requestRedraw() {
        this.b();
    }

    public void destroy() {
        Layer[] layerArray = this.nh;
        int n2 = this.nh.length;
        int n3 = 0;
        while (n3 < n2) {
            SpatialIndex spatialIndex;
            Layer layer = layerArray[n3];
            AreaShapeLayer areaShapeLayer = layer.getLayerObject();
            if (areaShapeLayer != null && (spatialIndex = areaShapeLayer.getSpatialIndex()) != null) {
                spatialIndex.close(true);
            }
            ++n3;
        }
    }

    @Override
    @AnyLogicInternalAPI
    public void setUIEventListenerConfirmed(boolean bl) {
        this.da = bl;
    }

    @Override
    @AnyLogicInternalAPI
    public boolean isUIEventListenerConfirmed() {
        return this.da;
    }

    @Override
    @AnyLogicInternalAPI
    public UIEventType[] getUIEventSubscriptions() {
        return in;
    }

    @Override
    @AnyLogicInternalAPI
    public void uiEventOccurred(UIEventData<?> uIEventData) {
        if (!(uIEventData instanceof UIPointEventData)) {
            return;
        }
        UIPointEventData uIPointEventData = (UIPointEventData)uIEventData;
        double d2 = uIPointEventData.getX();
        double d3 = uIPointEventData.getY();
        double d4 = com.anylogic.engine.internal.presentation.e.a(d2, d3, this.nj, this.dk, this.ec, this.mj);
        double d5 = com.anylogic.engine.internal.presentation.e.e(d2, d3, this.nj, this.dk, this.ec, this.ic);
        uIPointEventData.setXY(d4, d5);
        switch (uIEventData.getType()) {
            case MOUSE_PRESSED: {
                if (this.contains(d2, d3)) {
                    uIPointEventData = (UIPointEventData)uIEventData;
                    MouseEvent mouseEvent = (MouseEvent)uIPointEventData.getOriginalData();
                    this.ba = mouseEvent.getButton();
                    this.km = new Point(uIPointEventData.getX(), uIPointEventData.getY());
                    break;
                }
                this.km = null;
                break;
            }
            case MOUSE_DRAGGED: {
                if (this.km == null) break;
                if (this.ba != 1) {
                    return;
                }
                uIPointEventData = (UIPointEventData)uIEventData;
                Point point = new Point(uIPointEventData.getX(), uIPointEventData.getY());
                double d6 = this.km.x - point.x;
                double d7 = this.km.y - point.y;
                Point2D point2D = this.kl.forward(this.gk, this.id);
                point2D.setLocation(point2D.getX() + d6, point2D.getY() + d7);
                Point2D point2D2 = this.kl.inverse(point2D.getX(), point2D.getY());
                this.setProjectionCenter(point2D2.getY(), point2D2.getX());
                this.km = point;
                break;
            }
            case MOUSE_WHEEL: {
                if (!this.contains(d2, d3)) break;
                uIPointEventData = (UIPointEventData)uIEventData;
                MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)uIPointEventData.getOriginalData();
                this.ba = mouseWheelEvent.getButton();
                this.km = new Point(uIPointEventData.getX(), uIPointEventData.getY());
                if (mouseWheelEvent.isControlDown()) {
                    return;
                }
                Point point = new Point(uIPointEventData.getX(), uIPointEventData.getY());
                if (mouseWheelEvent.getWheelRotation() > 0) {
                    this.zoomOut();
                    break;
                }
                Point point2 = this.a(point, this.kl);
                this.a((point2.getLatitude() + this.gk) / 2.0, (point2.getLongitude() + this.id) / 2.0, false);
                this.zoomIn();
            }
        }
    }

    private static void a(Presentation presentation) {
        Applet applet;
        Applet applet2 = applet = presentation != null && presentation.getMode() == Presentation.MODE_APPLET && presentation.getContainer() instanceof Applet ? (Applet)presentation.getContainer() : null;
        if (applet != Environment.getApplet()) {
            ShapeGISMap.a(applet);
        } else if (Environment.getProperties() == null) {
            ShapeGISMap.a(applet);
        }
    }

    private static void a(Applet applet) {
        if (applet != null) {
            Environment.init((Applet)applet);
        } else {
            Environment.init();
        }
    }

    private n e(double d2, double d3) {
        n n2 = this.nn;
        if (!n2.a(d2, d3)) {
            this.g();
            n2 = new n(d2, d3);
            this.e(d2, d3, n2);
            this.nn = n2;
        }
        return n2;
    }

    private n h(double d2, double d3) {
        n n2 = this.cg;
        if (!n2.a(d2, d3)) {
            this.g();
            n2 = new n(d2, d3);
            this.a(d2, d3, n2);
            this.cg = n2;
        }
        return n2;
    }

    private static double h(double d2) {
        return Math.max(-90.0, Math.min(90.0, d2));
    }

    private boolean a(int n2, int n3) {
        boolean bl = !this.ia && this.kl != null && Math.abs(this.kl.getWidth() - n2) <= 1 && Math.abs(this.kl.getHeight() - n3) <= 1;
        boolean bl2 = this.ig.get();
        if (!(!bl || this.ik || this.fc && bl2)) {
            return true;
        }
        this.n();
        if ((long)n2 * (long)n3 >= this.ad) {
            return false;
        }
        try {
            if (!bl) {
                Projection projection = this.e(n2, n3);
                this.e(projection, n2, n3);
                this.a(projection, n2, n3);
                this.kl = projection;
                this.ia = false;
                this.hn();
            } else {
                if (bl2) {
                    this.e(this.kl, n2, n3);
                }
                if (this.ik) {
                    this.a(this.kl, n2, n3);
                }
            }
            this.aj();
            return true;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.ad = Math.min(this.ad, (long)(n2 * n3));
            return false;
        }
    }

    private void a(Projection projection, int n2, int n3) {
        BufferedImage bufferedImage = ga.a(n2, n3, true);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            this.a(projection, graphics2D);
            this.a(projection, graphics2D, true);
        }
        finally {
            graphics2D.dispose();
        }
        this.db = bufferedImage;
    }

    private Projection e(int n2, int n3) {
        double d2 = 1.0 / this.lc * (this.fi / (double)n2);
        Class clazz = this.ch != null ? this.ch.getProjectionClass() : this.je;
        Projection projection = ShapeGISMap.makeProjection(clazz, this.gk, this.id, d2, n2, n3);
        return projection;
    }

    @AnyLogicInternalAPI
    public static Projection makeProjection(Class<? extends Projection> clazz, double d2, double d3, double d4, int n2, int n3) {
        return am.makeProjection(clazz, (Point2D)new LatLonPoint.Double(d2, d3), (float)d4, n2, n3);
    }

    private void e(Projection projection, int n2, int n3) {
        if (!this.fc) {
            return;
        }
        BufferedImage bufferedImage = ga.a(n2, n3, true);
        this.fk.setProjection(projection.makeClone());
        OMGraphicList oMGraphicList = this.fk.prepare();
        this.fk.setList(oMGraphicList);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            oMGraphicList.render((Graphics)graphics2D);
        }
        finally {
            graphics2D.dispose();
        }
        this.if = bufferedImage;
        TileImageProvider tileImageProvider = this.bj();
        if (tileImageProvider == null || !tileImageProvider.isLoading()) {
            this.ig.set(false);
            this.a(fb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Projection projection, Graphics2D graphics2D, boolean bl) {
        OMGraphicList oMGraphicList = this.jc;
        synchronized (oMGraphicList) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (bl) {
                this.jc.generate(projection.makeClone());
            }
            this.jc.render((Graphics)graphics2D);
            this.ik = false;
        }
    }

    private void a(Projection projection, Graphics2D graphics2D) {
        Layer[] layerArray = this.nh;
        int n2 = this.nh.length;
        int n3 = 0;
        while (n3 < n2) {
            Layer layer = layerArray[n3];
            if (layer.l) {
                d d2 = layer.j;
                d2.setProjection(projection.makeClone());
                OMGraphicList oMGraphicList = d2.prepare();
                d2.setList(oMGraphicList);
                oMGraphicList.render((Graphics)graphics2D);
            }
            ++n3;
        }
    }

    private synchronized void g() {
        if (this.ia && !this.a((int)(this.fi / this.li), (int)(this.md / this.nd))) {
            throw new RuntimeException("Internal error when trying to create projection");
        }
    }

    private void b() {
        this.ia = true;
        this.hn();
    }

    @Override
    public Presentable getPresentable() {
        return this.fn;
    }

    @Override
    @Deprecated
    @AnyLogicInternalCodegenAPI
    public void restoreOwner(Object object) {
        if (object instanceof Presentable) {
            this.fn = (Presentable)object;
        } else {
            super.restoreOwner(object);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (OMGraphic oMGraphic : this.jc) {
            GISMarkupElement gISMarkupElement = GISMarkupElement.getFromOMGraphic(oMGraphic);
            if (gISMarkupElement == null) continue;
            objectOutputStream.writeObject(gISMarkupElement);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.ai();
        this.i();
        this.kl = this.e((int)this.fi, (int)this.md);
        this.ia = true;
        this.jc = new OMGraphicList();
        while ((object = objectInputStream.readObject()) instanceof GISMarkupElement) {
            this.add((GISMarkupElement)object);
        }
    }

    private void ai() {
        this.ad = Long.MAX_VALUE;
        this.hn();
        this.cf = new NominatimSearch(this, this.hm);
        this.cf.setPrecisionInMeters(this.ld);
    }

    private void hn() {
        this.nn = new n(Double.NaN, Double.NaN);
        this.cg = new n(-2.147483648E9, -2.147483648E9);
    }

    public List<GISNode> search(String string, boolean bl, boolean bl2) {
        if (bl2) {
            double[] dArray = this.gf();
            return this.cf.search(string, bl, dArray[0], dArray[1], dArray[2], dArray[3]);
        }
        return this.cf.search(string, bl);
    }

    public List<GISPoint> search(String string) {
        double[] dArray = this.gf();
        return this.cf.search(string, dArray[0], dArray[1], dArray[2], dArray[3], false);
    }

    public List<GISRegion> searchRegion(String string) {
        double[] dArray = this.gf();
        return this.cf.searchRegion(string, dArray[0], dArray[1], dArray[2], dArray[3], false);
    }

    public List<GISMultiRegion> searchMultiRegion(String string) {
        double[] dArray = this.gf();
        return this.cf.searchMultiRegion(string, dArray[0], dArray[1], dArray[2], dArray[3], false);
    }

    @Override
    public GISPoint searchFirst(String string) {
        double[] dArray = this.gf();
        List list = this.cf.search(string, dArray[0], dArray[1], dArray[2], dArray[3], true);
        if (list.size() > 0) {
            return (GISPoint)list.get(0);
        }
        return null;
    }

    public GISRegion searchFirstRegion(String string) {
        double[] dArray = this.gf();
        List list = this.cf.searchRegion(string, dArray[0], dArray[1], dArray[2], dArray[3], true);
        if (list.size() > 0) {
            return (GISRegion)list.get(0);
        }
        return null;
    }

    public GISMultiRegion searchFirstMultiRegion(String string) {
        double[] dArray = this.gf();
        List<GISMultiRegion> list = this.cf.searchMultiRegion(string, dArray[0], dArray[1], dArray[2], dArray[3], true);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    private double[] gf() {
        return this.nm;
    }

    public void setLayerVisibility(String string, boolean bl) {
        Layer[] layerArray = this.nh;
        int n2 = this.nh.length;
        int n3 = 0;
        while (n3 < n2) {
            Layer layer = layerArray[n3];
            if (layer.a.equals(string)) {
                if (layer.isVisible() != bl) {
                    layer.setVisible(bl);
                    this.ik = true;
                }
                return;
            }
            ++n3;
        }
    }

    private void di() {
        TileImageProvider tileImageProvider = this.bj();
        if (tileImageProvider != null) {
            tileImageProvider.cancelLoading();
        }
    }

    private TileImageProvider bj() {
        if (!this.fc) {
            return null;
        }
        TileImageProvider tileImageProvider = null;
        if (this.fk.getTileFactory() instanceof TileFactory) {
            TileFactory tileFactory = (TileFactory)this.fk.getTileFactory();
            tileImageProvider = tileFactory.getTileImageProvider();
        }
        return tileImageProvider;
    }

    @Override
    @AnyLogicInternalAPI
    public IGISRouteProvider getRouteProvider() {
        return this.gd;
    }

    @Override
    public GISRoute getRoute(GISPoint gISPoint, GISPoint gISPoint2) {
        return new GISRoute(this, this.gd.getPathData(gISPoint.getLatitude(), gISPoint.getLongitude(), gISPoint2.getLatitude(), gISPoint2.getLongitude()), gISPoint, gISPoint2, false);
    }

    @Override
    public GISRoute getRoute(double d2, double d3, double d4, double d5) {
        return new GISRoute(this, this.gd.getPathData(d2, d3, d4, d5));
    }

    @AnyLogicInternalAPI
    public void addImageChangedListener(ImageChangedListener imageChangedListener) {
        this.a.a(imageChangedListener);
    }

    @AnyLogicInternalAPI
    public void removeImageChangedListener(ImageChangedListener imageChangedListener) {
        this.a.e(imageChangedListener);
    }

    private void aj() {
        for (ImageChangedListener imageChangedListener : this.a) {
            imageChangedListener.imageChanged();
        }
    }

    @Override
    public double getMPP() {
        return 1.0 / this.lc / (double)SharedUtils.getPPM(this.kl) / 2.0;
    }

    @AnyLogicInternalAPI
    public void onMarkupChanged() {
        if (!this.ik) {
            this.ik = true;
        }
    }

    public void add(GISMarkupElement gISMarkupElement) {
        OMGraphic oMGraphic = gISMarkupElement.getOmGraphic(true);
        oMGraphic.generate(this.kl);
        boolean bl = this.jc.add(oMGraphic);
        if (bl) {
            this.onMarkupChanged();
        }
    }

    public void remove(GISMarkupElement gISMarkupElement) {
        boolean bl = this.jc.remove((Object)gISMarkupElement.getOmGraphic(false));
        if (bl) {
            this.onMarkupChanged();
        }
    }

    public void add(GISMultiRegion gISMultiRegion) {
        boolean bl = false;
        for (GISRegion gISRegion : gISMultiRegion) {
            OMGraphic oMGraphic = gISRegion.getOmGraphic(true);
            oMGraphic.generate(this.kl);
            boolean bl2 = bl = this.jc.add(oMGraphic) || bl;
        }
        if (bl) {
            this.onMarkupChanged();
        }
    }

    public void remove(GISMultiRegion gISMultiRegion) {
        boolean bl = false;
        for (GISRegion gISRegion : gISMultiRegion) {
            boolean bl2 = bl = this.jc.remove((Object)gISRegion.getOmGraphic(false)) || bl;
        }
        if (bl) {
            this.onMarkupChanged();
        }
    }

    public double toLengthUnits(double d2, LengthUnits lengthUnits) {
        return LengthUnits.METER.convertTo(d2, lengthUnits);
    }

    public double fromLengthUnits(double d2, LengthUnits lengthUnits) {
        return lengthUnits.convertTo(d2, LengthUnits.METER);
    }

    public void setSearchBounds(double d2, double d3, double d4, double d5) {
        this.nm[0] = d2;
        this.nm[1] = d3;
        this.nm[2] = d4;
        this.nm[3] = d5;
    }

    public boolean isMouseNavigationEnabled() {
        return this.mc;
    }

    public void setMouseNavigationEnabled(boolean bl) {
        this.mc = bl;
    }

    public void fitBounds(double d2, double d3, double d4, double d5) {
        double d6 = MoreMath.asinh((double)Math.tan(Math.toRadians(d2)));
        double d7 = MoreMath.asinh((double)Math.tan(Math.toRadians(d4)));
        double d8 = this.md / (d7 - d6);
        double d9 = (double)Planet.defaultPixelsPerMeter * 6378137.0 / d8;
        double d10 = this.md / 2.0 / d8 + d6;
        double d11 = Math.toDegrees(Math.atan((Math.exp(2.0 * d10) - 1.0) / (2.0 * Math.exp(d10))));
        if (d3 >= d5) {
            d5 += 360.0;
        }
        double d12 = Math.round(d3 * Math.pow(10.0, 4.0)) == Math.round(d5 * Math.pow(10.0, 4.0)) ? (d5 > 90.0 ? d5 - 90.0 : (d5 < -90.0 ? d5 + 90.0 : d5)) : (d3 + d5) / 2.0;
        if (d12 > 180.0) {
            d12 -= 360.0;
        }
        this.a(d11, d12, false);
        this.setMapScale(1.0 / d9);
    }

    @Override
    protected int h() {
        return super.h() + 2;
    }

    @Override
    protected f[] k() {
        f[] fArray = super.k();
        int n2 = super.h();
        fArray[n2++] = this.nj();
        fArray[n2] = this.dk();
        return fArray;
    }

    @Override
    protected void a(jd jd2) {
        super.a(jd2);
        if (this.e(hl)) {
            jd2.a(this.nj());
        }
        if (this.e(fb)) {
            jd2.a(this.dk());
        }
    }

    private f nj() {
        return new ha(this, (float)this.fi, (float)this.md);
    }

    private f dk() {
        double d2 = this.getPresentable().getPresentation().getPanel().getZoom();
        int n2 = (int)(this.fi * d2);
        int n3 = (int)(this.md * d2);
        if (this.kj == null || this.kj.getWidth() != n2 || this.kj.getHeight() != n3) {
            this.kj = ga.a(n2, n3, true);
        }
        Graphics2D graphics2D = this.kj.createGraphics();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(d2, d2);
        affineTransform.translate(-this.nj, -this.dk);
        try {
            graphics2D.clearRect(0, 0, n2, n3);
            this.draw(null, graphics2D, affineTransform, true);
        }
        finally {
            graphics2D.dispose();
        }
        return new gl(this, this.kj);
    }

    @Override
    @AnyLogicInternalAPI
    public void setContextReference_xjal(Presentable presentable) {
    }

    private static class n
    extends Point {
        private static final long serialVersionUID = 5617126723210331856L;
        private final double a;
        private final double e;

        private n(double d2, double d3) {
            this.a = d2;
            this.e = d3;
        }

        private boolean a(double d2, double d3) {
            return this.a == d2 && this.e == d3;
        }
    }

    public static class Layer
    implements Serializable {
        private static final long serialVersionUID = -7736077865162188752L;
        private final String a;
        private final String e;
        private final Color h;
        private final Color k;
        private final int d;
        private transient d j;
        private transient ShapeGISMap c;
        private boolean l;

        public Layer(String string, String string2, Color color, Color color2, int n2, boolean bl) {
            this.a = string;
            this.e = string2;
            this.h = color;
            this.k = color2;
            this.d = n2;
            this.l = bl;
        }

        public Collection<PoliticalArea> getPoliticalAreas() {
            return this.j.a().a();
        }

        public PoliticalArea findPoliticalArea(String string) {
            return this.j.a().findPoliticalArea(string);
        }

        public PoliticalArea[] findPoliticalAreas(double d2, double d3) {
            return this.j.a().a(d2, d3, this.j.getProjection());
        }

        public PoliticalArea findPoliticalArea(double d2, double d3) {
            return this.j.a().e(d2, d3, this.j.getProjection());
        }

        public OMGraphicList getObjects(double d2, double d3) {
            this.a();
            l l2 = this.j.a();
            if (l2 != null) {
                return l2.getGraphics(d2, d3 - (double)5.0E-4f, d2, d3 + (double)5.1E-4f, this.j.getProjection());
            }
            return new OMGraphicList();
        }

        public OMGraphicList getObjects(String string) {
            OMGraphicList oMGraphicList;
            this.a();
            l l2 = this.j.a();
            OMGraphicList oMGraphicList2 = new OMGraphicList();
            if (l2 != null && (oMGraphicList = l2.getGraphics()) != null) {
                int n2 = 1;
                while (n2 <= oMGraphicList.size()) {
                    String string2 = l2.getName(n2);
                    if (string2 != null && string2.equalsIgnoreCase(string)) {
                        OMGraphic oMGraphic = oMGraphicList.getOMGraphicAt(n2 - 1);
                        if (oMGraphic instanceof OMGraphicList) {
                            OMGraphicList oMGraphicList3 = (OMGraphicList)oMGraphic;
                            int n3 = 0;
                            while (n3 < oMGraphicList3.size()) {
                                oMGraphicList2.add(oMGraphicList3.getOMGraphicAt(n3));
                                ++n3;
                            }
                        } else {
                            oMGraphicList2.add(oMGraphic);
                        }
                    }
                    ++n2;
                }
            }
            return oMGraphicList2;
        }

        public AreaShapeLayer getLayerObject() {
            this.a();
            return this.j;
        }

        private void a() {
            if (this.j == null) {
                throw new UnsupportedOperationException(ae.ecg);
            }
        }

        public boolean isVisible() {
            return this.l;
        }

        public void setVisible(boolean bl) {
            this.l = bl;
        }
    }
}

