/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.presentation;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.AnyLogicInternalCodegenAPI;
import com.anylogic.engine.Presentable;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.ae;
import com.anylogic.engine.internal.ga;
import com.anylogic.engine.internal.presentation.c;
import com.anylogic.engine.presentation.ShapeControl;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;

public class ShapeSlider
extends ShapeControl
implements ChangeListener {
    private static final long serialVersionUID = 9158151635131743046L;
    @AnyLogicInternalAPI
    public double value;
    private final JSlider a = new JSlider();
    private final ShapeControl.ValueType e;
    private double h;
    private double k;
    private int d;
    private int j;

    @Deprecated
    public ShapeSlider(Presentable presentable, boolean bl, int n2, int n3, int n4, int n5, Color color, boolean bl2, double d2, double d3) {
        this(presentable, bl, n2, n3, n4, n5, color, bl2, d2, d3, TYPE_DOUBLE);
    }

    @Deprecated
    public ShapeSlider(Presentable presentable, boolean bl, int n2, int n3, int n4, int n5, Color color, boolean bl2, double d2, double d3, ShapeControl.ValueType valueType) {
        this(presentable, bl, (double)n2, (double)n3, (double)n4, (double)n5, color, bl2, d2, d3, valueType);
    }

    public ShapeSlider(Presentable presentable, boolean bl, double d2, double d3, double d4, double d5, Color color, boolean bl2, double d6, double d7, ShapeControl.ValueType valueType) {
        this(presentable, bl, d2, d3, d4, d5, color, true, bl2, d6, d7, valueType);
    }

    public ShapeSlider(Presentable presentable, boolean bl, double d2, double d3, double d4, double d5, Color color, boolean bl2, boolean bl3, double d6, double d7, ShapeControl.ValueType valueType) {
        super(presentable, bl, d2, d3, d4, d5);
        if (ga.j() == 789) {
            this.a.setUI(new BasicSliderUI(this.a));
        }
        this.d = 100;
        this.j = 2;
        this.e = ShapeSlider.a(valueType);
        ShapeSlider.a(this.a, color);
        if (valueType == TYPE_DOUBLE) {
            this.a.setMinimum(0);
        }
        this.a.setOrientation(bl3 ? 1 : 0);
        this.setRange(d6, d7);
        c.a(this.a);
        this.setEnabled(bl2);
        this.a.addChangeListener(this);
    }

    private static ShapeControl.ValueType a(ShapeControl.ValueType valueType) {
        if (valueType != TYPE_DOUBLE && valueType != TYPE_INT) {
            throw new IllegalArgumentException(String.format(ae.fli, new Object[]{valueType, "TYPE_DOUBLE, TYPE_INT"}));
        }
        return valueType;
    }

    @Override
    @AnyLogicInternalCodegenAPI
    public void action() {
        this.mf.executeShapeControlAction(this.ib, this.hl, this.value);
    }

    @Override
    public JComponent getJComponent() {
        return this.a;
    }

    @Override
    public void setValueToDefault() {
        this.setValue(Utilities.limit(this.h, this.mf.getShapeControlDefaultValueDouble(this.ib, this.hl), this.k));
    }

    public void setValue(double d2) {
        this.setValue(d2, false);
    }

    public void setValue(double d2, boolean bl) {
        this.am = !bl;
        this.hf = true;
        if (this.e == TYPE_DOUBLE) {
            this.a.setValue(Utilities.roundToInt((d2 - this.h) / (this.k - this.h) * (double)this.d));
        } else {
            this.a.setValue(Utilities.roundToInt(d2));
        }
        this.hf = false;
        this.am = false;
    }

    public double getValue() {
        double d2;
        if (this.e == TYPE_DOUBLE) {
            d2 = this.h + (this.k - this.h) * (double)this.a.getValue() / (double)this.d;
            d2 *= Math.pow(10.0, this.j);
            d2 = Math.round(d2);
            if ((d2 /= Math.pow(10.0, this.j)) < this.h) {
                d2 = this.h;
            } else if (d2 > this.k) {
                d2 = this.k;
            }
        } else {
            d2 = this.a.getValue();
        }
        return d2;
    }

    public int getIntValue() {
        return (int)this.getValue();
    }

    public void setRange(double d2, double d3) {
        this.setRange(d2, d3, false);
    }

    public void setRange(double d2, double d3, boolean bl) {
        if (this.e == TYPE_INT) {
            d2 = Math.ceil(d2);
            d3 = Math.floor(d3);
        }
        if (d2 == 0.0 && d3 == 0.0) {
            d3 = 100.0;
        }
        if (d2 >= d3) {
            throw new RuntimeException(String.format(ae.lck, d2, d3));
        }
        if (d2 == this.h && d3 == this.k) {
            return;
        }
        this.h = d2;
        this.k = d3;
        this.am = !bl;
        this.hf = true;
        if (this.e == TYPE_DOUBLE) {
            double d4 = d3 - d2;
            int n2 = (int)(Math.log(d4) / Math.log(10.0));
            int n3 = 2 - n2;
            int n4 = this.a(d2);
            int n5 = this.a(d3);
            this.j = Math.max(Math.max(n4, n5), n3);
            while (true) {
                double d5 = Math.pow(10.0, this.j);
                this.d = (int)(d4 * d5);
                if (this.d != Integer.MAX_VALUE) break;
                --this.j;
            }
            this.a.setMaximum(this.d);
        } else {
            this.a.setMinimum((int)d2);
            this.a.setMaximum((int)d3);
        }
        this.hf = false;
        this.am = false;
    }

    public double getMin() {
        return this.h;
    }

    public double getMax() {
        return this.k;
    }

    @AnyLogicInternalAPI
    ShapeSlider(Presentable presentable, int n2, int n3) {
        super(presentable, n2, n3);
        if (ga.j() == 789) {
            this.a.setUI(new BasicSliderUI(this.a));
        }
        this.d = 100;
        this.j = 2;
        this.e = ShapeSlider.a(presentable.getShapeControlValueType(n2, n3));
        ShapeSlider.a(this.a, presentable.getShapeFillColor(n2, n3));
        ShapeSlider.e(this.a, presentable.getShapeLineColor(n2, n3));
        if (this.e == TYPE_DOUBLE) {
            this.a.setMinimum(0);
        }
        this.a.setOrientation(presentable.isShapeControlVertical(n2, n3) ? 1 : 0);
        this.setRange(presentable.getShapeControlMinimum(n2, n3), presentable.getShapeControlMaximum(n2, n3));
        c.a(this.a);
        this.setValueToDefault();
        this.a.addChangeListener(this);
    }

    @Override
    void b_() {
        this.value = this.getValue();
        super.b_();
    }

    @Override
    @AnyLogicInternalAPI
    public void update() {
        double d2 = this.mf.getShapeControlMinimum(this.ib, this.hl);
        double d3 = this.mf.getShapeControlMaximum(this.ib, this.hl);
        this.setRange(d2, d3, false);
    }

    private int a(double d2) {
        double d3;
        boolean bl = d2 == (double)((int)d2);
        int n2 = 0;
        if (bl) {
            double d4;
            while (--n2 >= -20 && (d4 = d2 * Math.pow(10.0, n2)) == (double)((int)d4)) {
            }
            return n2 + 1;
        }
        do {
            d3 = d2 * Math.pow(10.0, n2);
        } while (++n2 <= 20 && d3 != (double)((int)d3));
        return n2 - 1;
    }

    @Override
    @AnyLogicInternalAPI
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.a.getValueIsAdjusting()) {
            return;
        }
        this.a_();
    }
}

