/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.presentation;

import com.anylogic.engine.internal.ae;
import com.anylogic.engine.internal.ga;
import com.anylogic.engine.presentation.UtilitiesColor;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.URL;
import javax.imageio.ImageIO;

public class Texture
implements Paint,
Serializable {
    private static final long serialVersionUID = -590137493246379374L;
    private final String a;
    private final Color e;
    private final Color h;
    private final Color k;
    private final URL d;
    private final URL j;
    private final URL c;
    private final URL l;
    private final double f;
    private transient Paint i;

    Texture(String string, Color color, Color color2, Color color3, URL uRL, URL uRL2, URL uRL3, URL uRL4, double d2) {
        this.a = string;
        this.e = color;
        this.h = color2;
        this.k = color3;
        this.d = uRL != null ? uRL : uRL2;
        this.j = uRL2;
        this.c = uRL3;
        this.l = uRL4;
        this.f = uRL2 != null ? d2 : Double.NaN;
    }

    String a() {
        return this.a;
    }

    public String toString() {
        return this.a != null ? this.a : super.toString();
    }

    public Color getAmbientColor() {
        return this.e;
    }

    public Color getDiffuseColor() {
        return this.h;
    }

    public Color getSpecularColor() {
        return this.k;
    }

    public URL getTexture2D() {
        return this.d;
    }

    public URL getTexture3D() {
        return this.j;
    }

    public URL getTexture3DNormals_xjal() {
        return this.c;
    }

    public URL getTexture3DHeightMap_xjal() {
        return this.l;
    }

    public double getTexture3DScale() {
        return this.f;
    }

    public Paint getPaint_xjal() {
        if (this.i == null) {
            if (this.d != null) {
                try {
                    BufferedImage bufferedImage = ImageIO.read(this.d);
                    int n2 = bufferedImage.getWidth();
                    int n3 = bufferedImage.getHeight();
                    boolean bl = bufferedImage.getTransparency() != 1;
                    int[] nArray = new int[n2 * n3];
                    bufferedImage.getRGB(0, 0, n2, n3, nArray, 0, n2);
                    bufferedImage = null;
                    bufferedImage = ga.a(n2, n3, bl);
                    bufferedImage.setRGB(0, 0, n2, n3, nArray, 0, n2);
                    nArray = null;
                    this.i = new TexturePaint(bufferedImage, new Rectangle2D.Float(0.0f, 0.0f, n2, n3));
                }
                catch (IOException iOException) {
                    throw new RuntimeException(String.format(ae.kfh, this.d), iOException);
                }
            } else {
                this.i = this.h != null ? this.h : (this.e != null ? this.e : (this.k != null ? this.k : UtilitiesColor.transparent));
            }
        }
        return this.i;
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        return this.getPaint_xjal().createContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints);
    }

    @Override
    public int getTransparency() {
        return this.getPaint_xjal().getTransparency();
    }

    protected Object readResolve() throws ObjectStreamException {
        Texture texture;
        if (this.a != null && (texture = UtilitiesColor.a.get(this.a)) != null) {
            return texture;
        }
        return this;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.e == null ? 0 : this.e.hashCode());
        n2 = 31 * n2 + (this.h == null ? 0 : this.h.hashCode());
        n2 = 31 * n2 + (this.k == null ? 0 : this.k.hashCode());
        n2 = 31 * n2 + (this.d == null ? 0 : this.d.hashCode());
        n2 = 31 * n2 + (this.j == null ? 0 : this.j.hashCode());
        n2 = 31 * n2 + (this.c == null ? 0 : this.c.hashCode());
        long l2 = Double.doubleToLongBits(this.f);
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Texture texture = (Texture)object;
        if (this.e == null ? texture.e != null : !this.e.equals(texture.e)) {
            return false;
        }
        if (this.h == null ? texture.h != null : !this.h.equals(texture.h)) {
            return false;
        }
        if (this.k == null ? texture.k != null : !this.k.equals(texture.k)) {
            return false;
        }
        if (this.d == null ? texture.d != null : !this.d.equals(texture.d)) {
            return false;
        }
        if (this.j == null ? texture.j != null : !this.j.equals(texture.j)) {
            return false;
        }
        if (this.c == null ? texture.c != null : !this.c.equals(texture.c)) {
            return false;
        }
        return Double.doubleToLongBits(this.f) == Double.doubleToLongBits(texture.f);
    }
}

