/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mysema.query.sql.Beans;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.FactoryExpressionBase;
import com.mysema.query.types.Path;
import com.mysema.query.types.QBean;
import com.mysema.query.types.Visitor;
import com.mysema.util.ArrayUtils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QBeans
extends FactoryExpressionBase<Beans> {
    private static final long serialVersionUID = -4411839816134215923L;
    private final ImmutableMap<RelationalPath<?>, QBean<?>> qBeans;
    private final ImmutableList<Expression<?>> expressions;

    public QBeans(RelationalPath<?> ... beanPaths) {
        super(Beans.class);
        try {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            for (RelationalPath<?> path : beanPaths) {
                LinkedHashMap bindings = new LinkedHashMap();
                for (Path<?> column : path.getColumns()) {
                    bindings.put(column.getMetadata().getName(), column);
                    listBuilder.add(column);
                }
                mapBuilder.put(path, (Object)new QBean(path.getType(), bindings));
            }
            this.expressions = listBuilder.build();
            this.qBeans = mapBuilder.build();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public <R, C> R accept(Visitor<R, C> v, C context) {
        return (R)v.visit((FactoryExpression)this, context);
    }

    public List<Expression<?>> getArgs() {
        return this.expressions;
    }

    public Beans newInstance(Object ... args) {
        int offset = 0;
        HashMap<RelationalPath, Object> beans = new HashMap<RelationalPath, Object>();
        for (Map.Entry entry : this.qBeans.entrySet()) {
            RelationalPath path = (RelationalPath)entry.getKey();
            QBean qBean = (QBean)entry.getValue();
            int argsSize = qBean.getArgs().size();
            Object[] subArgs = ArrayUtils.subarray((Object[])args, (int)offset, (int)(offset + argsSize));
            beans.put(path, qBean.newInstance(subArgs));
            offset += argsSize;
        }
        return new Beans(beans);
    }
}

