/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.codegen;

import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.query.sql.codegen.NamingStrategy;
import com.mysema.query.sql.support.ForeignKeyData;
import com.mysema.query.sql.support.InverseForeignKeyData;
import com.mysema.query.sql.support.PrimaryKeyData;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class KeyDataFactory {
    private static final int FK_FOREIGN_COLUMN_NAME = 8;
    private static final int FK_FOREIGN_TABLE_NAME = 7;
    private static final int FK_FOREIGN_SCHEMA_NAME = 6;
    private static final int FK_NAME = 12;
    private static final int FK_PARENT_COLUMN_NAME = 4;
    private static final int FK_PARENT_TABLE_NAME = 3;
    private static final int FK_PARENT_SCHEMA_NAME = 2;
    private static final int PK_COLUMN_NAME = 4;
    private static final int PK_NAME = 6;
    private final NamingStrategy namingStrategy;
    private final String packageName;
    private final String prefix;
    private final String suffix;
    private final boolean schemaToPackage;

    public KeyDataFactory(NamingStrategy namingStrategy, String packageName, String prefix, String suffix, boolean schemaToPackage) {
        this.namingStrategy = namingStrategy;
        this.packageName = packageName;
        this.prefix = prefix;
        this.suffix = suffix;
        this.schemaToPackage = schemaToPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, InverseForeignKeyData> getExportedKeys(DatabaseMetaData md, String catalog, String schema, String tableName) throws SQLException {
        ResultSet foreignKeys = md.getExportedKeys(catalog, schema, tableName);
        HashMap<String, InverseForeignKeyData> inverseForeignKeyData = new HashMap<String, InverseForeignKeyData>();
        try {
            while (foreignKeys.next()) {
                InverseForeignKeyData data;
                String name = foreignKeys.getString(12);
                String parentColumnName = this.namingStrategy.normalizeColumnName(foreignKeys.getString(4));
                String foreignSchemaName = this.namingStrategy.normalizeSchemaName(foreignKeys.getString(6));
                String foreignTableName = this.namingStrategy.normalizeTableName(foreignKeys.getString(7));
                String foreignColumn = this.namingStrategy.normalizeColumnName(foreignKeys.getString(8));
                if (name == null || name.isEmpty()) {
                    name = tableName + "_" + foreignTableName + "_IFK";
                }
                if ((data = (InverseForeignKeyData)inverseForeignKeyData.get(name)) == null) {
                    data = new InverseForeignKeyData(name, foreignSchemaName, foreignTableName, this.createType(foreignSchemaName, foreignTableName));
                    inverseForeignKeyData.put(name, data);
                }
                data.add(parentColumnName, foreignColumn);
            }
            HashMap<String, InverseForeignKeyData> hashMap = inverseForeignKeyData;
            return hashMap;
        }
        finally {
            foreignKeys.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ForeignKeyData> getImportedKeys(DatabaseMetaData md, String catalog, String schema, String tableName) throws SQLException {
        ResultSet foreignKeys = md.getImportedKeys(catalog, schema, tableName);
        HashMap<String, ForeignKeyData> foreignKeyData = new HashMap<String, ForeignKeyData>();
        try {
            while (foreignKeys.next()) {
                ForeignKeyData data;
                String name = foreignKeys.getString(12);
                String parentSchemaName = this.namingStrategy.normalizeSchemaName(foreignKeys.getString(2));
                String parentTableName = this.namingStrategy.normalizeTableName(foreignKeys.getString(3));
                String parentColumnName = this.namingStrategy.normalizeColumnName(foreignKeys.getString(4));
                String foreignColumn = this.namingStrategy.normalizeColumnName(foreignKeys.getString(8));
                if (name == null || name.isEmpty()) {
                    name = tableName + "_" + parentTableName + "_FK";
                }
                if ((data = (ForeignKeyData)foreignKeyData.get(name)) == null) {
                    data = new ForeignKeyData(name, parentSchemaName, parentTableName, this.createType(parentSchemaName, parentTableName));
                    foreignKeyData.put(name, data);
                }
                data.add(foreignColumn, parentColumnName);
            }
            HashMap<String, ForeignKeyData> hashMap = foreignKeyData;
            return hashMap;
        }
        finally {
            foreignKeys.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PrimaryKeyData> getPrimaryKeys(DatabaseMetaData md, String catalog, String schema, String tableName) throws SQLException {
        ResultSet primaryKeys = md.getPrimaryKeys(catalog, schema, tableName);
        HashMap<String, PrimaryKeyData> primaryKeyData = new HashMap<String, PrimaryKeyData>();
        try {
            while (primaryKeys.next()) {
                PrimaryKeyData data;
                String name = primaryKeys.getString(6);
                String columnName = primaryKeys.getString(4);
                if (name == null || name.isEmpty()) {
                    name = tableName + "_PK";
                }
                if ((data = (PrimaryKeyData)primaryKeyData.get(name)) == null) {
                    data = new PrimaryKeyData(name);
                    primaryKeyData.put(name, data);
                }
                data.add(columnName);
            }
            HashMap<String, PrimaryKeyData> hashMap = primaryKeyData;
            return hashMap;
        }
        finally {
            primaryKeys.close();
        }
    }

    private Type createType(@Nullable String schemaName, String table) {
        String packageName = this.packageName;
        if (this.schemaToPackage && schemaName != null) {
            packageName = this.namingStrategy.appendSchema(packageName, schemaName);
        }
        String simpleName = this.prefix + this.namingStrategy.getClassName(table) + this.suffix;
        return new SimpleType(packageName + "." + simpleName, packageName, simpleName, new Type[0]);
    }
}

