/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.libraries.processmodeling;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AgentExtension;
import com.anylogic.engine.AgentExtensionFactory;
import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.ExtEntity;
import com.anylogic.engine.ExtEntityDelegate;
import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.anylogic.engine.TimeUnits;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.markup.INetwork;
import com.anylogic.engine.markup.INode;
import com.anylogic.libraries.processmodeling.IResourceUnit;
import com.anylogic.libraries.processmodeling.Messages;
import com.anylogic.libraries.processmodeling.ResourcePool;
import com.anylogic.libraries.processmodeling.ResourceRequest;
import com.anylogic.libraries.processmodeling.ResourceTaskType;
import com.anylogic.libraries.processmodeling.ResourceType;
import com.anylogic.libraries.processmodeling.ResourceUnitEntityServiceSubtask;
import com.anylogic.libraries.processmodeling.ResourceUnitTask;
import com.anylogic.libraries.processmodeling.ResourceUsageState;
import com.anylogic.libraries.processmodeling.TaskPreemptionPolicy;
import com.anylogic.libraries.processmodeling.n;
import com.anylogic.libraries.processmodeling.v;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;

public class ResourceUnitExtension
extends ExtEntityDelegate<ExtEntity>
implements IResourceUnit,
Serializable {
    private static final long serialVersionUID = 1L;
    private ResourceUnitTask d;
    private double e;
    private LinkedList<ResourceUnitTask> f = null;
    @AnyLogicCustomSerialization
    private transient ResourcePool g;
    private int i;
    ResourceRequest b;
    @AnyLogicCustomSerialization
    transient n c = null;
    private double j;
    private double k;
    private ResourceUsageState l = ResourceUsageState.USAGE_NOT_COUNTED;
    private double m;
    private static final Set<Class<?>> n = ResourceUnitExtension.getSupportedInterfaces_xjal(ResourceUnitExtension.class);

    static void a() {
        AgentExtensionFactory<ResourceUnitExtension> agentExtensionFactory = new AgentExtensionFactory<ResourceUnitExtension>(){

            private static ResourceUnitExtension a(Agent agent) {
                return new ResourceUnitExtension(agent);
            }

            public final /* synthetic */ AgentExtension create(Agent agent) {
                return 1.a(agent);
            }
        };
        AgentExtensionFactory.register(ResourceUnitExtension.class, (AgentExtensionFactory)agentExtensionFactory);
    }

    @AnyLogicInternalAPI
    public boolean supportsInteface_xjal(Class<?> clazz) {
        return n.contains(clazz);
    }

    public Class<ExtEntity> extClass() {
        return ExtEntity.class;
    }

    public ResourceUnitExtension(Agent agent) {
        super(agent);
        this.j();
    }

    final void a(int n2) {
        this.i = n2;
    }

    final int b() {
        return this.i;
    }

    @AnyLogicInternalAPI
    public void setResourcePool(ResourcePool resourcePool) {
        this.g = resourcePool;
    }

    @Override
    public final ResourcePool resourcePool() {
        return this.g;
    }

    @Override
    public ResourceType getResourceType() {
        return this.resourcePool().type;
    }

    @Override
    public boolean isBusy() {
        return this.d != null;
    }

    @Override
    public boolean isIdle() {
        return this.d == null;
    }

    private boolean i() {
        return this.d != null || this.f == null || this.f.isEmpty();
    }

    final ResourceUnitTask c() {
        if (this.f != null) {
            return this.f.peek();
        }
        return null;
    }

    final boolean d() {
        ResourceUnitTask resourceUnitTask;
        if (this.d != null) {
            this.error("Internal error: polling internal queue %s while there is currentTask %s", new Object[]{this.f, this.d});
        }
        if ((resourceUnitTask = this.f != null ? this.f.poll() : null) != null) {
            this.a(resourceUnitTask, null);
        }
        return resourceUnitTask != null;
    }

    private ResourceUnitTask a(ResourceUnitTask resourceUnitTask, TaskPreemptionPolicy taskPreemptionPolicy) {
        ResourceUnitTask resourceUnitTask2 = this.d;
        if (resourceUnitTask == resourceUnitTask2) {
            return resourceUnitTask2;
        }
        this.g.a(this, resourceUnitTask2, resourceUnitTask);
        if (resourceUnitTask2 != null) {
            resourceUnitTask2.setUnit(null);
        }
        this.d = resourceUnitTask;
        this.e = this.getAgent().time();
        if (resourceUnitTask != null) {
            if (resourceUnitTask2 != null) {
                ResourceUnitEntityServiceSubtask resourceUnitEntityServiceSubtask;
                switch (taskPreemptionPolicy) {
                    case PP_SEIZE_ANY_RESOURCE: {
                        resourceUnitEntityServiceSubtask = this.c(resourceUnitTask2);
                        resourceUnitEntityServiceSubtask.onSuspend();
                        break;
                    }
                    case PP_TERMINATE_SERVING: 
                    case PP_CONTINUE_WITHOUT_RESOURCE: {
                        resourceUnitTask2.onTerminate();
                        break;
                    }
                    case PP_WAIT_FOR_ORIGINAL_RESOURCE: {
                        resourceUnitEntityServiceSubtask = this.c(resourceUnitTask2);
                        resourceUnitEntityServiceSubtask.onSuspend();
                        if (this.f == null) {
                            this.f = new LinkedList();
                        }
                        this.f.addFirst(resourceUnitTask2);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Internal error. Reason of preemption = " + (Object)((Object)taskPreemptionPolicy));
                    }
                }
                resourceUnitEntityServiceSubtask = this.currentBlock();
                if (resourceUnitEntityServiceSubtask != null) {
                    resourceUnitEntityServiceSubtask.remove(this.getAgent());
                }
            }
            resourceUnitTask.setUnit(this.getAgent());
            this.setUsageState(resourceUnitTask.usageState());
            resourceUnitTask.onStart();
        } else {
            this.setUsageState(ResourceUsageState.USAGE_IDLE);
        }
        this.g.a(this, resourceUnitTask2, resourceUnitTask, taskPreemptionPolicy);
        return resourceUnitTask2;
    }

    public void setUsageState(ResourceUsageState resourceUsageState) {
        if (resourceUsageState == this.l) {
            return;
        }
        switch (this.l) {
            case USAGE_BUSY: {
                this.j = this.timeInState(this.l);
                break;
            }
            case USAGE_IDLE: {
                this.k = this.timeInState(this.l);
            }
        }
        this.l = resourceUsageState;
        this.m = this.getAgent().time();
    }

    @Override
    public double timeInState(ResourceUsageState resourceUsageState) {
        double d2;
        switch (resourceUsageState) {
            case USAGE_BUSY: {
                d2 = this.j;
                break;
            }
            case USAGE_IDLE: {
                d2 = this.k;
                break;
            }
            default: {
                return 0.0;
            }
        }
        if (resourceUsageState == this.l) {
            d2 += this.getAgent().time() - this.m;
        }
        return d2;
    }

    @Override
    public double timeInState(ResourceUsageState resourceUsageState, TimeUnits timeUnits) {
        return this.getAgent().toTimeUnits(this.timeInState(resourceUsageState), timeUnits);
    }

    @Override
    public double getUtilization() {
        double d2 = this.timeInState(ResourceUsageState.USAGE_BUSY);
        double d3 = this.timeInState(ResourceUsageState.USAGE_IDLE);
        return Utilities.zidz((double)d2, (double)(d2 + d3));
    }

    @Override
    public void resetStats() {
        this.k = 0.0;
        this.j = 0.0;
        this.m = this.getAgent().time();
    }

    public String toString() {
        return Messages.a(Messages.l, this.resourcePool().getFullName(), this.isBusy() ? Messages.a(Messages.m) : Messages.a(Messages.n), 0);
    }

    private void j() {
        this.e = this.m = this.getAgent().time();
    }

    final void a(ResourceUnitTask resourceUnitTask) {
        this.removeTask(resourceUnitTask);
    }

    @Override
    public boolean isReserved() {
        return this.b != null;
    }

    @Override
    public Agent getReservedBy() {
        if (this.b != null) {
            return this.b.b;
        }
        return null;
    }

    final boolean b(ResourceUnitTask resourceUnitTask) {
        ResourceUnitTask resourceUnitTask2 = this.currentTask();
        if (resourceUnitTask2 == null) {
            return true;
        }
        return resourceUnitTask2.mayBePreemptedBy(resourceUnitTask);
    }

    @Override
    public void addTask(ResourceUnitTask resourceUnitTask) {
        if (this.d != null) {
            if (this.d.mayBePreemptedBy(resourceUnitTask)) {
                ResourceUnitTask resourceUnitTask2 = this.d;
                this.a(resourceUnitTask, resourceUnitTask2.preemptionPolicy());
                return;
            }
            if (this.f == null) {
                this.f = new LinkedList();
            }
            if (this.f.isEmpty()) {
                this.f.add(resourceUnitTask);
                return;
            }
            ListIterator<ResourceUnitTask> listIterator = this.f.listIterator(this.f.size());
            while (listIterator.hasPrevious()) {
                ResourceUnitTask resourceUnitTask3 = listIterator.previous();
                if (!resourceUnitTask3.mayBePreemptedBy(resourceUnitTask)) {
                    listIterator.next();
                    listIterator.add(resourceUnitTask);
                    while (listIterator.hasNext()) {
                        ResourceUnitExtension.a(listIterator);
                    }
                    return;
                }
                if (listIterator.hasPrevious()) continue;
                listIterator.add(resourceUnitTask);
            }
            return;
        }
        if (this.f != null) {
            Iterator<ResourceUnitTask> iterator = this.f.iterator();
            while (iterator.hasNext()) {
                ResourceUnitExtension.a(iterator);
            }
        }
        this.a(resourceUnitTask, null);
    }

    private ResourceUnitEntityServiceSubtask c(ResourceUnitTask resourceUnitTask) {
        if (!(resourceUnitTask instanceof ResourceUnitEntityServiceSubtask)) {
            this.error("Only entity service task may have %s preemption policy: %s (trying to add to pool %s)", new Object[]{resourceUnitTask.preemptionPolicy(), resourceUnitTask, Utilities.getFullName((Agent)this.g)});
        }
        return (ResourceUnitEntityServiceSubtask)resourceUnitTask;
    }

    private static void a(Iterator<ResourceUnitTask> iterator) {
        ResourceUnitTask resourceUnitTask = iterator.next();
        if (resourceUnitTask.preemptionPolicy() == TaskPreemptionPolicy.PP_TERMINATE_SERVING) {
            resourceUnitTask.onTerminate();
            iterator.remove();
        }
    }

    @Override
    public void removeTask(ResourceUnitTask resourceUnitTask) {
        if (resourceUnitTask == this.d) {
            this.a(null, null);
            return;
        }
        if (this.f != null) {
            this.f.remove(resourceUnitTask);
        }
    }

    @Override
    @AnyLogicInternalAPI
    public final ResourceUnitTask currentTask() {
        return this.f();
    }

    @Override
    public final ResourceTaskType currentTaskType() {
        ResourceUnitTask resourceUnitTask = this.currentTask();
        if (resourceUnitTask != null) {
            return resourceUnitTask.taskType();
        }
        return null;
    }

    @AnyLogicInternalAPI
    public final double currentTaskStartTime() {
        return this.e;
    }

    final ResourceUnitTask f() {
        return this.d;
    }

    private boolean d(ResourceUnitTask resourceUnitTask) {
        return this.d == resourceUnitTask || this.f != null && this.f.contains(resourceUnitTask);
    }

    @Override
    public Agent getServicedEntity() {
        ResourceUnitTask resourceUnitTask = this.currentTask();
        if (resourceUnitTask instanceof ResourceUnitEntityServiceSubtask) {
            return ((ResourceUnitEntityServiceSubtask)resourceUnitTask).getEntity();
        }
        return null;
    }

    final Agent g() {
        return v.a(this.currentTask());
    }

    @Override
    public void setHomeLocation(INode iNode) {
        if (this.c != null && this.c.a != iNode) {
            this.g.c().a.a(this.c);
            this.c = null;
        }
        if (this.c == null && iNode != null) {
            this.c = this.g.c().a.a(iNode, this.getAgent());
        }
    }

    final void a(n n2) {
        if (this.c != null) {
            this.error("homeLocation != null");
        }
        if (!this.isAutomaticHorizontalRotation()) {
            n2.rotation = Double.NaN;
        } else if (!this.isAutomaticVerticalRotation()) {
            n2.verticalRotation = Double.NaN;
        }
        this.c = n2;
        this.setNetworkNode(n2.a, (Point)n2);
    }

    @Override
    public INode getHomeLocation() {
        if (this.c != null) {
            return this.c.a;
        }
        return null;
    }

    @Override
    public void setHomePosition(double d2, double d3) {
        this.setHomePosition(d2, d3, 0.0);
    }

    @Override
    public void setHomePosition(double d2, double d3, double d4) {
        if (this.c != null && this.c.a != null) {
            this.g.c().a.a(this.c);
        }
        if (this.c == null) {
            this.c = new n();
        }
        this.c.setLocation(d2, d3, d4);
    }

    @Override
    public double getHomeX() {
        if (this.c != null) {
            return this.c.x;
        }
        return 0.0;
    }

    @Override
    public double getHomeY() {
        if (this.c != null) {
            return this.c.y;
        }
        return 0.0;
    }

    @Override
    public double getHomeZ() {
        if (this.c != null) {
            return this.c.z;
        }
        return 0.0;
    }

    @Override
    public double getHomeRotation() {
        if (this.c != null) {
            return this.c.rotation;
        }
        return 0.0;
    }

    @Override
    public void setAttached(boolean bl) {
        if (!(this.d instanceof ResourceUnitEntityServiceSubtask)) {
            this.error("ResourceUnit should be occupied with entity-service task");
        }
        ResourceUnitEntityServiceSubtask resourceUnitEntityServiceSubtask = (ResourceUnitEntityServiceSubtask)this.d;
        this.setAttached(bl ? resourceUnitEntityServiceSubtask.getEntity() : null);
    }

    public void setAttached(Agent agent) {
        if (!(this.d instanceof ResourceUnitEntityServiceSubtask)) {
            this.error("ResourceUnit should be occupied with entity-service task");
        }
        ResourceUnitEntityServiceSubtask resourceUnitEntityServiceSubtask = (ResourceUnitEntityServiceSubtask)this.d;
        boolean bl = agent == null && resourceUnitEntityServiceSubtask.getAttachedTo() != null;
        INode iNode = null;
        INetwork iNetwork = null;
        if (bl) {
            this.updatePosition();
            iNode = this.getNetworkNode();
            iNetwork = this.getNetwork();
        }
        resourceUnitEntityServiceSubtask.a(agent);
        if (bl) {
            this.setNetworkNode(iNode);
            if (iNode == null) {
                this.setNetwork(iNetwork);
            }
        }
    }

    final Agent h() {
        if (this.d instanceof ResourceUnitEntityServiceSubtask) {
            return ((ResourceUnitEntityServiceSubtask)this.d).getAttachedTo();
        }
        return null;
    }

    @Override
    public boolean isAttached() {
        if (!(this.d instanceof ResourceUnitEntityServiceSubtask)) {
            return false;
        }
        ResourceUnitEntityServiceSubtask resourceUnitEntityServiceSubtask = (ResourceUnitEntityServiceSubtask)this.d;
        return resourceUnitEntityServiceSubtask.getAttachedTo() == resourceUnitEntityServiceSubtask.getEntity();
    }

    public double getAnimationX() {
        double d2 = super.getAnimationX();
        if (this.d instanceof ResourceUnitEntityServiceSubtask) {
            ResourceUnitEntityServiceSubtask resourceUnitEntityServiceSubtask = (ResourceUnitEntityServiceSubtask)this.d;
            Agent agent = resourceUnitEntityServiceSubtask.getAttachedTo();
            int n2 = resourceUnitEntityServiceSubtask.a();
            if (agent != null && n2 >= 0) {
                double d3 = agent.getRotation();
                double d4 = (double)(n2 + 1) * this.g.c().offsetForAttachedUnits;
                d2 -= Math.cos(d3) * d4;
            }
        }
        return d2;
    }

    public double getAnimationY() {
        double d2 = super.getAnimationY();
        if (this.d instanceof ResourceUnitEntityServiceSubtask) {
            ResourceUnitEntityServiceSubtask resourceUnitEntityServiceSubtask = (ResourceUnitEntityServiceSubtask)this.d;
            Agent agent = resourceUnitEntityServiceSubtask.getAttachedTo();
            int n2 = resourceUnitEntityServiceSubtask.a();
            if (agent != null && n2 >= 0) {
                double d3 = agent.getRotation();
                double d4 = (double)(n2 + 1) * this.g.c().offsetForAttachedUnits;
                d2 -= Math.sin(d3) * d4;
            }
        }
        return d2;
    }

    public Position getAnimationPosition(Position position) {
        position = super.getAnimationPosition(position);
        if (this.d instanceof ResourceUnitEntityServiceSubtask) {
            ResourceUnitEntityServiceSubtask resourceUnitEntityServiceSubtask = (ResourceUnitEntityServiceSubtask)this.d;
            Agent agent = resourceUnitEntityServiceSubtask.getAttachedTo();
            int n2 = resourceUnitEntityServiceSubtask.a();
            if (agent != null && n2 >= 0) {
                double d2 = agent.getRotation();
                double d3 = (double)(n2 + 1) * this.g.c().offsetForAttachedUnits;
                position.x -= Math.cos(d2) * d3;
                position.y -= Math.sin(d2) * d3;
            }
        }
        return position;
    }

    public void updatePosition() {
        if (this.d instanceof ResourceUnitEntityServiceSubtask) {
            ResourceUnitEntityServiceSubtask resourceUnitEntityServiceSubtask = (ResourceUnitEntityServiceSubtask)this.d;
            if ((resourceUnitEntityServiceSubtask = resourceUnitEntityServiceSubtask.getAttachedTo()) != null) {
                resourceUnitEntityServiceSubtask = resourceUnitEntityServiceSubtask.getPosition();
                Agent agent = this.getAgent();
                if (!this.isAutomaticHorizontalRotation()) {
                    agent.setXYZ((Point)resourceUnitEntityServiceSubtask);
                    return;
                }
                if (!this.isAutomaticVerticalRotation()) {
                    agent.setXYZ((Point)resourceUnitEntityServiceSubtask);
                    agent.setRotation(((Position)resourceUnitEntityServiceSubtask).rotation);
                    return;
                }
                agent.setPosition((Position)resourceUnitEntityServiceSubtask);
                return;
            }
        }
        super.updatePosition();
    }

    public INode getNetworkNode() {
        if (this.d instanceof ResourceUnitEntityServiceSubtask) {
            ResourceUnitEntityServiceSubtask resourceUnitEntityServiceSubtask = (ResourceUnitEntityServiceSubtask)this.d;
            if ((resourceUnitEntityServiceSubtask = resourceUnitEntityServiceSubtask.getAttachedTo()) != null) {
                return resourceUnitEntityServiceSubtask.getNetworkNode();
            }
        }
        return super.getNetworkNode();
    }

    public void setNetworkNode(INode iNode) {
        this.k();
        super.setNetworkNode(iNode);
    }

    public void setNetworkNode(INode iNode, Point point) {
        this.k();
        super.setNetworkNode(iNode, point);
    }

    public void setNetwork(INetwork iNetwork) {
        this.k();
        super.setNetwork(iNetwork);
    }

    private void k() {
        if (this.isAttached()) {
            this.error("This operation is not supported for attached resource units");
        }
    }

    final boolean a(Agent agent) {
        ResourceUnitTask resourceUnitTask = this.currentTask();
        return resourceUnitTask instanceof ResourceUnitEntityServiceSubtask && ((ResourceUnitEntityServiceSubtask)resourceUnitTask).b.b == agent;
    }
}

